/*
 * Decompiled with CFR 0.152.
 */
package adaptorinterface;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourcePropertyRepresentation implements Enumerator
{
    REFERENCE(0, "reference", "reference"),
    INLINE(1, "inline", "inline"),
    EITHER(2, "either", "either"),
    NA(3, "n_a", "n_a");

    public static final int REFERENCE_VALUE = 0;
    public static final int INLINE_VALUE = 1;
    public static final int EITHER_VALUE = 2;
    public static final int NA_VALUE = 3;
    private static final ResourcePropertyRepresentation[] VALUES_ARRAY;
    public static final List<ResourcePropertyRepresentation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourcePropertyRepresentation[]{REFERENCE, INLINE, EITHER, NA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResourcePropertyRepresentation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourcePropertyRepresentation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourcePropertyRepresentation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourcePropertyRepresentation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourcePropertyRepresentation get(int value) {
        switch (value) {
            case 0: {
                return REFERENCE;
            }
            case 1: {
                return INLINE;
            }
            case 2: {
                return EITHER;
            }
            case 3: {
                return NA;
            }
        }
        return null;
    }

    private ResourcePropertyRepresentation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

