/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration.description;

import java.util.Iterator;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.Group;
import org.osgi.framework.Version;

public class RemoveOldMigrationAnnotations
extends AbstractVSMMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("6.5.0.201210011230");

    @Override
    public void postLoad(Group group, Version loadedVersion) {
        super.postLoad(group, loadedVersion);
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            this.deleteOldMigrationAnnotations(group);
        }
    }

    private void deleteOldMigrationAnnotations(Group group) {
        Iterator iterator = group.getEAnnotations().iterator();
        while (iterator.hasNext()) {
            DAnnotation entry = (DAnnotation)iterator.next();
            if (!entry.getSource().equals("Migration")) continue;
            iterator.remove();
        }
    }

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }
}

