/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.toolchain.design;

import adaptorinterface.AdaptorinterfacePackage;
import adaptorinterface.DomainSpecification;
import adaptorinterface.Specification;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import toolchain.Toolchain;
import toolchain.ToolchainPackage;
import vocabulary.Vocabularies;
import vocabulary.Vocabulary;
import vocabulary.VocabularyPackage;

public class EmfResourcesLoaderService {
    public Collection<DomainSpecification> getLoadedDomainSpecifications(EObject self) {
        Session session = SessionManager.INSTANCE.getSession(self);
        return this.getSessionDomainSpecifications(session);
    }

    public Collection<Vocabulary> getLoadedVocabularies(EObject self) {
        Session session = SessionManager.INSTANCE.getSession(self);
        return this.getSessionVocabularies(session);
    }

    private Collection<DomainSpecification> getSessionDomainSpecifications(Session session) {
        BasicEList eList = new BasicEList();
        Collection semanticResources = session.getSemanticResources();
        for (Resource semanticResource : semanticResources) {
            for (EObject topEObject : semanticResource.getContents()) {
                Specification specification = this.getSpecification(topEObject);
                if (specification == null) continue;
                eList.addAll(specification.getDomainSpecifications());
            }
        }
        return eList;
    }

    private Specification getSpecification(EObject topEObject) {
        Specification specification = null;
        if (topEObject.eClass().equals(ToolchainPackage.eINSTANCE.getToolchain())) {
            Toolchain toolchain = (Toolchain)topEObject;
            specification = toolchain.getSpecification();
        }
        if (topEObject.eClass().equals(AdaptorinterfacePackage.eINSTANCE.getSpecification())) {
            specification = (Specification)topEObject;
        }
        return specification;
    }

    private Collection<Vocabulary> getSessionVocabularies(Session session) {
        BasicEList eList = new BasicEList();
        Collection semanticResources = session.getSemanticResources();
        for (Resource semanticResource : semanticResources) {
            for (EObject topEObject : semanticResource.getContents()) {
                Vocabularies vocabularies = this.getVocabularies(topEObject);
                if (vocabularies == null) continue;
                eList.addAll(vocabularies.getVocabularies());
            }
        }
        return eList;
    }

    private Vocabularies getVocabularies(EObject topEObject) {
        Vocabularies vocabularies = null;
        if (topEObject.eClass().equals(ToolchainPackage.eINSTANCE.getToolchain())) {
            Toolchain toolchain = (Toolchain)topEObject;
            vocabularies = toolchain.getVocabularies();
        } else if (topEObject.eClass().equals(VocabularyPackage.eINSTANCE.getVocabularies())) {
            vocabularies = (Vocabularies)topEObject;
        }
        return vocabularies;
    }
}

