/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.api.interaction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.query.DTreeItemQuery;
import org.eclipse.sirius.tree.business.api.query.TreeDescriptionQuery;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.DTreeRefresh;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.tools.internal.Messages;

public class DTreeItemUserInteraction {
    private DTreeItem item;
    private GlobalContext ctx;

    public DTreeItemUserInteraction(DTreeItem item, GlobalContext ctx) {
        this.item = item;
        this.ctx = ctx;
    }

    public void expand() {
        this.expand((IProgressMonitor)new NullProgressMonitor());
    }

    public void expand(IProgressMonitor monitor) {
        this.item.setExpanded(true);
        this.refreshContent(false, monitor);
    }

    public void expandAll(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.DTreeItemUserInteraction_treeItemExpanding, this.item.getOwnedTreeItems().size() + 1);
            this.expand((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (DTreeItem child : this.item.getOwnedTreeItems()) {
                new DTreeItemUserInteraction(child, this.ctx).expandAll((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public void refreshContent() {
        this.refreshContent(false);
    }

    public void refreshContent(boolean fullRefresh) {
        this.refreshContent(fullRefresh, (IProgressMonitor)new NullProgressMonitor());
    }

    public void refreshContent(boolean fullRefresh, IProgressMonitor monitor) {
        SemanticPartitionInvalidator invalidator = new SemanticPartitionInvalidator();
        Option<DTree> parentTree = new DTreeItemQuery(this.item).getParentTree();
        if (parentTree.some()) {
            DTreeRefresh refresher = new DTreeRefresh(this.item, new TreeDescriptionQuery(((DTree)parentTree.get()).getDescription()).getAllDescendantMappings(), invalidator, this.ctx);
            refresher.refresh(fullRefresh, monitor);
        }
    }

    public void directEdit(String newLabel) {
    }

    public void collapse() {
        this.collapse((IProgressMonitor)new NullProgressMonitor());
    }

    public void collapse(IProgressMonitor monitor) {
        this.item.setExpanded(false);
    }
}

