/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.business.internal.session.factory.SessionFactoryDescriptor;

public final class SessionFactoryRegistry {
    private static final List<SessionFactoryDescriptor> EXTENSIONS = new ArrayList<SessionFactoryDescriptor>();
    private static final Map<String, SessionFactoryDescriptor> ID_TO_DESCRITPOR_MAP = new HashMap<String, SessionFactoryDescriptor>();

    private SessionFactoryRegistry() {
    }

    public static void addExtension(SessionFactoryDescriptor extension) {
        EXTENSIONS.add(extension);
        ID_TO_DESCRITPOR_MAP.put(extension.getId(), extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        ID_TO_DESCRITPOR_MAP.clear();
    }

    public static List<SessionFactoryDescriptor> getRegisteredExtensions() {
        return new ArrayList<SessionFactoryDescriptor>(EXTENSIONS);
    }

    public static void removeExtension(String id) {
        for (SessionFactoryDescriptor extension : SessionFactoryRegistry.getRegisteredExtensions()) {
            if (!extension.getId().equals(id)) continue;
            EXTENSIONS.remove(extension);
            ID_TO_DESCRITPOR_MAP.remove(extension.getId());
        }
    }

    public static SessionFactoryDescriptor getDescriptorFromId(String id) {
        return ID_TO_DESCRITPOR_MAP.get(id);
    }
}

