/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class BreakpointsComparator
extends ViewerComparator {
    public boolean isSorterProperty(Object element, String propertyId) {
        return propertyId.equals("org.eclipse.jface.text");
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String name2;
        IMarker marker2;
        String type2;
        String type1;
        int result;
        IBreakpoint b2;
        IBreakpoint b1;
        block17: {
            String modelId2;
            if (!(e1 instanceof IBreakpoint)) {
                return super.compare(viewer, e1, e2);
            }
            b1 = (IBreakpoint)e1;
            b2 = (IBreakpoint)e2;
            String modelId1 = b1.getModelIdentifier();
            result = modelId1.compareTo(modelId2 = b2.getModelIdentifier());
            if (result != 0) {
                return result;
            }
            type1 = "";
            type2 = "";
            IMarker marker1 = b1.getMarker();
            if (!marker1.exists()) {
                return 0;
            }
            try {
                type1 = marker1.getType();
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
            marker2 = b2.getMarker();
            if (marker2.exists()) break block17;
            return 0;
        }
        try {
            type2 = marker2.getType();
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        result = type1.compareTo(type2);
        if (result != 0) {
            return result;
        }
        ILabelProvider lprov = (ILabelProvider)((StructuredViewer)viewer).getLabelProvider();
        String name1 = lprov.getText(e1);
        result = this.numericalStringCompare(name1, name2 = lprov.getText(e2));
        if (result != 0) {
            return result;
        }
        int l1 = 0;
        int l2 = 0;
        if (b1 instanceof ILineBreakpoint) {
            try {
                l1 = ((ILineBreakpoint)b1).getLineNumber();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        if (b2 instanceof ILineBreakpoint) {
            try {
                l2 = ((ILineBreakpoint)b2).getLineNumber();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        if (l1 != l2) {
            result = l1 - l2;
        }
        return result;
    }

    int numericalStringCompare(String n1, String n2) {
        int index1 = 0;
        int index2 = 0;
        int digitLen = 0;
        while (index1 < n1.length() && index2 < n2.length()) {
            char c2;
            char c1 = n1.charAt(index1);
            if (c1 != (c2 = n2.charAt(index2))) {
                boolean isDig1 = Character.isDigit(c1);
                boolean isDig2 = Character.isDigit(c2);
                if (isDig1 && isDig2 || digitLen > 0 && (isDig1 || isDig2)) {
                    DecimalFormat format = new DecimalFormat();
                    ParsePosition p1 = new ParsePosition(index1 - digitLen);
                    Number num1 = format.parse(n1, p1);
                    ParsePosition p2 = new ParsePosition(index2 - digitLen);
                    Number num2 = format.parse(n2, p2);
                    if (num1 == null || num2 == null) {
                        return c1 - c2;
                    }
                    int cmp = num1 instanceof Long && num2 instanceof Long ? ((Long)num1).compareTo((Long)num2) : Double.compare(num1.doubleValue(), num2.doubleValue());
                    if (cmp != 0) {
                        return cmp;
                    }
                    index1 = p1.getIndex();
                    index2 = p2.getIndex();
                    digitLen = 0;
                    continue;
                }
                return c1 - c2;
            }
            digitLen = Character.isDigit(c1) ? ++digitLen : 0;
            ++index1;
            ++index2;
        }
        return n1.length() - index1 - (n2.length() - index2);
    }
}

