/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.ValidateUtils;

public interface OpenSshCertificate
extends PublicKey,
PrivateKey {
    public static final long MIN_EPOCH = 0L;
    public static final long INFINITY = -1L;

    public String getRawKeyType();

    public byte[] getNonce();

    public String getKeyType();

    public PublicKey getCertPubKey();

    public long getSerial();

    public Type getType();

    public String getId();

    public Collection<String> getPrincipals();

    public long getValidAfter();

    public long getValidBefore();

    public List<CertificateOption> getCriticalOptions();

    public List<CertificateOption> getExtensions();

    public String getReserved();

    public PublicKey getCaPubKey();

    public byte[] getMessage();

    public byte[] getSignature();

    public String getSignatureAlgorithm();

    public byte[] getRawSignature();

    public static boolean isValidNow(OpenSshCertificate cert) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        return Long.compareUnsigned(cert.getValidAfter(), now) <= 0 && Long.compareUnsigned(now, cert.getValidBefore()) < 0;
    }

    public static class CertificateOption {
        private final String name;
        private final String data;

        public CertificateOption(String name, String data) {
            this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "CertificateOption name must be set");
            this.data = data;
        }

        public CertificateOption(String name) {
            this(name, null);
        }

        public final String getName() {
            return this.name;
        }

        public final String getData() {
            return this.data;
        }

        public String toString() {
            return "CriticalOption{name='" + this.name + "', data='" + this.data + "'}";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CertificateOption other = (CertificateOption)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.data, other.data);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.data);
        }
    }

    public static enum Type {
        USER,
        HOST;


        public int getCode() {
            return this.ordinal() + 1;
        }

        public static Type fromCode(int code) {
            return Type.values()[code - 1];
        }
    }
}

