/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementType;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.DefaultMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.EClassUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class MetamodelType
extends ElementType
implements IMetamodelType {
    private IEditHelper editHelper;

    public MetamodelType(String id, URL iconURL, String displayName, EClass eClass, IEditHelper editHelper) {
        super(id, iconURL, displayName, eClass);
        this.editHelper = editHelper;
    }

    public MetamodelType(IMetamodelTypeDescriptor descriptor) {
        this(descriptor.getId(), descriptor.getIconURL(), descriptor.getName(), descriptor.getEClass(), descriptor.getEditHelper());
    }

    @Override
    public IEditHelper getEditHelper() {
        if (this.editHelper == null) {
            IElementType[] superTypes = this.getAllSuperTypes();
            this.editHelper = superTypes.length > 0 ? superTypes[superTypes.length - 1].getEditHelper() : DefaultMetamodelType.getInstance().getEditHelper();
        }
        return this.editHelper;
    }

    @Override
    public ICommand getEditCommand(IEditCommandRequest request) {
        return this.getEditHelper().getEditCommand(request);
    }

    @Override
    public IElementType[] getAllSuperTypes() {
        if (super.getAllSuperTypes() == null) {
            IClientContext context = ClientContextManager.getInstance().getBinding(this);
            LinkedHashSet<IElementType> result = new LinkedHashSet<IElementType>();
            if (this.getEClass() != null) {
                List<EClass> supertypes = EClassUtil.getEAllSuperTypes(this.getEClass());
                int i = 0;
                while (i < supertypes.size()) {
                    EClass nextEClass = supertypes.get(i);
                    IElementType nextElementType = ElementTypeRegistry.getInstance().getElementType(nextEClass, context);
                    if (nextElementType != null && nextElementType != DefaultMetamodelType.getInstance()) {
                        result.add(nextElementType);
                    }
                    ++i;
                }
            }
            this.setAllSupertypes(result.toArray(new IElementType[0]));
        }
        return super.getAllSuperTypes();
    }

    public String toString() {
        return "MetamodelType[" + this.getId() + "]";
    }
}

