/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.PrinterName;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class ColorBlock
extends DialogBlock {
    private final DataBindingContext bindings;
    private final PrintOptions options;
    private Button colorRadio;
    private Button monoRadio;
    private Binding colorBinding;
    private Binding monoBinding;

    ColorBlock(DialogBlock.IDialogUnitConverter dluConverter, DataBindingContext bindings, PrintOptions options) {
        super(dluConverter);
        this.bindings = bindings;
        this.options = options;
    }

    @Override
    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        Group result = this.group(parent, DiagramUIPrintingMessages.JPSOptionsDialog_Color);
        ColorBlock.layout((Composite)result, 2);
        this.colorRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSOptionsDialog_ChromaticityColor);
        this.layoutSpanHorizontal((Control)this.colorRadio, 4);
        this.monoRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSOptionsDialog_ChromaticityMonochrome);
        this.layoutSpanHorizontal((Control)this.monoRadio, 4);
        this.colorBinding = this.bindings.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.colorRadio), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_CHROMATICITY_COLOR), null, null);
        this.monoBinding = this.bindings.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.monoRadio), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_CHROMATICITY_MONO), null, null);
        this.initializeControls(this.options.getDestination().getName());
        return result;
    }

    private void initializeControls(String printerName) {
        HashPrintServiceAttributeSet attributes = new HashPrintServiceAttributeSet(new PrinterName(printerName, Locale.getDefault()));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, attributes);
        PrintService printService = services[0];
        PrintServiceAttributeSet printServiceAttributes = printService.getAttributes();
        ColorSupported colorSupported = (ColorSupported)printServiceAttributes.get(ColorSupported.class);
        if (colorSupported == ColorSupported.SUPPORTED) {
            this.options.setChromaticityColor(true);
            this.options.setChromaticityMono(false);
            this.colorRadio.setEnabled(true);
        } else {
            this.options.setChromaticityColor(false);
            this.options.setChromaticityMono(true);
            this.colorRadio.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        this.bindings.removeBinding(this.colorBinding);
        this.colorBinding.dispose();
        this.bindings.removeBinding(this.monoBinding);
        this.monoBinding.dispose();
    }
}

