/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.internal.navigation;

import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.internal.navigation.INavigatorFromVSMExpression;
import org.eclipse.sirius.editor.internal.navigation.NavigationFromVSMExpressionRegistry;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.ui.tools.api.assist.ContentProposalClient;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Text;

public class NavigationByKeyListener
implements KeyListener {
    private EObject targetObject;
    private Text textWidget;
    private AbstractViewpointPropertySection propertySection;

    public NavigationByKeyListener(AbstractViewpointPropertySection propertySection, Text textWidget, EObject targetObject) {
        this.targetObject = targetObject;
        this.textWidget = textWidget;
        this.propertySection = propertySection;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x100000C) {
            NavigationFromVSMExpressionRegistry navigationRegistry = SiriusEditorPlugin.getPlugin().getNavigationRegistry();
            Set<Supplier<INavigatorFromVSMExpression>> navigators = navigationRegistry.getNavigators();
            for (Supplier<INavigatorFromVSMExpression> navigatorSupplier : navigators) {
                INavigatorFromVSMExpression navigator = navigatorSupplier.get();
                IInterpreterContext interContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)this.targetObject, (EStructuralFeature)((ContentProposalClient)this.propertySection).getFeature());
                ContentContext contentContext = new ContentContext(this.textWidget.getText(), this.textWidget.getCaretPosition(), interContext);
                if (!navigator.doProvideNavigationFor(this.propertySection, this.targetObject, contentContext)) continue;
                navigator.triggerNavigation(this.propertySection, this.targetObject, contentContext);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

