/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class ReparentExecutionOperation
extends AbstractModelChangeOperation<Void> {
    private final AbstractNodeEvent execution;
    private final ISequenceEvent finalParent;

    public ReparentExecutionOperation(AbstractNodeEvent execution, ISequenceEvent finalParent) {
        super(Messages.ReparentExecutionOperation_operationName);
        this.execution = Objects.requireNonNull(execution);
        this.finalParent = Objects.requireNonNull(finalParent);
        Preconditions.checkArgument((boolean)(execution.getNotationView().getElement() instanceof DNode));
        Preconditions.checkArgument((boolean)(finalParent.getNotationView().getElement() instanceof AbstractDNode));
    }

    public Void execute() {
        Node newParentNode;
        DNode newSem;
        Node thisNode;
        DNode thisSem = (DNode)this.execution.getNotationView().getElement();
        if (this.validate(thisSem, thisNode = (Node)this.execution.getNotationView(), newSem = (DNode)this.finalParent.getNotationView().getElement(), newParentNode = (Node)this.finalParent.getNotationView())) {
            EList persistedChildren = newParentNode.getPersistedChildren();
            persistedChildren.add((Object)thisNode);
            newSem.getOwnedBorderedNodes().add((Object)thisSem);
        }
        return null;
    }

    private boolean validate(DNode thisSem, Node thisNode, DNode newSem, Node newParentNode) {
        boolean validation = thisSem != null && newSem != null && newParentNode != null;
        validation = validation && !newSem.equals(thisSem.eContainer()) && !newParentNode.equals(thisNode.eContainer());
        return validation;
    }
}

