/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ui.business.internal.viewpoint.ViewpointSelectionCallbackWithConfimationAndDependenciesHandling;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.actions.creation.CreateRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionLabelProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationDescriptionItemImpl;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.RepresentationSelectionWizardPage;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SemanticElementSelectionWizardPage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Composite;

public class CreateRepresentationWizard
extends Wizard {
    public static final int MIN_PAGE_HEIGHT = 600;
    public static final int MIN_PAGE_WIDTH = 1000;
    private final Session session;
    private SemanticElementSelectionWizardPage selectSemanticElementPage;
    private RepresentationSelectionWizardPage representationWizardPage;
    private RepresentationDescriptionItemImpl representationDescriptionItem;
    private boolean creationCancelled;
    private boolean skipRepresentationsPage;
    private EObject semanticElement;

    public CreateRepresentationWizard(Session session) {
        this.session = session;
    }

    public CreateRepresentationWizard(Session theSession, RepresentationDescriptionItemImpl theRepresentationDescriptionItem) {
        this.session = theSession;
        this.representationDescriptionItem = theRepresentationDescriptionItem;
        this.skipRepresentationsPage = true;
    }

    public CreateRepresentationWizard(Session theSession, EObject theSemanticElement) {
        this.session = theSession;
        this.semanticElement = theSemanticElement;
    }

    public void init() {
        this.setWindowTitle(Messages.CreateRepresentationWizard_title);
        this.setNeedsProgressMonitor(false);
    }

    public boolean performFinish() {
        EObject semanticElementSource = this.semanticElement;
        if (semanticElementSource == null) {
            semanticElementSource = this.selectSemanticElementPage.getSelectedElement();
        }
        if (semanticElementSource != null) {
            Optional<RepresentationDescription> loadedInSessionDescription;
            Viewpoint viewpoint = this.representationWizardPage.getViewpoint();
            if (!ViewpointHelper.isViewpointEnabledInSession(this.session, viewpoint)) {
                TreeMap<Viewpoint, Boolean> originalViewpointsMap = new TreeMap<Viewpoint, Boolean>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
                Collection<Viewpoint> availableViewpoints = ViewpointHelper.getAvailableViewpoints(this.session);
                Collection selectedViewpoints = this.session.getSelectedViewpoints(false);
                for (Viewpoint availableViewpoint : availableViewpoints) {
                    boolean selected = false;
                    for (Viewpoint selectedViewpoint : selectedViewpoints) {
                        if (!EqualityHelper.areEquals((EObject)selectedViewpoint, (EObject)availableViewpoint)) continue;
                        selected = true;
                        break;
                    }
                    originalViewpointsMap.put(availableViewpoint, selected);
                }
                TreeMap<Viewpoint, Boolean> newViewpointToSelectionStateMap = new TreeMap<Viewpoint, Boolean>((Comparator<Viewpoint>)new ViewpointRegistry.ViewpointComparator());
                newViewpointToSelectionStateMap.putAll(originalViewpointsMap);
                newViewpointToSelectionStateMap.put(viewpoint, true);
                Map<String, Viewpoint> missingViewpointDependencies = ViewpointHelper.getViewpointDependencies(availableViewpoints, selectedViewpoints, viewpoint);
                for (Viewpoint missingViewpointDependency : missingViewpointDependencies.values().stream().filter(vp -> vp != null).collect(Collectors.toSet())) {
                    newViewpointToSelectionStateMap.put(missingViewpointDependency, true);
                }
                ViewpointHelper.applyNewViewpointSelection(originalViewpointsMap, newViewpointToSelectionStateMap, this.session, true, new ViewpointSelectionCallbackWithConfimationAndDependenciesHandling());
            }
            if ((loadedInSessionDescription = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(this.session.getSelectedViewpoints(false), semanticElementSource).stream().filter(rep -> EqualityHelper.areEquals((EObject)rep, (EObject)this.representationWizardPage.getRepresentation())).findFirst()).isPresent()) {
                CreateRepresentationAction action = new CreateRepresentationAction(this.session, semanticElementSource, loadedInSessionDescription.get(), (ILabelProvider)new SessionLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
                action.run();
            }
        }
        return true;
    }

    public void addPages() {
        if (this.semanticElement == null) {
            this.representationWizardPage = new RepresentationSelectionWizardPage(this.session, this.representationDescriptionItem);
            this.selectSemanticElementPage = new SemanticElementSelectionWizardPage(this.session);
            this.representationWizardPage.setSelectionWizard(this.selectSemanticElementPage);
            this.addPage((IWizardPage)this.representationWizardPage);
            this.addPage((IWizardPage)this.selectSemanticElementPage);
        } else {
            this.representationWizardPage = new RepresentationSelectionWizardPage(this.session, this.semanticElement);
            this.addPage((IWizardPage)this.representationWizardPage);
        }
    }

    public IWizardPage getStartingPage() {
        if (this.skipRepresentationsPage) {
            return this.selectSemanticElementPage;
        }
        return super.getStartingPage();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.selectSemanticElementPage != null) {
            this.selectSemanticElementPage.update();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.selectSemanticElementPage != null) {
            this.selectSemanticElementPage.dispose();
        }
        this.representationWizardPage.dispose();
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public boolean performCancel() {
        this.creationCancelled = true;
        return true;
    }

    public boolean isCreationCancelled() {
        return this.creationCancelled;
    }
}

