/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.WorkspaceImageQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.osgi.framework.Version;

public class WorkspaceImageGMFBoundsMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("15.0.0.202201261500");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            StringBuilder sb = new StringBuilder(Messages.WorkspaceImageGMFBoundsMigrationParticipant_title);
            EList ownedViews = dAnalysis.getOwnedViews();
            boolean migrationOccurred = false;
            for (DView view : ownedViews) {
                List loadedRepresentationsDescriptors = new DViewQuery(view).getLoadedRepresentationsDescriptors();
                for (DRepresentationDescriptor descriptor : loadedRepresentationsDescriptors) {
                    DDiagram dDiagram;
                    DDiagramGraphicalQuery query;
                    Option<Diagram> gmfDiagram;
                    if (!(descriptor.getRepresentation() instanceof DDiagram) || !(gmfDiagram = (query = new DDiagramGraphicalQuery(dDiagram = (DDiagram)descriptor.getRepresentation())).getAssociatedGMFDiagram()).some()) continue;
                    boolean migrationOccurredInCurrentDiag = false;
                    String representationName = "";
                    for (Object child : ((Diagram)gmfDiagram.get()).getChildren()) {
                        if (!this.resizeWorkspaceImageGMFBounds(child)) continue;
                        migrationOccurred = true;
                        migrationOccurredInCurrentDiag = true;
                        representationName = dDiagram.getName();
                    }
                    if (!migrationOccurredInCurrentDiag) continue;
                    sb.append(MessageFormat.format(Messages.WorkspaceImageGMFBoundsMigrationParticipant_GMFBoundsResized, representationName));
                }
            }
            if (migrationOccurred) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
                migrationOccurred = false;
            }
        }
    }

    private boolean resizeWorkspaceImageGMFBounds(Object child) {
        boolean resized = false;
        if (child instanceof Node && ((Node)child).getLayoutConstraint() instanceof Size) {
            DDiagramElementContainer dDiagramElementContainer;
            Node node = (Node)child;
            Size size = (Size)node.getLayoutConstraint();
            if (node.getElement() instanceof DNode) {
                DNode dnode = (DNode)node.getElement();
                if (dnode.getStyle() != null) {
                    StyleDescription description = dnode.getStyle().getDescription();
                    resized = this.resizeGMFNode(size, description, dnode.getWidth(), dnode.getHeight());
                }
            } else if (node.getElement() instanceof DDiagramElementContainer && (dDiagramElementContainer = (DDiagramElementContainer)node.getElement()).getStyle() != null) {
                StyleDescription description = dDiagramElementContainer.getStyle().getDescription();
                resized = this.resizeGMFNode(size, description, dDiagramElementContainer.getWidth(), dDiagramElementContainer.getHeight());
                for (Object o : node.getChildren()) {
                    resized = this.resizeWorkspaceImageGMFBounds(o);
                }
            }
        }
        return resized;
    }

    private boolean resizeGMFNode(Size size, StyleDescription description, Integer diagramElementWidth, Integer diagramElementHeight) {
        boolean resized = false;
        if (description instanceof WorkspaceImageDescription && size != null) {
            WorkspaceImageDescription workspaceImageDescription = (WorkspaceImageDescription)description;
            WorkspaceImageQuery workspaceImageQuery = new WorkspaceImageQuery(workspaceImageDescription);
            Integer width = null;
            Integer height = null;
            String sizeComputationExpression = workspaceImageDescription.getSizeComputationExpression();
            if (workspaceImageDescription.getResizeKind().getValue() == 0) {
                if (!StringUtil.isEmpty((String)sizeComputationExpression) && "-1".equals(sizeComputationExpression.trim()) && workspaceImageQuery.doesImageExist()) {
                    Dimension imageSize = workspaceImageQuery.getDefaultDimension();
                    width = imageSize.width;
                    height = imageSize.height;
                } else if (diagramElementWidth != null && diagramElementHeight != null) {
                    width = diagramElementWidth * 10;
                    height = (int)((double)diagramElementWidth.intValue() / workspaceImageQuery.getRatio() * 10.0);
                }
            } else if (!(StringUtil.isEmpty((String)sizeComputationExpression) || "-1".equals(sizeComputationExpression.trim()) && workspaceImageQuery.doesImageExist())) {
                Dimension imageSize = workspaceImageQuery.getDefaultDimension();
                if (size.getWidth() == imageSize.width && size.getHeight() == imageSize.height && diagramElementWidth != null && diagramElementHeight != null) {
                    width = diagramElementWidth * 10;
                    height = (int)((double)diagramElementWidth.intValue() / workspaceImageQuery.getRatio() * 10.0);
                }
            }
            if (width != null && height != null && (size.getHeight() != height.intValue() || size.getWidth() != width.intValue())) {
                size.setWidth(width.intValue());
                size.setHeight(height.intValue());
                resized = true;
            }
        }
        return resized;
    }
}

