/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.subscribers.SubscriberEventHandler;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoSet;
import org.eclipse.team.internal.core.subscribers.SyncSetInput;

public class SyncSetInputFromSyncSet
extends SyncSetInput
implements ISyncInfoSetChangeListener {
    SubscriberSyncInfoSet inputSyncSet;

    public SyncSetInputFromSyncSet(SubscriberSyncInfoSet set, SubscriberEventHandler handler) {
        super(handler);
        this.inputSyncSet = set;
        this.inputSyncSet.addSyncSetChangedListener(this);
    }

    @Override
    public void disconnect() {
        if (this.inputSyncSet == null) {
            return;
        }
        this.inputSyncSet.removeSyncSetChangedListener(this);
        this.inputSyncSet = null;
    }

    @Override
    protected void fetchInput(IProgressMonitor monitor) {
        SyncInfo[] infos;
        if (this.inputSyncSet == null) {
            return;
        }
        SyncInfo[] syncInfoArray = infos = this.inputSyncSet.getSyncInfos();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            this.collect(info, monitor);
            ++n2;
        }
    }

    @Override
    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        SubscriberSyncInfoSet syncSet = this.getSyncSet();
        try {
            syncSet.beginInput();
            monitor.beginTask(null, 105);
            this.syncSetChanged(event.getChangedResources(), Policy.subMonitorFor(monitor, 50));
            this.syncSetChanged(event.getAddedResources(), Policy.subMonitorFor(monitor, 50));
            this.remove(event.getRemovedResources());
        }
        finally {
            syncSet.endInput(Policy.subMonitorFor(monitor, 5));
        }
    }

    private void syncSetChanged(SyncInfo[] infos, IProgressMonitor monitor) {
        SyncInfo[] syncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            this.collect(info, monitor);
            ++n2;
        }
    }

    private void remove(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.remove(resource);
            ++n2;
        }
    }

    public void reset() {
        this.inputSyncSet.connect(this);
    }

    @Override
    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        if (this.inputSyncSet == null) {
            set.removeSyncSetChangedListener(this);
        } else {
            SubscriberSyncInfoSet syncSet = this.getSyncSet();
            try {
                syncSet.beginInput();
                monitor.beginTask(null, 100);
                ((SyncInfoSet)syncSet).clear();
                this.fetchInput(Policy.subMonitorFor(monitor, 95));
            }
            finally {
                syncSet.endInput(Policy.subMonitorFor(monitor, 5));
                monitor.done();
            }
        }
    }

    @Override
    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        SubscriberSyncInfoSet syncSet = this.getSyncSet();
        try {
            syncSet.beginInput();
            ITeamStatus[] iTeamStatusArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamStatus status = iTeamStatusArray[n2];
                syncSet.addError(status);
                ++n2;
            }
        }
        finally {
            syncSet.endInput(monitor);
        }
    }
}

