/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.commands;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypeDebugOptions;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.osgi.util.NLS;

public class DestroyElementCommand
extends EditElementCommand {
    private final EObject elementToDestroy;

    public DestroyElementCommand(DestroyElementRequest request) {
        super(request.getLabel(), request.getContainer(), request);
        this.elementToDestroy = request.getElementToDestroy();
    }

    public static void destroy(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null) {
            DestroyElementRequest destroy = new DestroyElementRequest(TransactionUtil.getEditingDomain((Resource)resource), eObject, false);
            IElementType context = ElementTypeRegistry.getInstance().getElementType(destroy.getEditHelperContext());
            ICommand command = context.getEditCommand(destroy);
            if (command != null && command.canExecute()) {
                try {
                    command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Trace.catching((Plugin)EMFTypePlugin.getPlugin(), (String)EMFTypeDebugOptions.EXCEPTIONS_CATCHING, DestroyElementCommand.class, (String)"destroy(EObject)", (Throwable)e);
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)4, (String)NLS.bind((String)EMFTypeCoreMessages.destroyCommandFailed, (Object)context.getDisplayName()), (Throwable)e);
                }
            }
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject destructee = this.getElementToDestroy();
        if (destructee != null && destructee.eResource() != null) {
            this.tearDownIncomingReferences(destructee);
            this.tearDownOutgoingReferences(destructee);
            EcoreUtil.remove((EObject)destructee);
            Resource res = destructee.eResource();
            if (res != null) {
                res.getContents().remove((Object)destructee);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected void tearDownIncomingReferences(EObject destructee) {
        int size;
        Collection inverseReferences;
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)destructee);
        if (crossReferencer != null && (inverseReferences = crossReferencer.getInverseReferences(destructee)) != null && (size = inverseReferences.size()) > 0) {
            EStructuralFeature.Setting[] settings = inverseReferences.toArray(new EStructuralFeature.Setting[size]);
            int i = 0;
            while (i < size) {
                EStructuralFeature.Setting setting = settings[i];
                EReference eRef = (EReference)setting.getEStructuralFeature();
                if (eRef.isChangeable() && !eRef.isDerived() && !eRef.isContainment() && !eRef.isContainer()) {
                    EcoreUtil.remove((EObject)setting.getEObject(), (EStructuralFeature)eRef, (Object)destructee);
                }
                ++i;
            }
        }
    }

    protected void tearDownOutgoingReferences(EObject destructee) {
        for (EReference reference : destructee.eClass().getEAllReferences()) {
            if (!reference.isChangeable() || reference.isDerived() || reference.isContainer() || reference.isContainment() || reference.getEOpposite() != null || !destructee.eIsSet((EStructuralFeature)reference)) continue;
            destructee.eUnset((EStructuralFeature)reference);
        }
    }

    protected EObject getElementToDestroy() {
        return this.elementToDestroy;
    }

    @Override
    public boolean canExecute() {
        return this.elementToDestroy != null && this.elementToDestroy.eResource() != null;
    }
}

