/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.common.utils;

import adaptorinterface.DomainSpecification;
import adaptorinterface.Resource;
import java.net.URI;
import javax.xml.namespace.QName;
import org.eclipse.lyo.tools.common.utils.DomainSpecificationVocabulary;
import vocabulary.Vocabulary;

public class ResourceShapeVocabulary {
    public QName deduceDescribes(Resource self) {
        if (self.getDescribes() != null) {
            Vocabulary v = (Vocabulary)self.getDescribes().eContainer();
            return new QName(v.getNamespaceURI(), self.getDescribes().getName(), v.getPreferredNamespacePrefix());
        }
        DomainSpecification ds = (DomainSpecification)self.eContainer();
        DomainSpecificationVocabulary vocab = new DomainSpecificationVocabulary();
        QName deducedVocabulary = vocab.deduceVocabulary(ds);
        return new QName(deducedVocabulary.getNamespaceURI(), self.getName(), deducedVocabulary.getPrefix());
    }

    public String deduceDescribes_namespaceURI(Resource self) {
        return this.deduceDescribes(self).getNamespaceURI();
    }

    public String deduceDescribes_localPart(Resource self) {
        return this.deduceDescribes(self).getLocalPart();
    }

    public String deduceDescribes_prefix(Resource self) {
        return this.deduceDescribes(self).getPrefix();
    }

    public String deduceDescribesComment(Resource self) {
        if (self.getDescribes() != null) {
            return self.getDescribes().getComment();
        }
        return self.getVocabularyComment();
    }

    public URI deduceDescribes_URI(Resource self) {
        return URI.create(String.valueOf(this.deduceDescribes_namespaceURI(self)) + this.deduceDescribes_localPart(self));
    }

    public URI getResourceShapeURI(Resource self) {
        return URI.create(String.valueOf(((DomainSpecification)self.eContainer()).getNamespaceURI()) + self.getName());
    }

    public String toString(Resource self, Boolean withShapeLabel, Boolean withPrefix) {
        String s = "";
        if (withShapeLabel.booleanValue()) {
            DomainSpecification ds = (DomainSpecification)self.eContainer();
            s = String.valueOf(s) + (withPrefix != false ? String.valueOf(ds.getNamespacePrefix().getName()) + ":" : "");
            s = String.valueOf(s) + self.getName();
        } else {
            s = String.valueOf(s) + (withPrefix != false ? String.valueOf(this.deduceDescribes(self).getPrefix()) + ":" : "");
            s = String.valueOf(s) + this.deduceDescribes(self).getLocalPart();
        }
        return s;
    }
}

