/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.acceleo.internal.parser.ast.ocl.WrappedOCLException;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironment;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironmentFactory;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.MacroInvocation;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.TypedASTNode;

public class OCLParser {
    public static final String ANNOTATION_SOURCE = "MTL";
    public static final String ANNOTATION_NON_STANDARD_SOURCE = "MTL non-standard";
    public static final String ANNOTATION_KEY_TYPE = "type";
    private Stack<EClassifier> contextStack = new Stack();
    private OCL.Helper helper;
    private AcceleoEnvironment environment;
    private Map<Variable, EObject> saveVariableContainer = new HashMap<Variable, EObject>();
    private Map<Variable, EStructuralFeature> saveVariableContainingFeature = new HashMap<Variable, EStructuralFeature>();
    private Map<EOperation, ModuleElement> eOperation2ModuleElement = new HashMap<EOperation, ModuleElement>();

    public OCLParser(Resource oclEnvironmentResource) {
        this.init(oclEnvironmentResource);
    }

    public void init(Resource oclEnvironmentResource) {
        this.helper = OCL.newInstance((EnvironmentFactory)AcceleoEnvironmentFactory.ACCELEO_INSTANCE, (Resource)oclEnvironmentResource).createOCLHelper();
        this.environment = (AcceleoEnvironment)this.helper.getEnvironment();
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEObject());
        this.contextStack.clear();
        this.saveVariableContainer.clear();
        this.saveVariableContainingFeature.clear();
        this.eOperation2ModuleElement.clear();
    }

    public void pushContext(EClassifier newContext) {
        this.helper.setContext((Object)newContext);
        this.contextStack.push(newContext);
    }

    public void popContext() {
        this.contextStack.pop();
        if (this.contextStack.isEmpty()) {
            this.helper.setContext((Object)EcorePackage.eINSTANCE.getEObject());
        } else {
            this.helper.setContext((Object)this.contextStack.peek());
        }
    }

    public void addVariableToScope(Variable newVariable) {
        if (newVariable != null && newVariable.getName() != null && newVariable.getName().length() > 0) {
            if (newVariable.getType() == null) {
                this.resolveType(newVariable);
            }
            EObject eContainer = newVariable.eContainer();
            EStructuralFeature eContainingFeature = newVariable.eContainingFeature();
            this.saveVariableContainer.put(newVariable, eContainer);
            this.saveVariableContainingFeature.put(newVariable, eContainingFeature);
            this.helper.getOCL().getEnvironment().addElement(newVariable.getName(), (org.eclipse.ocl.expressions.Variable)newVariable, true);
        }
    }

    private void resolveType(Variable newVariable) {
        String type;
        EAnnotation eAnnotation = newVariable.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)ANNOTATION_KEY_TYPE)) != null) {
            EClassifier eType = this.lookupClassifier(type);
            if (eType != null && eType != this.getInvalidType()) {
                newVariable.getEAnnotations().remove((Object)eAnnotation);
            }
            newVariable.setType((Object)eType);
        }
    }

    public EClassifier addRecursivelyVariablesToScopeAndGetContextClassifierAt(Module oModule, int offset) {
        Variable eContext = null;
        for (ModuleElement oModuleElement : oModule.getOwnedModuleElement()) {
            Variable oContext;
            if (offset <= oModuleElement.getStartPosition() || offset >= oModuleElement.getEndPosition()) continue;
            if (oModuleElement instanceof org.eclipse.acceleo.model.mtl.Template) {
                org.eclipse.acceleo.model.mtl.Template oTemplate = (org.eclipse.acceleo.model.mtl.Template)oModuleElement;
                if (oTemplate.getParameter().size() > 0) {
                    eContext = (Variable)oTemplate.getParameter().get(0);
                }
                this.addVariablesToScope((List<Variable>)oTemplate.getParameter());
            } else if (oModuleElement instanceof Query) {
                Query oQuery = (Query)oModuleElement;
                if (oQuery.getParameter().size() > 0) {
                    eContext = (Variable)oQuery.getParameter().get(0);
                }
                this.addVariablesToScope((List<Variable>)oQuery.getParameter());
            } else if (oModuleElement instanceof Macro) {
                Macro oMacro = (Macro)oModuleElement;
                if (oMacro.getParameter().size() > 0) {
                    eContext = (Variable)oMacro.getParameter().get(0);
                }
                this.addVariablesToScope((List<Variable>)oMacro.getParameter());
            }
            if (!(oModuleElement instanceof Block) || (oContext = this.addVariablesToScope((Block)oModuleElement, offset)) == null) break;
            eContext = oContext;
            break;
        }
        if (eContext != null) {
            return (EClassifier)eContext.getType();
        }
        return null;
    }

    private void addVariablesToScope(List<Variable> newVariables) {
        Iterator<Variable> newVariablesIt = new ArrayList<Variable>(newVariables).iterator();
        while (newVariablesIt.hasNext()) {
            this.addVariableToScope(newVariablesIt.next());
        }
    }

    private Variable addVariablesToScope(Block block, int offset) {
        Variable eContext = null;
        if (offset > block.getStartPosition() && offset < block.getEndPosition()) {
            if (block instanceof ForBlock) {
                eContext = ((ForBlock)block).getLoopVariable();
                this.addVariableToScope(((ForBlock)block).getLoopVariable());
            }
            if (block instanceof LetBlock) {
                eContext = ((LetBlock)block).getLetVariable();
                this.addVariableToScope(((LetBlock)block).getLetVariable());
            }
            if (block.getInit() != null) {
                this.addVariablesToScope((List<Variable>)block.getInit().getVariable());
            }
            for (EObject eContent : block.eContents()) {
                Variable oContext;
                if (!(eContent instanceof Block) || (oContext = this.addVariablesToScope((Block)eContent, offset)) == null) continue;
                eContext = oContext;
                break;
            }
        }
        return eContext;
    }

    public void addRecursivelyBehavioralFeaturesToScope(Module oModule) {
        this.addRecursivelyBehavioralFeaturesToScope(oModule, true, true, null);
    }

    public void addRecursivelyBehavioralFeaturesToScope(Module oModule, boolean operationWithReceiver, boolean operationWithoutReceiver, String startsWith) {
        this.addBehavioralFeaturesToScope(oModule, VisibilityKind.PRIVATE, operationWithReceiver, operationWithoutReceiver, startsWith);
        for (Module oOtherModule : oModule.getImports()) {
            this.addBehavioralFeaturesToScope(oOtherModule, VisibilityKind.PUBLIC, operationWithReceiver, operationWithoutReceiver, startsWith);
            this.addRecursivelyBehavioralFeaturesFromImports(oOtherModule, operationWithReceiver, operationWithoutReceiver, startsWith);
        }
        ArrayList<Module> allExtends = new ArrayList<Module>();
        this.computeAllExtends(allExtends, oModule);
        for (Module oOtherModule : allExtends) {
            this.addBehavioralFeaturesToScope(oOtherModule, VisibilityKind.PROTECTED, operationWithReceiver, operationWithoutReceiver, startsWith);
        }
    }

    private void addRecursivelyBehavioralFeaturesFromImports(Module oModule, boolean operationWithReceiver, boolean operationWithoutReceiver, String startsWith) {
        EList extendsList = oModule.getExtends();
        if (extendsList != null && extendsList.size() > 0) {
            for (Module module : extendsList) {
                this.addBehavioralFeaturesToScope(module, VisibilityKind.PUBLIC, operationWithReceiver, operationWithoutReceiver, startsWith);
            }
        }
    }

    private void computeAllExtends(List<Module> allExtends, Module oModule) {
        ArrayList<Module> toBrowse = new ArrayList<Module>();
        for (Module oOtherModule : oModule.getExtends()) {
            if (allExtends.contains(oOtherModule)) continue;
            allExtends.add(oOtherModule);
            toBrowse.add(oOtherModule);
        }
        for (Module oOtherModule : toBrowse) {
            this.computeAllExtends(allExtends, oOtherModule);
        }
    }

    private void addBehavioralFeaturesToScope(Module oModule, VisibilityKind lowestVisibilityKind, boolean operationWithReceiver, boolean operationWithoutReceiver, String startsWith) {
        TreeIterator itObjects = oModule.eAllContents();
        while (itObjects.hasNext()) {
            ModuleElement eModuleElement;
            EObject eObject = (EObject)itObjects.next();
            if (!(eObject instanceof ModuleElement) || (eModuleElement = (ModuleElement)eObject).getVisibility().getValue() < lowestVisibilityKind.getValue() || startsWith != null && (eModuleElement.getName() == null || !eModuleElement.getName().toLowerCase().startsWith(startsWith.toLowerCase()))) continue;
            if (eObject instanceof org.eclipse.acceleo.model.mtl.Template) {
                org.eclipse.acceleo.model.mtl.Template eTemplate = (org.eclipse.acceleo.model.mtl.Template)eObject;
                this.addTemplateToScope(eTemplate, operationWithReceiver, operationWithoutReceiver);
                continue;
            }
            if (eObject instanceof Query) {
                Query eQuery = (Query)eObject;
                this.addQueryToScope(eQuery, operationWithReceiver, operationWithoutReceiver);
                continue;
            }
            if (!(eObject instanceof Macro)) continue;
            Macro eMacro = (Macro)eObject;
            this.addMacroToScope(eMacro, operationWithReceiver, operationWithoutReceiver);
        }
    }

    private void addTemplateToScope(org.eclipse.acceleo.model.mtl.Template newTemplate, boolean operationWithReceiver, boolean operationWithoutReceiver) {
        EClass owner = EcorePackage.eINSTANCE.getEObject();
        if (newTemplate != null && newTemplate.getName() != null && newTemplate.getName().length() > 0) {
            EAnnotation eAnnotation;
            EOperation eOperation;
            Constraint constraint;
            EClassifier type = (EClassifier)this.environment.getOCLStandardLibrary().getString();
            EList params = newTemplate.getParameter();
            Iterator paramsIt = params.iterator();
            while (paramsIt.hasNext()) {
                this.resolveType((Variable)paramsIt.next());
            }
            if (operationWithoutReceiver) {
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newTemplate.getName(), type, (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newTemplate);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newTemplate);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
            if (operationWithReceiver && params.size() > 0 && ((Variable)params.get(0)).getType() != null) {
                owner = (EClassifier)((Variable)params.get(0)).getType();
                params = new BasicEList((Collection)params);
                params.remove(0);
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newTemplate.getName(), type, (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newTemplate);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newTemplate);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
        }
    }

    private void addQueryToScope(Query newQuery, boolean operationWithReceiver, boolean operationWithoutReceiver) {
        EClass owner = EcorePackage.eINSTANCE.getEObject();
        if (newQuery != null && newQuery.getName() != null && newQuery.getName().length() > 0) {
            EAnnotation eAnnotation;
            EOperation eOperation;
            Constraint constraint;
            this.resolveType(newQuery);
            EList params = newQuery.getParameter();
            Iterator paramsIt = params.iterator();
            while (paramsIt.hasNext()) {
                this.resolveType((Variable)paramsIt.next());
            }
            if (operationWithoutReceiver) {
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newQuery.getName(), newQuery.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newQuery);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newQuery);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
            if (operationWithReceiver && params.size() > 0 && ((Variable)params.get(0)).getType() != null) {
                owner = (EClassifier)((Variable)params.get(0)).getType();
                params = new BasicEList((Collection)params);
                params.remove(0);
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newQuery.getName(), newQuery.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newQuery);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newQuery);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
        }
    }

    private void resolveType(Query newQuery) {
        String type;
        EAnnotation eAnnotation = newQuery.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)ANNOTATION_KEY_TYPE)) != null) {
            EClassifier eType = this.lookupClassifier(type);
            if (eType != null && eType != this.getInvalidType()) {
                newQuery.getEAnnotations().remove((Object)eAnnotation);
            }
            newQuery.setType(eType);
        }
    }

    private void addMacroToScope(Macro newMacro, boolean operationWithReceiver, boolean operationWithoutReceiver) {
        EClass owner = EcorePackage.eINSTANCE.getEObject();
        if (newMacro != null && newMacro.getName() != null && newMacro.getName().length() > 0) {
            EAnnotation eAnnotation;
            EOperation eOperation;
            Constraint constraint;
            this.resolveType(newMacro);
            EList params = newMacro.getParameter();
            Iterator paramsIt = params.iterator();
            while (paramsIt.hasNext()) {
                this.resolveType((Variable)paramsIt.next());
            }
            if (operationWithoutReceiver) {
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newMacro.getName(), newMacro.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newMacro);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newMacro);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
            if (operationWithReceiver && params.size() > 0 && ((Variable)params.get(0)).getType() != null) {
                owner = (EClassifier)((Variable)params.get(0)).getType();
                params = new BasicEList((Collection)params);
                params.remove(0);
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newMacro.getName(), newMacro.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newMacro);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newMacro);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
        }
    }

    private void resolveType(Macro newMacro) {
        String type;
        EAnnotation eAnnotation = newMacro.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)ANNOTATION_KEY_TYPE)) != null) {
            EClassifier eType = this.lookupClassifier(type);
            if (eType != null && eType != this.getInvalidType()) {
                newMacro.getEAnnotations().remove((Object)eAnnotation);
            }
            newMacro.setType(eType);
        }
    }

    public void removeRecursivelyBehavioralFeaturesToScope(Module oModule) {
    }

    public void addRecursivelyMetamodelsToScope(Module oModule) {
        for (TypedModel typedModel : oModule.getInput()) {
            Iterator takesTypesFromIt = typedModel.getTakesTypesFrom().iterator();
            while (takesTypesFromIt.hasNext()) {
                this.addMetamodel((EPackage)takesTypesFromIt.next());
            }
        }
    }

    public void addMetamodel(EPackage metamodel) {
        this.environment.addMetamodel(metamodel);
    }

    public void removeMetamodel(EPackage metamodel) {
        this.environment.removeMetamodel(metamodel);
    }

    public EClassifier lookupClassifier(String name) {
        return this.environment.lookupClassifier(name);
    }

    public Environment<?, EClassifier, EOperation, EStructuralFeature, ?, ?, ?, ?, ?, ?, ?, ?> getOCLEnvironment() {
        return this.helper.getEnvironment();
    }

    public List<EClassifier> getTypes() {
        return this.environment.getTypes();
    }

    public EClassifier getInvalidType() {
        return this.environment.getOCLStandardLibraryReflection().getOCLInvalid();
    }

    public EClassifier getIntegerType() {
        return (EClassifier)this.environment.getOCLStandardLibrary().getInteger();
    }

    public EClassifier getStringType() {
        return (EClassifier)this.environment.getOCLStandardLibrary().getString();
    }

    public org.eclipse.ocl.ecore.OCLExpression parseOCLExpression(String text, int realOffsetInTheBuffer, ModelExpression iModelExpression) throws ParserException {
        if (text.trim().equals("super")) {
            TemplateInvocation eTemplateInvocation = MtlFactory.eINSTANCE.createTemplateInvocation();
            eTemplateInvocation.setDefinition(null);
            eTemplateInvocation.setSuper(true);
            eTemplateInvocation.setStartPosition(realOffsetInTheBuffer);
            eTemplateInvocation.setEndPosition(realOffsetInTheBuffer + text.length());
            return eTemplateInvocation;
        }
        org.eclipse.ocl.ecore.OCLExpression eOCLExpression = this.createQuery(text);
        this.shiftOCLExpressionPositions(realOffsetInTheBuffer, (EObject)eOCLExpression);
        TreeIterator eAllContents = eOCLExpression.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eContent = (EObject)eAllContents.next();
            this.shiftOCLExpressionPositions(realOffsetInTheBuffer, eContent);
        }
        org.eclipse.ocl.ecore.OCLExpression newOCLExpression = this.createAcceleoInvocation((EObject)eOCLExpression, iModelExpression);
        if (newOCLExpression == null) {
            TreeIterator eAllContentsIt = eOCLExpression.eAllContents();
            while (eAllContentsIt.hasNext()) {
                this.createAcceleoInvocation((EObject)eAllContentsIt.next(), iModelExpression);
            }
            newOCLExpression = eOCLExpression;
        }
        return newOCLExpression;
    }

    private org.eclipse.ocl.ecore.OCLExpression createQuery(String text) throws ParserException {
        this.environment.deleteFirstProblemObject();
        try {
            org.eclipse.ocl.ecore.OCLExpression eOCLExpression = this.helper.createQuery(text);
            return eOCLExpression;
        }
        catch (ParserException e1) {
            Object firstProblemObject = this.environment.getFirstProblemObject();
            this.pushContext((EClassifier)EcorePackage.eINSTANCE.getEObject());
            try {
                org.eclipse.ocl.ecore.OCLExpression eOCLExpression;
                org.eclipse.ocl.ecore.OCLExpression oCLExpression = eOCLExpression = this.helper.createQuery(text);
                return oCLExpression;
            }
            catch (ParserException e2) {
                if (firstProblemObject != null) {
                    throw new WrappedOCLException(e1, firstProblemObject);
                }
                throw e1;
            }
            finally {
                this.popContext();
            }
        }
    }

    private org.eclipse.ocl.ecore.OCLExpression createAcceleoInvocation(EObject eObject, ModelExpression iModelExpression) {
        if (eObject instanceof CallExp) {
            this.createAcceleoInvocation((EObject)((CallExp)eObject).getSource(), iModelExpression);
        }
        if (eObject instanceof OperationCallExp) {
            OperationCallExp eCall = (OperationCallExp)eObject;
            if (eCall.getReferredOperation() != null && ((EOperation)eCall.getReferredOperation()).getEAnnotation(ANNOTATION_SOURCE) != null) {
                Iterator referencesIt = ((EOperation)eCall.getReferredOperation()).getEAnnotation(ANNOTATION_SOURCE).getReferences().iterator();
                if (referencesIt.hasNext()) {
                    EObject eModuleElement = (EObject)referencesIt.next();
                    org.eclipse.ocl.ecore.OCLExpression acceleoInvocation = this.createAcceleoInvocation(eCall, eModuleElement, iModelExpression);
                    return this.handleArguments(acceleoInvocation, iModelExpression);
                }
            } else if (eCall.getReferredOperation() != null) {
                EList argument = eCall.getArgument();
                for (OCLExpression oclExpression : argument) {
                    this.createAcceleoInvocation((EObject)oclExpression, iModelExpression);
                }
            }
        } else if (eObject instanceof IteratorExp) {
            OCLExpression body = ((IteratorExp)eObject).getBody();
            this.createAcceleoInvocation((EObject)body, iModelExpression);
        }
        return null;
    }

    private org.eclipse.ocl.ecore.OCLExpression handleArguments(org.eclipse.ocl.ecore.OCLExpression acceleoInvocation, ModelExpression iModelExpression) {
        org.eclipse.ocl.ecore.OCLExpression result;
        block4: {
            block5: {
                block3: {
                    result = acceleoInvocation;
                    if (!(acceleoInvocation instanceof TemplateInvocation)) break block3;
                    TemplateInvocation templateInvocation = (TemplateInvocation)acceleoInvocation;
                    EList arguments = templateInvocation.getArgument();
                    for (org.eclipse.ocl.ecore.OCLExpression argument : arguments) {
                        this.createAcceleoInvocationArguments((OCLExpression<?>)argument, iModelExpression);
                    }
                    break block4;
                }
                if (!(acceleoInvocation instanceof QueryInvocation)) break block5;
                QueryInvocation queryInvocation = (QueryInvocation)acceleoInvocation;
                EList arguments = queryInvocation.getArgument();
                for (org.eclipse.ocl.ecore.OCLExpression argument : arguments) {
                    this.createAcceleoInvocationArguments((OCLExpression<?>)argument, iModelExpression);
                }
                break block4;
            }
            if (!(acceleoInvocation instanceof MacroInvocation)) break block4;
            MacroInvocation macroInvocation = (MacroInvocation)acceleoInvocation;
            EList arguments = macroInvocation.getArgument();
            for (org.eclipse.ocl.ecore.OCLExpression argument : arguments) {
                this.createAcceleoInvocationArguments((OCLExpression<?>)argument, iModelExpression);
            }
        }
        return result;
    }

    private void createAcceleoInvocationArguments(OCLExpression<?> argument, ModelExpression iModelExpression) {
        if (argument instanceof CollectionLiteralExp) {
            CollectionLiteralExp collectionLiteralExp = (CollectionLiteralExp)argument;
            EList parts = collectionLiteralExp.getPart();
            for (Object collectionLiteralPart : parts) {
                if (!(collectionLiteralPart instanceof CollectionItem)) continue;
                CollectionItem collectionItem = (CollectionItem)collectionLiteralPart;
                OCLExpression item = collectionItem.getItem();
                if (item instanceof CollectionLiteralExp) {
                    this.createAcceleoInvocationArguments(item, iModelExpression);
                    continue;
                }
                this.createAcceleoInvocation((EObject)item, iModelExpression);
            }
        }
    }

    private org.eclipse.ocl.ecore.OCLExpression createAcceleoInvocation(OperationCallExp eCall, EObject eModuleElement, ModelExpression iModelExpression) {
        TemplateInvocation eOCLExpression;
        if (eModuleElement instanceof org.eclipse.acceleo.model.mtl.Template) {
            TemplateInvocation eTemplateInvocation;
            org.eclipse.acceleo.model.mtl.Template eTemplate = (org.eclipse.acceleo.model.mtl.Template)eModuleElement;
            eOCLExpression = eTemplateInvocation = MtlFactory.eINSTANCE.createTemplateInvocation();
            eTemplateInvocation.setDefinition(eTemplate);
            eTemplateInvocation.setStartPosition(eCall.getStartPosition());
            eTemplateInvocation.setEndPosition(eCall.getEndPosition());
            if (this.receiverIsArgument(eCall, (ModuleElement)eTemplate, (List<Variable>)eTemplate.getParameter(), iModelExpression)) {
                eTemplateInvocation.getArgument().add((Object)((org.eclipse.ocl.ecore.OCLExpression)eCall.getSource()));
            }
            eTemplateInvocation.setType((Object)((EClassifier)eCall.getType()));
            this.move((List)eCall.getArgument(), (List)eTemplateInvocation.getArgument());
            this.checkArgumentInvocations((List<org.eclipse.ocl.ecore.OCLExpression>)eTemplateInvocation.getArgument(), iModelExpression);
            EcoreUtil.replace((EObject)eCall, (EObject)eTemplateInvocation);
        } else if (eModuleElement instanceof Query) {
            Query eQuery = (Query)eModuleElement;
            QueryInvocation eQueryInvocation = MtlFactory.eINSTANCE.createQueryInvocation();
            eOCLExpression = eQueryInvocation;
            eQueryInvocation.setDefinition(eQuery);
            eQueryInvocation.setStartPosition(eCall.getStartPosition());
            eQueryInvocation.setEndPosition(eCall.getEndPosition());
            if (this.receiverIsArgument(eCall, (ModuleElement)eQuery, (List<Variable>)eQuery.getParameter(), iModelExpression)) {
                eQueryInvocation.getArgument().add((Object)((org.eclipse.ocl.ecore.OCLExpression)eCall.getSource()));
            }
            eQueryInvocation.setType((Object)((EClassifier)eCall.getType()));
            this.move((List)eCall.getArgument(), (List)eQueryInvocation.getArgument());
            this.checkArgumentInvocations((List<org.eclipse.ocl.ecore.OCLExpression>)eQueryInvocation.getArgument(), iModelExpression);
            EcoreUtil.replace((EObject)eCall, (EObject)eQueryInvocation);
        } else if (eModuleElement instanceof Macro) {
            Macro eMacro = (Macro)eModuleElement;
            MacroInvocation eMacroInvocation = MtlFactory.eINSTANCE.createMacroInvocation();
            eOCLExpression = eMacroInvocation;
            eMacroInvocation.setDefinition(eMacro);
            eMacroInvocation.setStartPosition(eCall.getStartPosition());
            eMacroInvocation.setEndPosition(eCall.getEndPosition());
            if (this.receiverIsArgument(eCall, (ModuleElement)eMacro, (List<Variable>)eMacro.getParameter(), iModelExpression)) {
                eMacroInvocation.getArgument().add((Object)((org.eclipse.ocl.ecore.OCLExpression)eCall.getSource()));
            }
            eMacroInvocation.setType((Object)((EClassifier)eCall.getType()));
            this.move((List)eCall.getArgument(), (List)eMacroInvocation.getArgument());
            this.checkArgumentInvocations((List<org.eclipse.ocl.ecore.OCLExpression>)eMacroInvocation.getArgument(), iModelExpression);
            EcoreUtil.replace((EObject)eCall, (EObject)eMacroInvocation);
        } else {
            eOCLExpression = null;
        }
        return eOCLExpression;
    }

    private boolean receiverIsArgument(OperationCallExp eCall, ModuleElement astModuleElement, List<Variable> variables, ModelExpression iModelExpression) {
        boolean result = false;
        if (eCall.getSource() != null) {
            if (eCall.getSource() instanceof VariableExp && ((VariableExp)eCall.getSource()).getReferredVariable() != null) {
                if (eCall.getArgument().size() == 0) {
                    result = true;
                } else if (variables.size() == 0 && iModelExpression != null) {
                    result = this.handleRecursiveCall(eCall, astModuleElement, variables, iModelExpression);
                } else {
                    result = eCall.getArgument().size() < variables.size();
                    result = result && variables.size() != 0;
                }
            } else {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean handleRecursiveCall(OperationCallExp eCall, ModuleElement astModuleElement, List<Variable> variables, ModelExpression iModelExpression) {
        org.eclipse.acceleo.parser.cst.Macro cstMacro;
        boolean result = false;
        EObject eContainer = iModelExpression.eContainer();
        while (eContainer != null && !(eContainer instanceof org.eclipse.acceleo.parser.cst.ModuleElement)) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer instanceof Template) {
            Template cstTemplate = (Template)eContainer;
            if (cstTemplate.getStartPosition() == astModuleElement.getStartPosition() && cstTemplate.getEndPosition() == astModuleElement.getEndPosition()) {
                result = eCall.getArgument().size() < cstTemplate.getParameter().size();
                result = result && cstTemplate.getParameter().size() != 0;
            }
        } else if (eContainer instanceof org.eclipse.acceleo.parser.cst.Query) {
            org.eclipse.acceleo.parser.cst.Query cstQuery = (org.eclipse.acceleo.parser.cst.Query)eContainer;
            if (cstQuery.getStartPosition() == astModuleElement.getStartPosition() && cstQuery.getEndPosition() == astModuleElement.getEndPosition()) {
                result = eCall.getArgument().size() < cstQuery.getParameter().size();
                result = result && cstQuery.getParameter().size() != 0;
            }
        } else if (eContainer instanceof org.eclipse.acceleo.parser.cst.Macro && (cstMacro = (org.eclipse.acceleo.parser.cst.Macro)eContainer).getStartPosition() == astModuleElement.getStartPosition() && cstMacro.getEndPosition() == astModuleElement.getEndPosition()) {
            result = eCall.getArgument().size() < cstMacro.getParameter().size();
            result = result && cstMacro.getParameter().size() != 0;
        }
        return result;
    }

    private void move(List in, List out) {
        out.addAll(in);
    }

    private void checkArgumentInvocations(List<org.eclipse.ocl.ecore.OCLExpression> arguments, ModelExpression iModelExpression) {
        ListIterator<org.eclipse.ocl.ecore.OCLExpression> it = arguments.listIterator();
        while (it.hasNext()) {
            org.eclipse.ocl.ecore.OCLExpression next = it.next();
            org.eclipse.ocl.ecore.OCLExpression newArgument = this.createAcceleoInvocation((EObject)next, iModelExpression);
            if (newArgument == null) continue;
            it.set(newArgument);
        }
    }

    private void shiftOCLExpressionPositions(int posBegin, EObject eContent) {
        if (eContent instanceof ASTNode && ((ASTNode)eContent).getStartPosition() >= 0) {
            ((ASTNode)eContent).setStartPosition(posBegin + ((ASTNode)eContent).getStartPosition());
            ((ASTNode)eContent).setEndPosition(posBegin + ((ASTNode)eContent).getEndPosition());
        }
        if (eContent instanceof CallingASTNode && ((CallingASTNode)eContent).getPropertyStartPosition() >= 0) {
            ((CallingASTNode)eContent).setPropertyStartPosition(posBegin + ((CallingASTNode)eContent).getPropertyStartPosition());
            ((CallingASTNode)eContent).setPropertyEndPosition(posBegin + ((CallingASTNode)eContent).getPropertyEndPosition());
        }
        if (eContent instanceof TypedASTNode && ((TypedASTNode)eContent).getTypeStartPosition() >= 0) {
            ((TypedASTNode)eContent).setTypeStartPosition(posBegin + ((TypedASTNode)eContent).getTypeStartPosition());
            ((TypedASTNode)eContent).setTypeEndPosition(posBegin + ((TypedASTNode)eContent).getTypeEndPosition());
        }
    }

    public void dispose() {
        this.saveVariableContainer.clear();
        this.saveVariableContainingFeature.clear();
        this.eOperation2ModuleElement.clear();
    }

    public void removeVariableFromScope(Variable oldVariable) {
        if (oldVariable == null) {
            return;
        }
        EObject eContainer = this.saveVariableContainer.get(oldVariable);
        EStructuralFeature eContainingFeature = this.saveVariableContainingFeature.get(oldVariable);
        if (oldVariable.getName() != null && eContainer != null && eContainingFeature != null) {
            this.helper.getOCL().getEnvironment().deleteElement(oldVariable.getName());
            if (eContainingFeature.getUpperBound() == 1) {
                eContainer.eSet(eContainingFeature, (Object)oldVariable);
            } else {
                Object eGet = eContainer.eGet(eContainingFeature);
                if (eGet instanceof Collection) {
                    Collection list = (Collection)eGet;
                    list.add(oldVariable);
                }
            }
        }
        this.saveVariableContainer.remove(oldVariable);
        this.saveVariableContainingFeature.remove(oldVariable);
    }

    public List<Choice> getSyntaxHelp(String text) {
        ArrayList<Object> result;
        block9: {
            result = new ArrayList<Choice>();
            try {
                result.addAll(this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, text));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.pushContext((EClassifier)EcorePackage.eINSTANCE.getEObject());
            try {
                try {
                    result.addAll(this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, text));
                }
                catch (NullPointerException nullPointerException) {
                    this.popContext();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.popContext();
                throw throwable;
            }
            this.popContext();
        }
        if ("".equals(text)) {
            ArrayList<Choice> erroneousResult = result;
            result = new ArrayList();
            for (Choice c : erroneousResult) {
                if (c.getKind() != ChoiceKind.VARIABLE) continue;
                result.add(c);
            }
            result.addAll(this.getSyntaxHelp("self."));
        }
        return result;
    }

    public ModuleElement getModuleElement(EOperation eOperation) {
        ModuleElement result = this.eOperation2ModuleElement.get(eOperation);
        if (result == null && eOperation != null) {
            for (Map.Entry<EOperation, ModuleElement> entry : this.eOperation2ModuleElement.entrySet()) {
                EOperation operation = entry.getKey();
                if (!this.equals(eOperation, operation)) continue;
                return entry.getValue();
            }
        }
        return result;
    }

    private boolean equals(EOperation o1, EOperation o2) {
        boolean result;
        if (o1 == o2) {
            result = true;
        } else if (o1 == null || o2 == null) {
            result = false;
        } else if (o1.getName() != null && o1.getName().equals(o2.getName()) && o1.getEParameters().size() == o2.getEParameters().size()) {
            Iterator params1 = o1.getEParameters().iterator();
            Iterator params2 = o2.getEParameters().iterator();
            while (params1.hasNext() && params2.hasNext()) {
                EParameter param1 = (EParameter)params1.next();
                EParameter param2 = (EParameter)params2.next();
                if (param1.getEType() == null || param2.getEType() == null || param1.getEType().getName() == null || param1.getEType().getName().equals(param2.getEType().getName())) continue;
                return false;
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }
}

