/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.documentation;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AcceleoRefactoringUtils;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.ecore.Variable;

public class GenerateDocumentationAction
extends AbstractRefactoringAction {
    private static final String SPACE = " ";

    public GenerateDocumentationAction() {
        super(true);
    }

    @Override
    protected void launchRefactoring() {
        if (this.fWindow != null && AcceleoRefactoringUtils.allResourceSaved() && !this.editor.isDirty()) {
            EObject container = OpenDeclarationUtils.findResolvedDeclaration(this.editor);
            while (!(container instanceof Template || container instanceof Query || container instanceof Module || container == null)) {
                container = container.eContainer();
            }
            if (container instanceof Template) {
                Template template = (Template)container;
                this.generateTemplateDocumentation(template);
            } else if (container instanceof Query) {
                Query query = (Query)container;
                this.generateQueryDocumentation(query);
            } else if (container instanceof Module) {
                Module module = (Module)container;
                this.generateModuleDocumentation(module);
            }
            if (container != null) {
                this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private String getLineDelimiter(IDocument document) {
        String lineDelimiter = System.getProperty("line.separator");
        if (document != null && document.getNumberOfLines() > 0) {
            try {
                lineDelimiter = document.getLineDelimiter(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return lineDelimiter;
    }

    private void generateModuleDocumentation(Module module) {
        String username = System.getProperty("user.name");
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        String lineDelimiter = this.getLineDelimiter(document);
        int startPosition = module.getStartHeaderPosition() - lineDelimiter.length();
        StringBuffer newBuffer = new StringBuffer();
        newBuffer.append(String.valueOf(lineDelimiter) + "[" + "**" + lineDelimiter);
        newBuffer.append(" * " + lineDelimiter);
        newBuffer.append(" * @author " + username + lineDelimiter);
        newBuffer.append(" */]");
        try {
            document.replace(startPosition, 0, newBuffer.toString());
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    private void generateQueryDocumentation(Query query) {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        String lineDelimiter = this.getLineDelimiter(document);
        int startPosition = query.getStartPosition() - lineDelimiter.length();
        StringBuffer newBuffer = new StringBuffer();
        newBuffer.append(String.valueOf(lineDelimiter) + "[" + "**" + lineDelimiter);
        newBuffer.append(" * " + lineDelimiter);
        newBuffer.append(this.generateParameterDocumentation((EList<Variable>)query.getParameter(), lineDelimiter));
        newBuffer.append(" */]");
        try {
            document.replace(startPosition, 0, newBuffer.toString());
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }

    private StringBuffer generateParameterDocumentation(EList<Variable> eList, String lineDelimiter) {
        StringBuffer result = new StringBuffer();
        for (Variable variable : eList) {
            result.append(" * @param " + variable.getName() + SPACE + lineDelimiter);
        }
        return result;
    }

    private void generateTemplateDocumentation(Template template) {
        IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        String lineDelimiter = this.getLineDelimiter(document);
        int startPosition = template.getStartPosition() - lineDelimiter.length();
        StringBuffer newBuffer = new StringBuffer();
        newBuffer.append(String.valueOf(lineDelimiter) + "[" + "**" + lineDelimiter);
        newBuffer.append(" * " + lineDelimiter);
        newBuffer.append(this.generateParameterDocumentation((EList<Variable>)template.getParameter(), lineDelimiter));
        newBuffer.append(" */]");
        try {
            document.replace(startPosition, 0, newBuffer.toString());
        }
        catch (BadLocationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
        }
    }
}

