/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ElementTypeLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.SelectExistingElementForSourceOperation;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.SelectExistingElementForTargetOperation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class PromptForConnectionAndEndCommand
extends PopupMenuCommand {
    private static String EXISTING_ELEMENT = DiagramUIMessages.ConnectionHandle_Popup_ExistingElement;
    private ConnectionLabelProvider connectionLabelProvider;
    private static EndLabelProvider endLabelProvider;
    private ObjectAdapter connectionAdapter = new ObjectAdapter();
    private ObjectAdapter endAdapter = new ObjectAdapter();
    private CreateConnectionRequest request;
    private IGraphicalEditPart containerEP;

    public PromptForConnectionAndEndCommand(CreateConnectionRequest request, IGraphicalEditPart containerEP) {
        super(DiagramUIMessages.Command_GetRelationshipTypeAndEndFromUser_Label, Display.getCurrent().getActiveShell());
        this.request = request;
        this.containerEP = containerEP;
    }

    protected List getConnectionMenuContent() {
        Object type;
        List<IElementType> validRelTypes = new ArrayList<IElementType>();
        if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
            List allRelTypes = null;
            allRelTypes = ((CreateUnspecifiedTypeConnectionRequest)this.request).useModelingAssistantService() ? (this.isDirectionReversed() ? ModelingAssistantService.getInstance().getRelTypesOnTarget((IAdaptable)this.getKnownEnd()) : ModelingAssistantService.getInstance().getRelTypesOnSource((IAdaptable)this.getKnownEnd())) : ((CreateUnspecifiedTypeConnectionRequest)this.request).getElementTypes();
            if (this.isDirectionReversed()) {
                validRelTypes = allRelTypes;
            } else {
                for (IElementType rType : allRelTypes) {
                    if (((CreateConnectionRequest)((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(rType)).getStartCommand() == null) continue;
                    validRelTypes.add(rType);
                }
            }
        } else if (this.request instanceof CreateConnectionViewAndElementRequest) {
            if (((CreateConnectionViewAndElementRequest)this.request).getStartCommand() != null) {
                validRelTypes.add(((CreateRelationshipRequest)((CreateConnectionViewAndElementRequest)this.request).getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter().getAdapter(CreateRelationshipRequest.class)).getElementType());
            }
        } else if (this.request instanceof CreateConnectionViewRequest && ((CreateConnectionViewRequest)this.request).getStartCommand() != null && (type = ((CreateConnectionViewRequest)this.request).getConnectionViewDescriptor().getElementAdapter().getAdapter(IElementType.class)) != null) {
            validRelTypes.add((IElementType)type);
        }
        return validRelTypes;
    }

    protected List getEndMenuContent(Object connectionItem) {
        if (connectionItem instanceof IElementType) {
            IElementType connectionType = (IElementType)connectionItem;
            List menuContent = this.isDirectionReversed() ? ModelingAssistantService.getInstance().getTypesForSource((IAdaptable)this.getKnownEnd(), connectionType) : ModelingAssistantService.getInstance().getTypesForTarget((IAdaptable)this.getKnownEnd(), connectionType);
            if (!(menuContent = this.filterUnsupportedNodeTypes(menuContent)).isEmpty() && this.supportsExistingElement(connectionType)) {
                menuContent.add(EXISTING_ELEMENT);
            }
            return menuContent;
        }
        return Collections.EMPTY_LIST;
    }

    protected PopupMenu createPopupMenu() {
        final List connectionMenuContent = this.getConnectionMenuContent();
        if (connectionMenuContent == null || connectionMenuContent.isEmpty()) {
            return null;
        }
        if (connectionMenuContent.size() == 1) {
            List menuContent = this.getEndMenuContent(connectionMenuContent.get(0));
            if (menuContent == null || menuContent.isEmpty()) {
                return null;
            }
            ILabelProvider labelProvider = this.getConnectionAndEndLabelProvider(connectionMenuContent.get(0));
            return new PopupMenu(menuContent, labelProvider){

                @Override
                public Object getResult() {
                    Object endResult = super.getResult();
                    if (endResult == null) {
                        return null;
                    }
                    ArrayList<Object> resultList = new ArrayList<Object>(2);
                    resultList.add(connectionMenuContent.get(0));
                    resultList.add(endResult);
                    return resultList;
                }
            };
        }
        ArrayList<PopupMenu.CascadingMenu> menuContent = new ArrayList<PopupMenu.CascadingMenu>();
        for (Object connectionItem : connectionMenuContent) {
            List subMenuContent = this.getEndMenuContent(connectionItem);
            if (subMenuContent.isEmpty()) continue;
            PopupMenu subMenu = new PopupMenu(subMenuContent, this.getEndLabelProvider());
            menuContent.add(new PopupMenu.CascadingMenu(connectionItem, subMenu));
        }
        if (!menuContent.isEmpty()) {
            return new PopupMenu(menuContent, this.getConnectionLabelProvider());
        }
        return null;
    }

    private List filterUnsupportedNodeTypes(List allTypes) {
        ArrayList<IElementType> validTypes = new ArrayList<IElementType>();
        for (IElementType type : allTypes) {
            Command cmd;
            CreateViewRequest createRequest = CreateViewRequestFactory.getCreateShapeRequest(type, this.containerEP.getDiagramPreferencesHint());
            EditPart target = this.containerEP.getTargetEditPart((Request)createRequest);
            if (target == null || (cmd = target.getCommand((Request)createRequest)) == null || !cmd.canExecute()) continue;
            validTypes.add(type);
        }
        return validTypes;
    }

    public boolean canExecute() {
        return this.createPopupMenu() != null;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        List resultList;
        PopupMenu popup = this.createPopupMenu();
        if (popup == null) {
            return CommandResult.newErrorCommandResult((String)this.getLabel());
        }
        this.setPopupMenu(popup);
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        Object result = cmdResult.getReturnValue();
        if (result instanceof List && (resultList = (List)result).size() == 2) {
            this.connectionAdapter.setObject(resultList.get(0));
            Object targetResult = resultList.get(1);
            if (targetResult.equals(EXISTING_ELEMENT)) {
                Object object = targetResult = this.isDirectionReversed() ? ModelingAssistantService.getInstance().selectExistingElementForSource((IAdaptable)this.getKnownEnd(), (IElementType)resultList.get(0)) : ModelingAssistantService.getInstance().selectExistingElementForTarget((IAdaptable)this.getKnownEnd(), (IElementType)resultList.get(0));
                if (targetResult == null) {
                    return CommandResult.newCancelledCommandResult();
                }
            }
            this.endAdapter.setObject(targetResult);
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)this.getLabel());
    }

    private boolean supportsExistingElement(IElementType connectionType) {
        return this.isDirectionReversed() ? ModelingAssistantService.getInstance().provides((IOperation)new SelectExistingElementForSourceOperation((IAdaptable)this.getKnownEnd(), connectionType)) : ModelingAssistantService.getInstance().provides((IOperation)new SelectExistingElementForTargetOperation((IAdaptable)this.getKnownEnd(), connectionType));
    }

    public ObjectAdapter getConnectionAdapter() {
        return this.connectionAdapter;
    }

    public IAdaptable getEndAdapter() {
        return this.endAdapter;
    }

    protected boolean isDirectionReversed() {
        return this.request instanceof CreateUnspecifiedTypeConnectionRequest && ((CreateUnspecifiedTypeConnectionRequest)this.request).isDirectionReversed();
    }

    private EditPart getKnownEnd() {
        return this.request.getSourceEditPart();
    }

    protected ILabelProvider getConnectionLabelProvider() {
        if (this.connectionLabelProvider == null) {
            this.connectionLabelProvider = new ConnectionLabelProvider();
        }
        return this.connectionLabelProvider;
    }

    protected ILabelProvider getEndLabelProvider() {
        if (endLabelProvider == null) {
            endLabelProvider = new EndLabelProvider();
        }
        return endLabelProvider;
    }

    protected ILabelProvider getConnectionAndEndLabelProvider(Object connectionItem) {
        return new ConnectionAndEndLabelProvider(connectionItem);
    }

    protected class ConnectionAndEndLabelProvider
    extends ElementTypeLabelProvider {
        private Object connectionItem;

        protected ConnectionAndEndLabelProvider(Object connectionItem) {
            this.connectionItem = connectionItem;
        }

        @Override
        public String getText(Object element) {
            String theInputStr = null;
            if (element instanceof IElementType) {
                theInputStr = PromptForConnectionAndEndCommand.this.isDirectionReversed() ? DiagramUIMessages.ConnectionHandle_Popup_CreateXFromNewY : DiagramUIMessages.ConnectionHandle_Popup_CreateXToNewY;
                String text = NLS.bind((String)theInputStr, (Object[])new Object[]{super.getText(this.connectionItem), super.getText(element)});
                return text;
            }
            theInputStr = PromptForConnectionAndEndCommand.this.isDirectionReversed() ? DiagramUIMessages.ConnectionHandle_Popup_CreateXFromY : DiagramUIMessages.ConnectionHandle_Popup_CreateXToY;
            String text = NLS.bind((String)theInputStr, (Object[])new Object[]{super.getText(this.connectionItem), super.getText(element)});
            return text;
        }

        protected Object getConnectionItem() {
            return this.connectionItem;
        }
    }

    protected class ConnectionLabelProvider
    extends ElementTypeLabelProvider {
        protected ConnectionLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            String theInputStr = null;
            theInputStr = PromptForConnectionAndEndCommand.this.isDirectionReversed() ? DiagramUIMessages.ConnectionHandle_Popup_CreateXFrom : DiagramUIMessages.ConnectionHandle_Popup_CreateXTo;
            String text = NLS.bind((String)theInputStr, (Object)super.getText(element));
            return text;
        }
    }

    protected class EndLabelProvider
    extends ElementTypeLabelProvider {
        protected EndLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            if (element instanceof IElementType) {
                String theInputStr = DiagramUIMessages.ConnectionHandle_Popup_NewX;
                String text = NLS.bind((String)theInputStr, (Object)super.getText(element));
                return text;
            }
            return element.toString();
        }
    }
}

