/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public abstract class QuickAccessProvider {
    private QuickAccessElement[] cacheSortedElements;

    public abstract String getId();

    public abstract String getName();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract QuickAccessElement[] getElements();

    public QuickAccessElement[] getElements(String filter, IProgressMonitor monitor) {
        return new QuickAccessElement[0];
    }

    public QuickAccessElement[] getElementsSorted(String filter, IProgressMonitor monitor) {
        if (this.cacheSortedElements == null) {
            this.cacheSortedElements = this.getElements();
            if (this.cacheSortedElements == null) {
                this.cacheSortedElements = new QuickAccessElement[0];
            }
            Arrays.sort(this.cacheSortedElements, Comparator.comparing(QuickAccessElement::getSortLabel));
        }
        if (filter == null) {
            return this.cacheSortedElements;
        }
        QuickAccessElement[] filterSpecificElements = this.getElements(filter, monitor);
        if (filterSpecificElements == null || filterSpecificElements.length == 0) {
            return this.cacheSortedElements;
        }
        TreeSet<QuickAccessElement> res = new TreeSet<QuickAccessElement>(Comparator.comparing(QuickAccessElement::getSortLabel));
        res.addAll(Arrays.asList(this.cacheSortedElements));
        res.addAll(Arrays.asList(filterSpecificElements));
        return res.toArray(new QuickAccessElement[res.size()]);
    }

    public QuickAccessElement findElement(String id, String filterText) {
        if (id == null) {
            return null;
        }
        if (this.cacheSortedElements != null) {
            QuickAccessElement[] quickAccessElementArray = this.cacheSortedElements;
            int n = this.cacheSortedElements.length;
            int n2 = 0;
            while (n2 < n) {
                QuickAccessElement element = quickAccessElementArray[n2];
                if (id.equals(element.getId())) {
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    public final void reset() {
        this.cacheSortedElements = null;
        this.doReset();
    }

    protected abstract void doReset();

    public boolean requiresUiAccess() {
        return false;
    }
}

