/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CollectionKind implements Enumerator
{
    SET_LITERAL(0, "Set", "Set"),
    ORDERED_SET_LITERAL(1, "OrderedSet", "OrderedSet"),
    BAG_LITERAL(2, "Bag", "Bag"),
    SEQUENCE_LITERAL(3, "Sequence", "Sequence"),
    COLLECTION_LITERAL(4, "Collection", "Collection");

    public static final int SET = 0;
    public static final int ORDERED_SET = 1;
    public static final int BAG = 2;
    public static final int SEQUENCE = 3;
    public static final int COLLECTION = 4;
    private static final CollectionKind[] VALUES_ARRAY;
    public static final List<CollectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CollectionKind[]{SET_LITERAL, ORDERED_SET_LITERAL, BAG_LITERAL, SEQUENCE_LITERAL, COLLECTION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CollectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind get(int value) {
        switch (value) {
            case 0: {
                return SET_LITERAL;
            }
            case 1: {
                return ORDERED_SET_LITERAL;
            }
            case 2: {
                return BAG_LITERAL;
            }
            case 3: {
                return SEQUENCE_LITERAL;
            }
            case 4: {
                return COLLECTION_LITERAL;
            }
        }
        return null;
    }

    private CollectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static CollectionKind getKind(boolean ordered, boolean unique) {
        if (ordered) {
            return unique ? ORDERED_SET_LITERAL : SEQUENCE_LITERAL;
        }
        return unique ? SET_LITERAL : BAG_LITERAL;
    }
}

