/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.DiagramLayoutCustomization;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.IsPinnedPredicate;

public class PinnedElementsHandler {
    private static final boolean DEBUG = false;
    private static final boolean INCLUDE_PADDING = true;
    private static final boolean EXCLUDE_PADDING = false;
    private static final int MINIMAL_GAP_WIDTH = 60;
    private final Predicate<IGraphicalEditPart> isPinned;
    private final Comparator<Point> pointComparator = new Comparator<Point>(){

        @Override
        public int compare(Point p1, Point p2) {
            if (p1.y != p2.y) {
                return p1.y - p2.y;
            }
            return p1.x - p2.x;
        }
    };
    private final Comparator<IGraphicalEditPart> positionComparator = new Comparator<IGraphicalEditPart>(){

        @Override
        public int compare(IGraphicalEditPart igep1, IGraphicalEditPart igep2) {
            return PinnedElementsHandler.this.pointComparator.compare(PinnedElementsHandler.this.getCurrentPosition(igep1), PinnedElementsHandler.this.getCurrentPosition(igep2));
        }
    };
    private final Comparator<IGraphicalEditPart> leftToRightComparator = new Comparator<IGraphicalEditPart>(){

        @Override
        public int compare(IGraphicalEditPart p1, IGraphicalEditPart p2) {
            return PinnedElementsHandler.this.getCurrentPosition((IGraphicalEditPart)p1).x - PinnedElementsHandler.this.getCurrentPosition((IGraphicalEditPart)p2).x;
        }
    };
    private final Comparator<IGraphicalEditPart> topToBottomComparator = new Comparator<IGraphicalEditPart>(){

        @Override
        public int compare(IGraphicalEditPart p1, IGraphicalEditPart p2) {
            return PinnedElementsHandler.this.getCurrentPosition((IGraphicalEditPart)p1).y - PinnedElementsHandler.this.getCurrentPosition((IGraphicalEditPart)p2).y;
        }
    };
    private final SortedSet<IGraphicalEditPart> allEditParts = new TreeSet<IGraphicalEditPart>(this.positionComparator);
    private final SortedSet<IGraphicalEditPart> fixedEditParts = new TreeSet<IGraphicalEditPart>(this.positionComparator);
    private final Map<IGraphicalEditPart, Rectangle> initialBounds;
    private final Map<IGraphicalEditPart, Rectangle> currentBounds = new HashMap<IGraphicalEditPart, Rectangle>();
    private final DiagramLayoutCustomization layoutCustomization;
    private List<IDiagramElementEditPart> elementsToKeepFixed;

    public PinnedElementsHandler(Collection<IGraphicalEditPart> parts, Map<IGraphicalEditPart, Rectangle> initialBounds, ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        this.initialBounds = Collections.unmodifiableMap(this.getAllInitialPositions(parts, initialBounds));
        this.elementsToKeepFixed = elementsToKeepFixed;
        this.allEditParts.addAll(parts);
        this.isPinned = new IsPinnedPredicate(this.elementsToKeepFixed);
        this.fixedEditParts.addAll(Collections2.filter(parts, this.isPinned));
        this.layoutCustomization = new DiagramLayoutCustomization();
        this.layoutCustomization.initializePaddingWithEditParts(new ArrayList<IGraphicalEditPart>(parts));
    }

    private Map<IGraphicalEditPart, Rectangle> getAllInitialPositions(Collection<IGraphicalEditPart> parts, Map<IGraphicalEditPart, Rectangle> explicitBounds) {
        HashMap<IGraphicalEditPart, Rectangle> result = new HashMap<IGraphicalEditPart, Rectangle>(explicitBounds);
        for (IGraphicalEditPart part : parts) {
            if (result.containsKey(part)) continue;
            Rectangle bounds = part.getFigure().getBounds().getCopy();
            result.put(part, bounds);
        }
        return result;
    }

    public Map<IGraphicalEditPart, Point> computeSolution() {
        this.resetPinnedElements();
        this.removeGaps();
        this.resolveOverlaps();
        return this.getSolution();
    }

    private boolean hasRemainingSolvableOverlaps() {
        for (IGraphicalEditPart part : this.fixedEditParts) {
            if (Collections2.filter(this.findOverlappingParts(part), (Predicate)Predicates.not(this.isPinned)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void resetPinnedElements() {
        for (IGraphicalEditPart part : this.fixedEditParts) {
            this.currentBounds.put(part, part.getFigure().getBounds().getCopy());
        }
    }

    private void removeGaps() {
        if (this.fixedEditParts.isEmpty()) {
            return;
        }
        this.packHorizontally();
        this.packVertically();
    }

    private void packHorizontally() {
        int[] hRange = this.getHorizontalRange(this.allEditParts, false);
        ArrayList movableParts = new ArrayList(Collections2.filter(this.allEditParts, (Predicate)Predicates.not(this.isPinned)));
        Collections.sort(movableParts, this.leftToRightComparator);
        int i = 0;
        while (i < movableParts.size()) {
            Insets leftPadding;
            Rectangle leftBox;
            HashSet<IGraphicalEditPart> leftSide = new HashSet<IGraphicalEditPart>(movableParts.subList(0, i));
            if (i == 0) {
                leftBox = new Rectangle(hRange[0] - 1, 0, 1, 1);
                leftPadding = new Insets(0, 0, 0, 0);
            } else {
                leftBox = this.getBoundingBox(leftSide, false);
                leftPadding = this.getPadding(leftSide);
            }
            HashSet<IGraphicalEditPart> rightSide = new HashSet<IGraphicalEditPart>(movableParts.subList(i, movableParts.size()));
            Rectangle rightBox = this.getBoundingBox(rightSide, false);
            Insets rightPadding = this.getPadding(rightSide);
            int currentGapWidth = rightBox.getLeft().x - leftBox.getRight().x;
            int minGapWidth = Math.max(60, Math.max(leftPadding.right, rightPadding.left));
            if (i == 0 && this.isHorizontalOriginFree(this.allEditParts, hRange[0])) {
                this.translate(rightSide, new Dimension(-currentGapWidth, 0));
            } else if (currentGapWidth > minGapWidth) {
                this.translate(rightSide, new Dimension(-(currentGapWidth - minGapWidth), 0));
            }
            ++i;
        }
    }

    private boolean isHorizontalOriginFree(SortedSet<IGraphicalEditPart> parts, int xOrigin) {
        boolean result = true;
        for (IGraphicalEditPart part : parts) {
            Rectangle bounds = this.getCurrentBounds(part, false);
            boolean bl = result = result && bounds.x != xOrigin;
        }
        return result;
    }

    private boolean isVerticalOriginFree(SortedSet<IGraphicalEditPart> parts, int yOrigin) {
        boolean result = true;
        for (IGraphicalEditPart part : parts) {
            Rectangle bounds = this.getCurrentBounds(part, false);
            boolean bl = result = result && bounds.y != yOrigin;
        }
        return result;
    }

    private int[] getHorizontalRange(Collection<IGraphicalEditPart> parts, boolean includePadding) {
        int minPadding;
        int min = minPadding = this.getSmallestHorizontalMargin(parts);
        int max = Integer.MIN_VALUE;
        for (IGraphicalEditPart part : parts) {
            Rectangle bounds = this.getCurrentBounds(part, includePadding);
            min = Math.min(min, bounds.getLeft().x);
            max = Math.max(max, bounds.getRight().x);
        }
        min = Math.max(min, minPadding);
        return new int[]{min, max};
    }

    private int getSmallestHorizontalMargin(Collection<IGraphicalEditPart> parts) {
        int min = Integer.MAX_VALUE;
        for (IGraphicalEditPart part : parts) {
            min = part.getParent() instanceof DiagramEditPart ? 0 : Math.min(min, this.layoutCustomization.getNodePadding((GraphicalEditPart)part).left);
        }
        return min;
    }

    private void packVertically() {
        int[] vRange = this.getVerticalRange(this.allEditParts, false);
        ArrayList movableParts = new ArrayList(Collections2.filter(this.allEditParts, (Predicate)Predicates.not(this.isPinned)));
        Collections.sort(movableParts, this.topToBottomComparator);
        int i = 0;
        while (i < movableParts.size()) {
            Insets topPadding;
            Rectangle topBox;
            HashSet<IGraphicalEditPart> topSide = new HashSet<IGraphicalEditPart>(movableParts.subList(0, i));
            if (i == 0) {
                topBox = new Rectangle(0, vRange[0] - 1, 1, 1);
                topPadding = new Insets(0, 0, 0, 0);
            } else {
                topBox = this.getBoundingBox(topSide, false);
                topPadding = this.getPadding(topSide);
            }
            HashSet<IGraphicalEditPart> bottomSide = new HashSet<IGraphicalEditPart>(movableParts.subList(i, movableParts.size()));
            Rectangle bottomBox = this.getBoundingBox(bottomSide, false);
            Insets bottomPadding = this.getPadding(bottomSide);
            int currentGapWidth = bottomBox.getTop().y - topBox.getBottom().y;
            int minGapWidth = Math.max(60, Math.max(topPadding.bottom, bottomPadding.top));
            if (i == 0 && this.isVerticalOriginFree(this.allEditParts, vRange[0])) {
                this.translate(bottomSide, new Dimension(0, -currentGapWidth));
            } else if (currentGapWidth > minGapWidth) {
                this.translate(bottomSide, new Dimension(0, -(currentGapWidth - minGapWidth)));
            }
            ++i;
        }
    }

    private int[] getVerticalRange(Collection<IGraphicalEditPart> parts, boolean includePadding) {
        int minPadding;
        int min = minPadding = this.getSmallestVerticalMargin(parts);
        int max = Integer.MIN_VALUE;
        for (IGraphicalEditPart part : parts) {
            Rectangle bounds = this.getCurrentBounds(part, includePadding);
            min = Math.min(min, bounds.getTop().y);
            max = Math.max(max, bounds.getBottom().y);
        }
        min = Math.max(min, minPadding);
        return new int[]{min, max};
    }

    private int getSmallestVerticalMargin(Collection<IGraphicalEditPart> parts) {
        int min = Integer.MAX_VALUE;
        for (IGraphicalEditPart part : parts) {
            min = part.getParent() instanceof DiagramEditPart ? 0 : Math.min(min, this.layoutCustomization.getNodePadding((GraphicalEditPart)part).top);
        }
        return min;
    }

    private void resolveOverlaps() {
        for (IGraphicalEditPart part : this.fixedEditParts) {
            this.resolveOverlaps(part);
        }
        assert (!this.hasRemainingSolvableOverlaps()) : Messages.PinnedElementsHandler_remainOverlapsMsg;
    }

    private void resolveOverlaps(IGraphicalEditPart fixedPart) {
        Set solvableOverlaps = Sets.filter(this.findOverlappingParts(fixedPart), (Predicate)Predicates.not(this.isPinned));
        Map<IDecoratorTarget.Direction, SortedSet<IGraphicalEditPart>> groupedOverlaps = this.groupByDirection(fixedPart, solvableOverlaps);
        for (Map.Entry<IDecoratorTarget.Direction, SortedSet<IGraphicalEditPart>> group : groupedOverlaps.entrySet()) {
            Map<IGraphicalEditPart, Point> previousMovedPositionsBefore = new HashMap<IGraphicalEditPart, Point>();
            for (IGraphicalEditPart part : group.getValue()) {
                assert (this.overlaps(fixedPart, part));
                previousMovedPositionsBefore = this.moveAside(Collections.singleton(part), Collections.singleton(fixedPart), group.getKey(), previousMovedPositionsBefore);
                assert (!this.overlaps(fixedPart, part));
            }
        }
        assert (Collections2.filter(this.findOverlappingParts(fixedPart), (Predicate)Predicates.not(this.isPinned)).isEmpty()) : Messages.PinnedElementsHandler_remainOverlapsMsg;
    }

    private Map<IGraphicalEditPart, Point> moveAside(Set<IGraphicalEditPart> parts, Set<IGraphicalEditPart> fixedParts, IDecoratorTarget.Direction dir, Map<IGraphicalEditPart, Point> previousMovedPositionsOfSameDir) {
        this.addSavePositions((Set<IGraphicalEditPart>)parts, previousMovedPositionsOfSameDir);
        this.tryMove((Set<IGraphicalEditPart>)parts, (Set<IGraphicalEditPart>)fixedParts, dir);
        Set<IGraphicalEditPart> overlaps = this.findOverlappingParts((Set<IGraphicalEditPart>)parts);
        if (!overlaps.isEmpty()) {
            HashSet fixedOverlaps;
            Sets.SetView newMovables = parts;
            Sets.SetView newFixed = fixedParts;
            HashSet movableOverlaps = new HashSet(Collections2.filter(overlaps, (Predicate)Predicates.not(this.isPinned)));
            if (!movableOverlaps.isEmpty()) {
                newMovables = Sets.union(parts, movableOverlaps);
            }
            if (!(fixedOverlaps = new HashSet(Collections2.filter(overlaps, this.isPinned))).isEmpty()) {
                newFixed = Sets.union(fixedParts, fixedOverlaps);
            }
            assert (newMovables.size() > parts.size() || newFixed.size() > fixedParts.size());
            this.moveParts((Set<IGraphicalEditPart>)newMovables, previousMovedPositionsOfSameDir);
            this.moveAside((Set<IGraphicalEditPart>)newMovables, (Set<IGraphicalEditPart>)newFixed, dir, previousMovedPositionsOfSameDir);
        }
        assert (Sets.intersection((Set)Sets.filter(this.findOverlappingParts((Set<IGraphicalEditPart>)fixedParts), (Predicate)Predicates.not(this.isPinned)), parts).isEmpty());
        return previousMovedPositionsOfSameDir;
    }

    private Map<IGraphicalEditPart, Point> addSavePositions(Set<IGraphicalEditPart> parts, Map<IGraphicalEditPart, Point> positionsBefore) {
        for (IGraphicalEditPart part : parts) {
            positionsBefore.put(part, this.getCurrentPosition(part));
        }
        return positionsBefore;
    }

    private void tryMove(Set<IGraphicalEditPart> parts, Set<IGraphicalEditPart> fixedParts, IDecoratorTarget.Direction direction) {
        assert (!Sets.intersection((Set)Sets.filter(this.findOverlappingParts(fixedParts), (Predicate)Predicates.not(this.isPinned)), parts).isEmpty());
        Rectangle movablesBox = this.getBoundingBox(parts, false);
        Insets movablesPadding = this.getPadding(parts);
        Rectangle fixedBox = this.getBoundingBox(fixedParts, false);
        Insets fixedPadding = this.getPadding(fixedParts);
        Dimension move = this.computeMoveVector(movablesBox, movablesPadding, fixedBox, fixedPadding, direction);
        for (IGraphicalEditPart part : parts) {
            this.translate(part, move);
        }
        assert (Sets.intersection((Set)Sets.filter(this.findOverlappingParts(fixedParts), (Predicate)Predicates.not(this.isPinned)), parts).isEmpty());
    }

    private Insets getPadding(Set<IGraphicalEditPart> parts) {
        Rectangle smallBox = this.getBoundingBox(parts, false);
        Rectangle bigBox = this.getBoundingBox(parts, true);
        int top = this.verticalDistance(bigBox.getTop(), smallBox.getTop());
        int left = this.horizontalDistance(bigBox.getLeft(), smallBox.getLeft());
        int bottom = this.verticalDistance(bigBox.getBottom(), smallBox.getBottom());
        int right = this.horizontalDistance(bigBox.getRight(), smallBox.getRight());
        return new Insets(top, left, bottom, right);
    }

    private void translate(Set<IGraphicalEditPart> parts, Dimension move) {
        for (IGraphicalEditPart part : parts) {
            this.translate(part, move);
        }
    }

    private void translate(IGraphicalEditPart part, Dimension move) {
        this.setCurrentPosition(part, this.getCurrentPosition(part).getTranslated(move));
    }

    private Dimension computeMoveVector(Rectangle movable, Insets movablePadding, Rectangle fixed, Insets fixedPadding, IDecoratorTarget.Direction direction) {
        Dimension move;
        if (direction == IDecoratorTarget.Direction.NORTH) {
            move = this.computeNorthMoveVector(movable, movablePadding, fixed, fixedPadding);
        } else if (direction == IDecoratorTarget.Direction.SOUTH) {
            move = this.computeSouthMoveVector(movable, movablePadding, fixed, fixedPadding);
        } else if (direction == IDecoratorTarget.Direction.EAST) {
            move = this.computeEastMoveVector(movable, movablePadding, fixed, fixedPadding);
        } else if (direction == IDecoratorTarget.Direction.WEST) {
            move = this.computeWestMoveVector(movable, movablePadding, fixed, fixedPadding);
        } else if (direction == IDecoratorTarget.Direction.NORTH_EAST) {
            move = this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.NORTH).expand(this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.EAST));
        } else if (direction == IDecoratorTarget.Direction.NORTH_WEST) {
            move = this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.NORTH).expand(this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.WEST));
        } else if (direction == IDecoratorTarget.Direction.SOUTH_EAST) {
            move = this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.SOUTH).expand(this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.EAST));
        } else if (direction == IDecoratorTarget.Direction.SOUTH_WEST) {
            move = this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.SOUTH).expand(this.computeMoveVector(movable, movablePadding, fixed, fixedPadding, IDecoratorTarget.Direction.WEST));
        } else {
            move = null;
            assert (false) : Messages.PinnedElementsHandler_unknownDirection;
        }
        return move;
    }

    private Dimension computeWestMoveVector(Rectangle movable, Insets movablePadding, Rectangle fixed, Insets fixedPadding) {
        Dimension move;
        if (movable.intersects(fixed)) {
            int padding = Math.max(movablePadding.right, fixedPadding.left);
            move = new Dimension(-(padding + this.horizontalDistance(fixed.getLeft(), movable.getRight())), 0);
        } else {
            int dx1 = this.horizontalDistance(fixed.getExpanded(fixedPadding).getLeft(), movable.getRight());
            int dx2 = this.horizontalDistance(fixed.getLeft(), movable.getExpanded(movablePadding).getRight());
            move = new Dimension(-Math.max(dx1, dx2), 0);
        }
        return move;
    }

    private Dimension computeEastMoveVector(Rectangle movable, Insets movablePadding, Rectangle fixed, Insets fixedPadding) {
        Dimension move;
        if (movable.intersects(fixed)) {
            int padding = Math.max(movablePadding.left, fixedPadding.right);
            move = new Dimension(padding + this.horizontalDistance(fixed.getRight(), movable.getLeft()), 0);
        } else {
            int dx1 = this.horizontalDistance(fixed.getExpanded(fixedPadding).getRight(), movable.getLeft());
            int dx2 = this.horizontalDistance(fixed.getRight(), movable.getExpanded(movablePadding).getLeft());
            move = new Dimension(Math.max(dx1, dx2), 0);
        }
        return move;
    }

    private Dimension computeSouthMoveVector(Rectangle movable, Insets movablePadding, Rectangle fixed, Insets fixedPadding) {
        Dimension move;
        if (movable.intersects(fixed)) {
            int padding = Math.max(movablePadding.top, fixedPadding.bottom);
            move = new Dimension(0, padding + this.verticalDistance(fixed.getBottom(), movable.getTop()));
        } else {
            int dy1 = this.verticalDistance(fixed.getExpanded(fixedPadding).getBottom(), movable.getTop());
            int dy2 = this.verticalDistance(fixed.getBottom(), movable.getExpanded(movablePadding).getTop());
            move = new Dimension(0, Math.max(dy1, dy2));
        }
        return move;
    }

    private Dimension computeNorthMoveVector(Rectangle movable, Insets movablePadding, Rectangle fixed, Insets fixedPadding) {
        Dimension move;
        if (movable.intersects(fixed)) {
            int padding = Math.max(movablePadding.bottom, fixedPadding.top);
            move = new Dimension(0, -(padding + this.verticalDistance(fixed.getTop(), movable.getBottom())));
        } else {
            int dy1 = this.verticalDistance(fixed.getExpanded(fixedPadding).getTop(), movable.getBottom());
            int dy2 = this.verticalDistance(fixed.getTop(), movable.getExpanded(movablePadding).getBottom());
            move = new Dimension(0, -Math.max(dy1, dy2));
        }
        return move;
    }

    private int verticalDistance(Point p1, Point p2) {
        return Math.abs(p1.y - p2.y);
    }

    private int horizontalDistance(Point p1, Point p2) {
        return Math.abs(p1.x - p2.x);
    }

    private Map<IDecoratorTarget.Direction, SortedSet<IGraphicalEditPart>> groupByDirection(IGraphicalEditPart origin, Set<IGraphicalEditPart> parts) {
        HashMap<IDecoratorTarget.Direction, SortedSet<IGraphicalEditPart>> result = new HashMap<IDecoratorTarget.Direction, SortedSet<IGraphicalEditPart>>();
        for (IGraphicalEditPart part : parts) {
            IDecoratorTarget.Direction dir = this.getDirection(origin, part);
            if (!result.containsKey(dir)) {
                result.put(dir, new TreeSet<IGraphicalEditPart>(this.positionComparator));
            }
            ((SortedSet)result.get(dir)).add(part);
        }
        return result;
    }

    private IDecoratorTarget.Direction getDirection(IGraphicalEditPart sourcePart, IGraphicalEditPart destPart) {
        Point source = this.getCurrentBounds(sourcePart, false).getCenter();
        Point dest = this.getCurrentBounds(destPart, false).getCenter();
        int dx = dest.x - source.x;
        int dy = dest.y - source.y;
        IDecoratorTarget.Direction result = dx < 0 ? (dy < 0 ? IDecoratorTarget.Direction.NORTH_WEST : (dy == 0 ? IDecoratorTarget.Direction.WEST : IDecoratorTarget.Direction.SOUTH_WEST)) : (dx > 0 ? (dy < 0 ? IDecoratorTarget.Direction.NORTH_EAST : (dy == 0 ? IDecoratorTarget.Direction.EAST : IDecoratorTarget.Direction.SOUTH_EAST)) : (dy < 0 ? IDecoratorTarget.Direction.NORTH : (dy == 0 ? IDecoratorTarget.Direction.EAST : IDecoratorTarget.Direction.SOUTH)));
        return result;
    }

    private Set<IGraphicalEditPart> findOverlappingParts(Set<IGraphicalEditPart> parts) {
        HashSet<IGraphicalEditPart> result = new HashSet<IGraphicalEditPart>();
        for (IGraphicalEditPart part : parts) {
            result.addAll(this.findOverlappingParts(part));
        }
        result.removeAll(parts);
        return result;
    }

    private Set<IGraphicalEditPart> findOverlappingParts(IGraphicalEditPart part) {
        HashSet<IGraphicalEditPart> result = new HashSet<IGraphicalEditPart>();
        for (IGraphicalEditPart candidate : this.allEditParts) {
            if (!this.overlaps(candidate, part)) continue;
            result.add(candidate);
        }
        return result;
    }

    private boolean overlaps(IGraphicalEditPart part1, IGraphicalEditPart part2) {
        if (part1 == part2) {
            return false;
        }
        return this.getCurrentBounds(part1, false).intersects(this.getCurrentBounds(part2, true)) || this.getCurrentBounds(part1, true).intersects(this.getCurrentBounds(part2, false));
    }

    private Rectangle getBoundingBox(Set<IGraphicalEditPart> parts, boolean includePadding) {
        Rectangle box = null;
        for (IGraphicalEditPart part : parts) {
            box = box == null ? this.getCurrentBounds(part, includePadding) : box.getUnion(this.getCurrentBounds(part, includePadding));
        }
        return box;
    }

    private Point getInitialPosition(IGraphicalEditPart part) {
        return this.getInitialBounds(part).getTopLeft();
    }

    private Rectangle getInitialBounds(IGraphicalEditPart part) {
        return this.initialBounds.get(part);
    }

    private Map<IGraphicalEditPart, Point> getSolution() {
        HashMap<IGraphicalEditPart, Point> result = new HashMap<IGraphicalEditPart, Point>();
        for (IGraphicalEditPart part : this.currentBounds.keySet()) {
            result.put(part, this.currentBounds.get(part).getTopLeft());
        }
        return result;
    }

    private Point getCurrentPosition(IGraphicalEditPart part) {
        return this.getCurrentBounds(part, false).getTopLeft();
    }

    private Rectangle getCurrentBounds(IGraphicalEditPart part, boolean includePadding) {
        Rectangle bounds = this.currentBounds.containsKey(part) ? this.currentBounds.get(part) : this.getInitialBounds(part);
        if (includePadding) {
            Insets padding = this.layoutCustomization.getNodePadding((GraphicalEditPart)part);
            return bounds.getExpanded(padding);
        }
        return bounds;
    }

    private void setCurrentPosition(IGraphicalEditPart part, Point position) {
        Preconditions.checkArgument((!this.isPinned.apply((Object)part) ? 1 : 0) != 0, (Object)Messages.PinnedElementsHandler_notMovableMsg);
        if (position.equals((Object)this.getInitialPosition(part))) {
            this.currentBounds.remove(part);
        } else {
            Rectangle oldBounds = this.getCurrentBounds(part, false);
            Rectangle newBounds = new Rectangle(position.x, position.y, oldBounds.width, oldBounds.height);
            this.currentBounds.put(part, newBounds);
        }
    }

    private void moveParts(Set<IGraphicalEditPart> partToReset, Map<IGraphicalEditPart, Point> positions) {
        for (IGraphicalEditPart editPart : partToReset) {
            if (positions.get(editPart) == null) continue;
            this.setCurrentPosition(editPart, positions.get(editPart));
            positions.remove(editPart);
        }
    }

    private void printInitialState() {
        this.debugMessage("===============================================================================");
        this.debugMessage("Initial state (before #resolveOverlaps()");
        this.debugMessage("----------------------------------------");
        for (IGraphicalEditPart part : this.allEditParts) {
            this.debugMessage("- " + part.getClass().getSimpleName() + " (semantic: " + part.resolveSemanticElement() + ")");
            this.debugMessage("  Pinned: " + this.isPinned.apply((Object)part));
            this.debugMessage("  Intrinsic bounds (main figure):              " + part.getFigure().getBounds());
            this.debugMessage("  Initial bounds (after previous layout pass): " + this.getInitialBounds(part));
        }
        this.debugMessage("");
    }

    private void printResolvedState() {
        this.debugMessage("Solution (only moved elements)");
        this.debugMessage("------------------------------");
        for (IGraphicalEditPart part : this.currentBounds.keySet()) {
            this.debugMessage("- " + part.getClass().getSimpleName() + " (semantic: " + part.resolveSemanticElement() + ")");
            this.debugMessage("  Pinned: " + this.isPinned.apply((Object)part));
            this.debugMessage("  Intrinsic bounds (main figure):              " + part.getFigure().getBounds());
            this.debugMessage("  Initial bounds (after previous layout pass): " + this.getInitialBounds(part));
            this.debugMessage("  Computed bounds (after resolution):          " + this.getCurrentPosition(part));
        }
        this.debugMessage("");
    }

    private void debugMessage(String msg) {
    }
}

