/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class JavaSourceLookupUtil {
    public static ISourceContainer[] translate(IRuntimeClasspathEntry[] entries) {
        ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getType()) {
                case 2: {
                    if (entry.getPath().lastSegment().equals("jrt-fs.jar")) {
                        JavaSourceLookupUtil.getPackageFragmentRootContainers(entry, containers);
                        break;
                    }
                    IPackageFragmentRoot root = JavaSourceLookupUtil.getPackageFragmentRoot(entry);
                    if (root == null) {
                        JavaSourceLookupUtil.addSourceAttachment(entry, containers);
                        break;
                    }
                    PackageFragmentRootSourceContainer container = new PackageFragmentRootSourceContainer(root);
                    if (containers.contains((Object)container)) break;
                    containers.add((ISourceContainer)container);
                    break;
                }
                case 1: {
                    IResource resource = entry.getResource();
                    if (resource == null || resource.getType() != 4) break;
                    IJavaProject javaProject = JavaCore.create((IProject)((IProject)resource));
                    JavaProjectSourceContainer container = null;
                    if (javaProject.exists()) {
                        container = new JavaProjectSourceContainer(javaProject);
                    } else if (resource.exists()) {
                        container = new ProjectSourceContainer((IProject)resource, false);
                    }
                    if (container == null || containers.contains((Object)container)) break;
                    containers.add((ISourceContainer)container);
                    break;
                }
            }
            ++i;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    private static void addSourceAttachment(IRuntimeClasspathEntry entry, List<ISourceContainer> containers) {
        String path = entry.getSourceAttachmentLocation();
        Object container = null;
        if (path == null) {
            path = entry.getLocation();
        }
        if (path != null) {
            IResource resource;
            File file = new File(path);
            container = file.isDirectory() ? ((resource = entry.getResource()) instanceof IContainer ? new FolderSourceContainer((IContainer)resource, false) : new DirectorySourceContainer(file, false)) : new ExternalArchiveSourceContainer(path, true);
            if (!containers.contains(container)) {
                containers.add((ISourceContainer)container);
            }
        }
    }

    private static boolean isSourceAttachmentEqual(IPackageFragmentRoot root, IRuntimeClasspathEntry entry) throws JavaModelException {
        IPath entryPath = entry.getSourceAttachmentPath();
        if (entryPath == null) {
            return true;
        }
        IPath rootPath = root.getSourceAttachmentPath();
        if (rootPath == null) {
            return false;
        }
        return rootPath.equals((Object)entryPath);
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IRuntimeClasspathEntry entry) {
        IResource resource = entry.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            IJavaProject jp = JavaCore.create((IProject)project);
            try {
                IPackageFragmentRoot root;
                if (project.isOpen() && jp.exists() && (root = jp.findPackageFragmentRoot(resource.getFullPath())) != null && JavaSourceLookupUtil.isSourceAttachmentEqual(root, entry)) {
                    return root;
                }
            }
            catch (JavaModelException e) {
                LaunchingPlugin.log(e);
            }
        }
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IPath entryPath = entry.getPath();
        try {
            IJavaProject[] jps = model.getJavaProjects();
            int i = 0;
            while (i < jps.length) {
                IJavaProject jp = jps[i];
                IProject p = jp.getProject();
                if (p.isOpen()) {
                    IPackageFragmentRoot[] allRoots = jp.getPackageFragmentRoots();
                    int j = 0;
                    while (j < allRoots.length) {
                        IPackageFragmentRoot root = allRoots[j];
                        if (root.getPath().equals((Object)entryPath) && JavaSourceLookupUtil.isSourceAttachmentEqual(root, entry)) {
                            return root;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            LaunchingPlugin.log(e);
        }
        return null;
    }

    private static void getPackageFragmentRootContainers(IRuntimeClasspathEntry entry, List<ISourceContainer> containers) {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IPath entryPath = entry.getPath();
        boolean found = false;
        try {
            IJavaProject[] jps = model.getJavaProjects();
            int i = 0;
            while (i < jps.length) {
                IJavaProject jp = jps[i];
                IProject p = jp.getProject();
                if (p.isOpen()) {
                    IPackageFragmentRoot[] allRoots = jp.getPackageFragmentRoots();
                    int j = 0;
                    while (j < allRoots.length) {
                        PackageFragmentRootSourceContainer container;
                        IPackageFragmentRoot root = allRoots[j];
                        if (root.getPath().equals((Object)entryPath) && JavaSourceLookupUtil.isSourceAttachmentEqual(root, entry) && !containers.contains((Object)(container = new PackageFragmentRootSourceContainer(root)))) {
                            containers.add((ISourceContainer)container);
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            LaunchingPlugin.log(e);
        }
        if (!found) {
            JavaSourceLookupUtil.addSourceAttachment(entry, containers);
        }
    }
}

