/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.ui.business.api.image.GallerySelectable;
import org.eclipse.sirius.diagram.ui.business.api.image.ITreeImagesContentProvider;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.WorkspaceFileResourceChangeListener;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.Gallery;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.GalleryItem;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.widgets.gallery.GalleryRendererUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.UIJob;

public class TreeImagesGalleryComposite
extends FilteredTree {
    public static final String REFRESH_IMAGE_JOB_FAMILY = RefreshImageJob.class.getName();
    private static final String SLASH = "/";
    private ILabelProvider labelProvider;
    private ITreeImagesContentProvider contentProvider;
    private List<ViewerFilter> filters;
    private Object input;
    private GallerySelectable usedGallery;
    private String selectedImagePath;
    private Map<File, Image> thumbnailsImagesCache = new HashMap<File, Image>();
    private Composite galleryComposite;
    private String lastUserFilter;
    private Image loadingImage;
    private Object lastTreeSelection;
    private boolean galleryNeedsRefresh;
    private PatternFilter galleryPatternFilter;

    protected TreeImagesGalleryComposite(Composite parent, int treeStyle, PatternFilter filter, final ILabelProvider labelProvider, ITreeImagesContentProvider contentProvider, List<ViewerFilter> viewerFilters, Object input) {
        super(parent, treeStyle, filter, true, true);
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
        this.filters = viewerFilters;
        this.input = input;
        this.selectedImagePath = null;
        this.lastUserFilter = "";
        this.galleryPatternFilter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                String labelText = labelProvider.getText(element);
                if (labelText == null) {
                    return false;
                }
                return this.wordMatches(labelText);
            }
        };
        super.init(treeStyle, filter);
        this.setInitialText(Messages.ResourceSelectionDialog_ImageTreeComposite_filterText);
    }

    public static TreeImagesGalleryComposite createTreeImagesGalleryComposite(Composite parent, ILabelProvider labelProvider, ITreeImagesContentProvider contentProvider, List<ViewerFilter> viewerFilters, Object input) {
        return new TreeImagesGalleryComposite(parent, 2052, new PatternFilter(), labelProvider, contentProvider, viewerFilters, input);
    }

    protected void init(int treeStyle, PatternFilter filter) {
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout(2, true);
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        this.setLayoutData(layoutData);
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            this.filterComposite.setLayout((Layout)new GridLayout());
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        this.treeComposite.setLayout((Layout)new GridLayout());
        this.treeComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTreeControl(this.treeComposite, treeStyle);
        this.galleryComposite = new Composite((Composite)this, 0);
        this.galleryComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.galleryComposite.setLayout((Layout)new GridLayout(1, false));
        this.createGalleryControl(this.galleryComposite);
        Composite radiosComposite = new Composite(this.galleryComposite, 0);
        radiosComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        radiosComposite.setLayout((Layout)new GridLayout(2, true));
        this.createRadiosControl(radiosComposite);
    }

    protected Control createTreeControl(Composite parent, int style) {
        super.createTreeControl(parent, style);
        if (this.treeViewer != null) {
            this.treeViewer.setUseHashlookup(true);
        }
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        if (this.filters != null) {
            int i = 0;
            while (i != this.filters.size()) {
                this.treeViewer.addFilter(this.filters.get(i));
                ++i;
            }
        }
        this.treeViewer.addDoubleClickListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object item = ((IStructuredSelection)selection).getFirstElement();
                if (this.treeViewer.getExpandedState(item)) {
                    this.treeViewer.collapseToLevel(item, 1);
                } else {
                    this.treeViewer.expandToLevel(item, 1);
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeImagesGalleryComposite.this.cancelRefresh();
                TreeImagesGalleryComposite.this.refreshGallery();
                if (!event.getStructuredSelection().isEmpty()) {
                    if (event.getStructuredSelection().getFirstElement() != TreeImagesGalleryComposite.this.lastTreeSelection) {
                        TreeImagesGalleryComposite.this.selectedImagePath = null;
                    }
                    TreeImagesGalleryComposite.this.lastTreeSelection = event.getStructuredSelection().getFirstElement();
                } else {
                    TreeImagesGalleryComposite.this.lastTreeSelection = null;
                }
            }
        });
        this.treeViewer.setInput(this.input);
        return this.treeViewer.getControl();
    }

    public Optional<String> setSelection(Object treeViewerSelectionData, Object gallerySelectionData) {
        Optional<String> selectedPath = Optional.empty();
        if (treeViewerSelectionData != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(treeViewerSelectionData), true);
        }
        if (gallerySelectionData != null && this.usedGallery.getItems().length > 0) {
            GalleryItem[] items;
            GalleryItem[] galleryItemArray = items = this.usedGallery.getItems()[0].getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GalleryItem galleryItem = galleryItemArray[n2];
                String text = galleryItem.getText();
                if (text.equals(this.labelProvider.getText(gallerySelectionData))) {
                    this.usedGallery.selectItem(galleryItem, true);
                }
                ++n2;
            }
        }
        return selectedPath;
    }

    protected void cancelRefresh() {
        Job.getJobManager().cancel((Object)REFRESH_IMAGE_JOB_FAMILY);
    }

    protected void createGalleryControl(Composite parent) {
        this.usedGallery = new GallerySelectable(parent, 2560);
        this.usedGallery.setBackground(Display.getCurrent().getSystemColor(1));
        GridData layoutData = new GridData(4, 4, true, true);
        this.usedGallery.setLayoutData(layoutData);
        GalleryRendererUtils.setStandardGallery(parent, this.usedGallery);
        this.createGalleryListeners(this.usedGallery);
    }

    protected void createGalleryListeners(Gallery gallery) {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    Object imageWrapper = ((GalleryItem)e.item).getData();
                    Optional<String> optImgPath = TreeImagesGalleryComposite.this.contentProvider.getPath(imageWrapper);
                    if (optImgPath.isPresent()) {
                        TreeImagesGalleryComposite.this.selectedImagePath = optImgPath.get().replace(File.separator, TreeImagesGalleryComposite.SLASH);
                    }
                } else {
                    TreeImagesGalleryComposite.this.selectedImagePath = null;
                }
            }
        };
        gallery.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void createRadiosControl(Composite parent) {
        Button listRadio = new Button(parent, 16);
        listRadio.setText(Messages.ResourceSelectionDialog_ImageTreeComposite_radioListDisplay);
        listRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    GalleryRendererUtils.setListGallery(TreeImagesGalleryComposite.this.galleryComposite, TreeImagesGalleryComposite.this.usedGallery);
                }
            }
        });
        listRadio.setSelection(false);
        Button gridRadio = new Button(parent, 16);
        gridRadio.setText(Messages.ResourceSelectionDialog_ImageTreeComposite_radioGridDisplay);
        gridRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    GalleryRendererUtils.setStandardGallery(TreeImagesGalleryComposite.this.galleryComposite, TreeImagesGalleryComposite.this.usedGallery);
                }
            }
        });
        gridRadio.setSelection(true);
    }

    public void createListenerForOKButton(final Button okButton) {
        this.usedGallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                okButton.setEnabled(e.item != null);
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                okButton.setEnabled(TreeImagesGalleryComposite.this.getSelectedImagePath() != null);
            }
        });
    }

    /*
     * Could not resolve type clashes
     */
    private Set<Object> getImagesToAdd(String filter) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
        TreeSet<Object> imagesToAdd = new TreeSet<Object>(comparator);
        ITreeSelection structuredSelection = this.treeViewer.getStructuredSelection();
        if (!structuredSelection.isEmpty()) {
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isFilteringNeeded;
                Object object = objectArray[n2];
                TreeSet<Object> images = new TreeSet<Object>(comparator);
                Object[] objectArray2 = this.contentProvider.getChildren(object);
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object element = objectArray2[n4];
                    if (this.contentProvider.getImageFile(element).isPresent()) {
                        images.add(element);
                    }
                    ++n4;
                }
                boolean bl = isFilteringNeeded = filter != null && !filter.isEmpty() && !filter.equals(this.initialText);
                if (isFilteringNeeded) {
                    this.galleryPatternFilter.setPattern(filter);
                    for (Object image : images) {
                        if (!this.galleryPatternFilter.isElementVisible(null, image)) continue;
                        imagesToAdd.add(image);
                    }
                } else {
                    imagesToAdd.addAll(images);
                }
                ++n2;
            }
        }
        return imagesToAdd;
    }

    public void refreshGallery() {
        String filterString = this.getFilterString();
        if (!this.lastUserFilter.equals(filterString) || this.lastTreeSelection != this.treeViewer.getStructuredSelection().getFirstElement() || this.galleryNeedsRefresh) {
            Set<Object> imagesToAdd = this.getImagesToAdd(filterString);
            this.usedGallery.removeAll();
            this.usedGallery.redraw();
            GalleryItem defaultCategory = new GalleryItem(this.usedGallery, 0);
            for (Object imageFile : imagesToAdd) {
                this.createImageItem(defaultCategory, imageFile);
            }
            if (!this.lastUserFilter.equals(filterString) && this.usedGallery.getItems().length > 0 && this.selectedImagePath != null && this.lastTreeSelection != null) {
                GalleryItem[] items = this.usedGallery.getItems()[0].getItems();
                String[] segments = this.selectedImagePath.split(SLASH);
                String imageName = segments[segments.length - 1];
                int nbSegments = segments.length;
                boolean similarFolder = false;
                Object treeNode = this.lastTreeSelection;
                int index = nbSegments - 2;
                while (treeNode != null && index >= 0) {
                    String folderLabel = this.labelProvider.getText(treeNode);
                    similarFolder = folderLabel != null && (folderLabel.isEmpty() || folderLabel.equals(segments[index]));
                    treeNode = this.contentProvider.getParent(treeNode);
                    --index;
                }
                if (similarFolder) {
                    GalleryItem[] galleryItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GalleryItem galleryItem = galleryItemArray[n2];
                        if (galleryItem != null && galleryItem.getText().equals(imageName)) {
                            this.usedGallery.selectItem(galleryItem, false);
                        }
                        ++n2;
                    }
                }
            }
            this.lastUserFilter = filterString;
        }
        this.setGalleryNeedsRefresh(false);
    }

    private void createImageItem(GalleryItem categoryItem, Object imageWrapper) {
        GalleryItem imageItem = new GalleryItem(categoryItem, 0);
        Optional<File> optImgFile = this.contentProvider.getImageFile(imageWrapper);
        String imageName = this.labelProvider.getText(imageWrapper);
        if (optImgFile.isPresent() && !imageName.isEmpty()) {
            File imageFile = optImgFile.get();
            Image image = this.thumbnailsImagesCache.get(imageFile);
            if (image == null) {
                image = this.getLoadingImage();
                this.thumbnailsImagesCache.put(imageFile, image);
            }
            imageItem.setData(imageWrapper);
            imageItem.setImage(image);
            imageItem.setText(imageName);
            if (image == this.getLoadingImage()) {
                RefreshImageJob refreshJob = new RefreshImageJob(imageItem, imageWrapper);
                refreshJob.schedule();
            }
        }
    }

    protected void textChanged() {
        super.textChanged();
        ISelection selection = this.treeViewer.getSelection();
        ITreeSelection structuredSelection = this.treeViewer.getStructuredSelection();
        if (selection != null && !selection.isEmpty() || structuredSelection != null && !structuredSelection.isEmpty()) {
            this.refreshGallery();
        }
    }

    public void dispose() {
        if (this.loadingImage != null) {
            if (!this.loadingImage.isDisposed()) {
                this.loadingImage.dispose();
            }
            this.loadingImage = null;
        }
        for (Image image : this.thumbnailsImagesCache.values()) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this.thumbnailsImagesCache.clear();
        super.dispose();
    }

    public GallerySelectable getGallery() {
        return this.usedGallery;
    }

    public String getSelectedImagePath() {
        return this.selectedImagePath;
    }

    public void setSelectedImagePath(String selectedImage) {
        this.selectedImagePath = selectedImage;
    }

    public void setGalleryNeedsRefresh(boolean galleryNeedsRefresh) {
        this.galleryNeedsRefresh = galleryNeedsRefresh;
    }

    private Image getLoadingImage() {
        if (this.loadingImage == null) {
            ImageDescriptor desc = DiagramUIPlugin.Implementation.findImageDescriptor("/org.eclipse.sirius.diagram.ui/images/loading.png");
            this.loadingImage = desc.createImage();
        }
        return this.loadingImage;
    }

    public class RefreshImageJob
    extends UIJob {
        private GalleryItem item;
        private Object imageWrapper;

        public RefreshImageJob(GalleryItem imageItem, Object imageWrapper) {
            super(RefreshImageJob.class.getName());
            this.item = imageItem;
            this.imageWrapper = imageWrapper;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Optional<File> optImgFile = TreeImagesGalleryComposite.this.contentProvider.getImageFile(this.imageWrapper);
            Optional<String> optImgPath = TreeImagesGalleryComposite.this.contentProvider.getPath(this.imageWrapper);
            if (!monitor.isCanceled() && !this.item.isDisposed() && optImgFile.isPresent() && optImgPath.isPresent()) {
                File imageFile = optImgFile.get();
                String imagePath = optImgPath.get();
                Image image = TreeImagesGalleryComposite.this.thumbnailsImagesCache.get(imageFile);
                if (image == TreeImagesGalleryComposite.this.getLoadingImage()) {
                    try {
                        if (WorkspaceImageFigure.isSvgImage(imagePath)) {
                            SVGFigureWithoutSiriusCache fig = new SVGFigureWithoutSiriusCache();
                            image = fig.getImage(imageFile);
                        } else {
                            ImageDescriptor desc = WorkspaceFileResourceChangeListener.getInstance().findImageDescriptor(imageFile);
                            image = desc.createImage();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                    TreeImagesGalleryComposite.this.thumbnailsImagesCache.put(imageFile, image);
                }
                this.item.setImage(image);
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        public boolean belongsTo(Object family) {
            return REFRESH_IMAGE_JOB_FAMILY.equals(family);
        }

        private class SVGFigureWithoutSiriusCache
        extends SVGFigure {
            private SVGFigureWithoutSiriusCache() {
            }

            @Override
            protected Image getImage(Rectangle clientArea, Graphics graphics) {
                Image img = null;
                if (this.getTranscoder() != null) {
                    img = this.getTranscoder().render(this, clientArea, graphics, true);
                }
                return img;
            }

            public Image getImage(File imageFile) {
                this.setURI(imageFile.toURI().toString());
                return this.getImage((Rectangle)new PrecisionRectangle(0.0, 0.0, 100.0, 100.0), null);
            }
        }
    }
}

