/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.preference;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SessionPreferenceComponent {
    private Button useProjectSettings;
    private Group propertiesGroup;
    private Hyperlink preferenceLink;
    private Button refreshAtOpeningButton;
    private Button autoRefreshbutton;

    public Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createHeader(composite);
        this.createRefreshPreferencesGroup(composite);
        return composite;
    }

    private void createHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useProjectSettings = new Button(composite, 32);
        this.useProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionPreferenceComponent.this.setProjectSettingsEnabled(SessionPreferenceComponent.this.useProjectSettings.getSelection());
            }
        });
        this.useProjectSettings.setText(Messages.SiriusPreferencesPropertyPage_enableProjectSpecificSettings);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.useProjectSettings);
        this.preferenceLink = new Hyperlink(composite, 0);
        this.preferenceLink.setUnderlined(true);
        this.preferenceLink.setText(Messages.SiriusPreferencesPropertyPage_configureWorkspaceSettings);
        this.preferenceLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)SessionPreferenceComponent.this.preferenceLink.getShell(), (String)"org.eclipse.sirius.ui.page", (String[])new String[]{"org.eclipse.sirius.ui.page"}, null);
                dlg.open();
            }
        });
        Label horizontalLine = new Label(composite, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
    }

    private void setProjectSettingsEnabled(boolean enabled) {
        this.propertiesGroup.setEnabled(enabled);
        this.autoRefreshbutton.setEnabled(enabled);
        this.refreshAtOpeningButton.setEnabled(enabled);
        this.preferenceLink.setEnabled(!enabled);
        if (!enabled) {
            this.preferenceLink.setForeground(JFaceColors.getHyperlinkText((Display)this.preferenceLink.getDisplay()));
        } else {
            this.preferenceLink.setForeground(this.preferenceLink.getDisplay().getSystemColor(33));
        }
    }

    private Group createRefreshPreferencesGroup(Composite parent) {
        this.propertiesGroup = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.propertiesGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.propertiesGroup.setLayoutData((Object)gridData);
        this.propertiesGroup.setText(Messages.SiriusPreferencePage_refreshGroup);
        Composite refreshAtOpeningComposite = new Composite((Composite)this.propertiesGroup, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        refreshAtOpeningComposite.setLayout((Layout)layout);
        refreshAtOpeningComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.refreshAtOpeningButton = new Button(refreshAtOpeningComposite, 32);
        this.refreshAtOpeningButton.setText(Messages.SiriusPreferencePage_refreshOnRepresentationOpening);
        Composite autoRefreshcomposite = new Composite((Composite)this.propertiesGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        autoRefreshcomposite.setLayout((Layout)layout);
        autoRefreshcomposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.autoRefreshbutton = new Button(autoRefreshcomposite, 32);
        this.autoRefreshbutton.setText(Messages.SiriusPreferencePage_autoRefresh);
        return this.propertiesGroup;
    }

    public void setProjectSpecificSettings(boolean value) {
        this.useProjectSettings.setSelection(value);
        this.setProjectSettingsEnabled(value);
    }

    public void setAutoRefresh(boolean value) {
        this.autoRefreshbutton.setSelection(value);
    }

    public void setRefreshAtOpening(boolean value) {
        this.refreshAtOpeningButton.setSelection(value);
    }

    public boolean isProjectSpecificSettings() {
        return this.useProjectSettings.getSelection();
    }

    public boolean isAutoRefresh() {
        return this.autoRefreshbutton.getSelection();
    }

    public boolean isRefreshAtOpening() {
        return this.refreshAtOpeningButton.getSelection();
    }
}

