/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure.svg;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.apache.batik.bridge.EmbededExternalResourceSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.ParsedURL;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.svg.SVGUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public class SimpleImageTranscoder
extends SVGAbstractTranscoder {
    private BufferedImage bufferedImage;
    private Document document;
    private int canvasWidth = -1;
    private int canvasHeight = -1;
    private RenderingHints renderingHints;

    public SimpleImageTranscoder(Document document) {
        this.document = document;
        this.renderingHints = new RenderingHints(null);
    }

    protected UserAgent createUserAgent() {
        return new UserAgentAdapter(){

            public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
                return new EmbededExternalResourceSecurity(resourceURL);
            }
        };
    }

    public final Document getDocument() {
        return this.document;
    }

    public int getImageHeight() {
        int height = 0;
        height = this.canvasHeight == -1 ? this.getBufferedImage().getHeight() : this.canvasHeight;
        return height;
    }

    public int getImageWidth() {
        int width = 0;
        width = this.canvasWidth == -1 ? this.getBufferedImage().getWidth() : this.canvasWidth;
        return width;
    }

    public int getImageAlphaValue(int x, int y) {
        BufferedImage bufferedImage = this.getBufferedImage();
        if (bufferedImage != null && bufferedImage.getWidth() >= x && bufferedImage.getHeight() >= y) {
            int[] result = bufferedImage.getAlphaRaster().getPixel(x, y, new int[1]);
            return result[0];
        }
        return 255;
    }

    public double getAspectRatio() {
        BufferedImage img;
        if ((this.canvasHeight == -1 || this.canvasWidth == -1) && (img = this.getBufferedImage()) != null) {
            int width = img.getWidth();
            int height = img.getHeight();
            return (double)width / (double)height;
        }
        return (double)this.canvasWidth / (double)this.canvasHeight;
    }

    public void contentChanged() {
        this.bufferedImage = null;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        super.transcode(document, uri, output);
        int w = (int)((double)this.width + 0.5);
        int h = (int)((double)this.height + 0.5);
        ImageRenderer renderer = this.createImageRenderer();
        renderer.updateOffScreen(w, h);
        renderer.setTransform(this.curTxf);
        renderer.setTree(this.root);
        this.root = null;
        try {
            Rectangle2D.Float raoi = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            renderer.repaint(this.curTxf.createInverse().createTransformedShape(raoi));
            this.bufferedImage = renderer.getOffScreen();
        }
        catch (Exception ex) {
            throw new TranscoderException(ex);
        }
    }

    private ImageRenderer createImageRenderer() {
        StaticRenderer renderer = new StaticRenderer();
        renderer.getRenderingHints().add(this.renderingHints);
        return renderer;
    }

    public Image render(SVGFigure fig, Rectangle clientArea, Graphics graphics, boolean scaleImage) {
        Image result = null;
        if (this.document != null) {
            if (scaleImage && graphics != null) {
                PrecisionRectangle scaledArea = new PrecisionRectangle(clientArea);
                scaledArea.performScale(graphics.getAbsoluteScale());
                this.setCanvasSize(scaledArea.width(), scaledArea.height());
            } else {
                this.setCanvasSize(clientArea.width(), clientArea.height());
            }
            this.updateRenderingHints(graphics);
            BufferedImage awtImage = this.getBufferedImage();
            if (awtImage != null) {
                result = SVGUtils.toSWT((Device)Display.getCurrent(), awtImage);
            }
        }
        return result;
    }

    private void updateImage() {
        if (this.document == null) {
            return;
        }
        try {
            if (this.canvasWidth > 0) {
                this.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.canvasWidth));
            } else {
                this.removeTranscodingHint(ImageTranscoder.KEY_WIDTH);
            }
            if (this.canvasHeight > 0) {
                this.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.canvasHeight));
            } else {
                this.removeTranscodingHint(ImageTranscoder.KEY_HEIGHT);
            }
            this.removeTranscodingHint(ImageTranscoder.KEY_AOI);
            this.transcode(new TranscoderInput(this.document), new TranscoderOutput());
        }
        catch (TranscoderException e) {
            DiagramPlugin.getDefault().logError(Messages.SimpleImageTranscoder_svgImageTranscodingError, (Throwable)e);
        }
    }

    private void setCanvasSize(int width, int height) {
        if (this.canvasWidth == width && this.canvasHeight == height) {
            return;
        }
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.contentChanged();
    }

    private BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            this.updateImage();
        }
        return this.bufferedImage;
    }

    private void updateRenderingHints(Graphics graphics) {
        Object antiAliasHint = SVGUtils.getAntialiasHint(graphics);
        if (this.renderingHints.get(RenderingHints.KEY_ANTIALIASING) != antiAliasHint) {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, antiAliasHint);
            this.contentChanged();
        }
        Object textAntiAliasHint = SVGUtils.getTextAntialiasHint(graphics);
        if (this.renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING) != textAntiAliasHint) {
            this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, textAntiAliasHint);
            this.contentChanged();
        }
    }
}

