/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.DebugUIPluginFacade;
import org.eclipse.egit.ui.internal.branch.IDebugUIPluginFacade;
import org.eclipse.egit.ui.internal.branch.NoopDebugUIPluginFacade;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public final class LaunchFinder {
    private static final IDebugUIPluginFacade debugPluginFacade = LaunchFinder.hasDebugUiBundle() ? new DebugUIPluginFacade() : new NoopDebugUIPluginFacade();

    private static final boolean hasDebugUiBundle() {
        try {
            return Class.forName("org.eclipse.debug.core.ILaunchConfiguration") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private LaunchFinder() {
    }

    @Nullable
    public static String getRunningLaunchConfiguration(Collection<Repository> repositories, IProgressMonitor monitor) {
        return debugPluginFacade.getRunningLaunchConfigurationName(repositories, monitor);
    }

    public static boolean shouldCancelBecauseOfRunningLaunches(Repository repository, IProgressMonitor monitor) {
        return LaunchFinder.shouldCancelBecauseOfRunningLaunches(Collections.singleton(repository), monitor);
    }

    public static boolean shouldCancelBecauseOfRunningLaunches(Collection<Repository> repositories, IProgressMonitor monitor) {
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!store.getBoolean("show_running_launch_on_checkout_warning")) {
            return false;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        final String launchConfiguration = LaunchFinder.getRunningLaunchConfiguration(repositories, (IProgressMonitor)progress);
        if (launchConfiguration != null) {
            final boolean[] dialogResult = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    dialogResult[0] = LaunchFinder.showContinueDialogInUI(store, launchConfiguration);
                }
            });
            return dialogResult[0];
        }
        return false;
    }

    private static boolean showContinueDialogInUI(IPreferenceStore store, String launchConfiguration) {
        String[] buttons = new String[]{UIText.BranchOperationUI_Continue, IDialogConstants.CANCEL_LABEL};
        String message = String.valueOf(NLS.bind((String)UIText.LaunchFinder_RunningLaunchMessage, (Object)launchConfiguration)) + ' ' + UIText.LaunchFinder_ContinueQuestion;
        MessageDialogWithToggle continueDialog = new MessageDialogWithToggle(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), UIText.LaunchFinder_RunningLaunchTitle, null, message, 0, buttons, 0, UIText.LaunchFinder_RunningLaunchDontShowAgain, false);
        int result = continueDialog.open();
        if (result == 1 || result == -1) {
            return true;
        }
        boolean dontWarnAgain = continueDialog.getToggleState();
        if (dontWarnAgain) {
            store.setValue("show_running_launch_on_checkout_warning", false);
        }
        return false;
    }
}

