/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardPage;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class UpdateSingleIUPage
extends ProvisioningWizardPage {
    UpdateOperation operation;

    protected UpdateSingleIUPage(UpdateOperation operation, ProvisioningUI ui) {
        super("UpdateSingleIUPage", ui, null);
        this.setTitle(ProvUIMessages.UpdateAction_UpdatesAvailableTitle);
        IProduct product = Platform.getProduct();
        String productName = product != null && product.getName() != null ? product.getName() : ProvUIMessages.ApplicationInRestartDialog;
        this.setDescription(NLS.bind((String)ProvUIMessages.UpdateSingleIUPage_SingleUpdateDescription, (Object)productName));
        Assert.isNotNull((Object)operation);
        Assert.isTrue((boolean)operation.hasResolved());
        Assert.isTrue((operation.getSelectedUpdates().length == 1 ? 1 : 0) != 0);
        Assert.isTrue((boolean)operation.getResolutionResult().isOK());
        this.operation = operation;
    }

    public void createControl(Composite parent) {
        IInstallableUnit updateIU = this.getUpdate().replacement;
        String url = null;
        if (updateIU.getUpdateDescriptor().getLocation() != null) {
            try {
                url = URIUtil.toURL((URI)updateIU.getUpdateDescriptor().getLocation()).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (url != null) {
            Browser browser = null;
            try {
                browser = new Browser(parent, 0);
                browser.setUrl(url);
                browser.setBackground(parent.getBackground());
                Point size = this.getProvisioningUI().getPolicy().getUpdateDetailsPreferredSize();
                if (size != null) {
                    browser.setSize(size);
                }
                this.setControl((Control)browser);
                return;
            }
            catch (SWTError sWTError) {}
        }
        Text text = new Text(parent, 522);
        text.setBackground(parent.getBackground());
        text.setText(this.getUpdateText(updateIU));
        this.setControl((Control)text);
    }

    private String getUpdateText(IInstallableUnit iu) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new IUDetailsLabelProvider().getClipboardText(this.getUpdate().replacement, "\t"));
        buffer.append(CopyUtils.NEWLINE);
        buffer.append(CopyUtils.NEWLINE);
        String text = iu.getUpdateDescriptor().getDescription();
        if (text != null) {
            buffer.append(text);
        } else {
            text = iu.getProperty("org.eclipse.equinox.p2.description");
            if (text != null) {
                buffer.append(text);
            }
        }
        return buffer.toString();
    }

    public boolean performFinish() {
        if (this.operation.getResolutionResult().getSeverity() != 4) {
            this.getProvisioningUI().schedule(this.operation.getProvisioningJob(null), 3);
            return true;
        }
        return false;
    }

    @Override
    protected String getClipboardText(Control control) {
        return this.getUpdate().toString();
    }

    private Update getUpdate() {
        return this.operation.getSelectedUpdates()[0];
    }
}

