/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IResourceFilter;
import org.eclipse.m2e.wtp.overlay.internal.utilities.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemResourceFilter
implements IResourceFilter {
    private SimpleScanner scanner;

    public FileSystemResourceFilter(Collection<String> inclusions, Collection<String> exclusions, IPath baseDirPath) {
        this.scanner = new SimpleScanner(baseDirPath);
        if (inclusions != null && !inclusions.isEmpty()) {
            this.scanner.setIncludes(inclusions.toArray(new String[inclusions.size()]));
        } else {
            this.scanner.setIncludes(new String[]{"**/**"});
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            this.scanner.addExcludes(exclusions.toArray(new String[exclusions.size()]));
        }
        this.scanner.addDefaultExcludes();
        this.scanner.scan();
    }

    @Override
    public boolean accepts(String resourcePath, boolean isFile) {
        return this.scanner.accepts(resourcePath, isFile);
    }

    class SimpleScanner
    extends DirectoryScanner {
        private String baseDirAsString;
        private Set<String> includedFiles;
        private Set<String> excludedFiles;
        private Set<String> includedFolders;
        private Set<String> excludedFolders;

        public synchronized void setIncludes(String[] includes) {
            super.setIncludes(this.setFileSeparator(includes));
        }

        public synchronized void setExcludes(String[] excludes) {
            super.setExcludes(this.setFileSeparator(excludes));
        }

        private String[] setFileSeparator(String[] patterns) {
            if (patterns != null) {
                int i = 0;
                while (i < patterns.length) {
                    patterns[i] = PathUtil.useSystemSeparator(patterns[i]);
                    ++i;
                }
            }
            return patterns;
        }

        public SimpleScanner(IPath baseDirPath) {
            this.baseDirAsString = baseDirPath.toOSString();
            this.setBasedir(this.baseDirAsString);
        }

        public void scan() throws IllegalStateException {
            super.scan();
            this.includedFiles = new HashSet<String>(Arrays.asList(this.getIncludedFiles()));
            this.excludedFiles = new HashSet<String>(Arrays.asList(this.getExcludedFiles()));
            this.includedFolders = new HashSet<String>(Arrays.asList(this.getIncludedDirectories()));
            this.excludedFolders = new HashSet<String>(Arrays.asList(this.getExcludedDirectories()));
            this.completeIncludedFolders();
        }

        private void completeIncludedFolders() {
            IPath parentPath;
            Path filePath;
            HashSet<String> missingParentFolders = new HashSet<String>();
            for (String folder : this.includedFolders) {
                filePath = new Path(folder);
                parentPath = filePath.removeLastSegments(1);
                while (parentPath.segmentCount() > 0) {
                    String pathAsString = parentPath.toOSString();
                    if (!this.includedFolders.contains(pathAsString)) {
                        missingParentFolders.add(pathAsString);
                    }
                    parentPath = parentPath.removeLastSegments(1);
                }
            }
            this.includedFolders.addAll(missingParentFolders);
            block2: for (String file : this.includedFiles) {
                filePath = new Path(file);
                parentPath = filePath.removeLastSegments(1);
                while (parentPath.segmentCount() > 0) {
                    if (!this.includedFolders.add(parentPath.toOSString())) continue block2;
                    parentPath = parentPath.removeLastSegments(1);
                }
            }
        }

        protected boolean accepts(String name, boolean isFile) {
            if ((name = PathUtil.useSystemSeparator(name)).startsWith(this.baseDirAsString)) {
                name = name.substring(this.baseDirAsString.length() + 1);
            }
            boolean res = isFile ? this.includedFiles.contains(name) && !this.excludedFiles.contains(name) : this.includedFolders.contains(name) && !this.excludedFolders.contains(name);
            return res;
        }
    }
}

