/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferences;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferencesManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenWtpPreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private Composite overrideComp;
    private Button overrideButton;
    private Link fChangeWorkspaceSettings;
    private Group earPrefGroup;
    private Button genApplicationXmlButton;
    private Group warPrefGroup;
    private Button warMavenArchiverButton;

    public MavenWtpPreferencePage() {
        this.setTitle("Java EE Integration Settings");
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        main.setLayout((Layout)gl);
        IProject project = this.getProject();
        this.createOverridePrefs(main, project);
        if (project == null || JavaEEProjectUtilities.isEARProject((IProject)project)) {
            this.createEarPrefs(main);
        }
        if (project == null || JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            this.createWarPrefs(main);
        }
        IMavenWtpPreferences preferences = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getPreferences(project);
        this.fillValues(preferences);
        return main;
    }

    private void createEarPrefs(Composite main) {
        this.earPrefGroup = new Group(main, 0);
        this.earPrefGroup.setText("EAR Project preferences");
        this.earPrefGroup.setLayout((Layout)new GridLayout(1, false));
        this.earPrefGroup.setLayoutData((Object)new GridData(768));
        this.genApplicationXmlButton = new Button((Composite)this.earPrefGroup, 32);
        this.genApplicationXmlButton.setText("Generate application.xml under the build directory");
    }

    private void createOverridePrefs(Composite main, IProject project) {
        if (project != null) {
            this.overrideComp = new Composite(main, 0);
            this.overrideComp.setLayout((Layout)new FormLayout());
            this.overrideComp.setLayoutData((Object)new GridData(768));
            this.overrideButton = new Button(this.overrideComp, 32);
            this.overrideButton.setText("Enable Project Specific Settings");
            this.overrideButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    MavenWtpPreferencePage.this.setWidgetsEnabled(MavenWtpPreferencePage.this.overrideButton.getSelection());
                }
            });
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 5);
            fd.left = new FormAttachment(0, 5);
            this.overrideButton.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment((Control)this.overrideButton, 5);
            fd.right = new FormAttachment(100, -5);
            fd.right.alignment = 131072;
            Composite tmp = new Composite(this.overrideComp, 0);
            tmp.setLayoutData((Object)fd);
            tmp.setLayout((Layout)new GridLayout(1, true));
            this.fChangeWorkspaceSettings = this.createLink(tmp, "Configure Workspace Settings...");
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
    }

    private void createWarPrefs(Composite main) {
        this.warPrefGroup = new Group(main, 0);
        this.warPrefGroup.setText("WAR Project preferences");
        this.warPrefGroup.setLayout((Layout)new GridLayout(1, false));
        this.warPrefGroup.setLayoutData((Object)new GridData(768));
        this.warMavenArchiverButton = new Button((Composite)this.warPrefGroup, 32);
        this.warMavenArchiverButton.setText("Maven Archiver generates files under the build directory");
        this.warMavenArchiverButton.setToolTipText("The build directory will always be used if Web resource filtering is enabled");
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 2048);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MavenWtpPreferencePage.this.openGlobalPrefs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MavenWtpPreferencePage.this.openGlobalPrefs();
            }
        });
        return link;
    }

    private void openGlobalPrefs() {
        String id = "org.eclipse.m2e.wtp.preferences.MavenWtpPreferencePage";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)this.getElement()).open();
    }

    protected void setWidgetsEnabled(boolean isEnabled) {
        if (this.genApplicationXmlButton != null) {
            this.genApplicationXmlButton.setEnabled(isEnabled);
        }
        if (this.warMavenArchiverButton != null) {
            this.warMavenArchiverButton.setEnabled(isEnabled);
        }
    }

    private void fillValues(IMavenWtpPreferences preferences) {
        IProject project = this.getProject();
        if (project != null) {
            this.overrideButton.setSelection(preferences.isEnabledProjectSpecificSettings());
            this.setWidgetsEnabled(this.overrideButton.getSelection());
        }
        if (this.genApplicationXmlButton != null) {
            this.genApplicationXmlButton.setSelection(preferences.isApplicationXmGeneratedInBuildDirectory());
        }
        if (this.warMavenArchiverButton != null) {
            this.warMavenArchiverButton.setSelection(preferences.isWebMavenArchiverUsesBuildDirectory());
        }
    }

    public IProject getProject() {
        IAdaptable el = this.getElement();
        IProject p = el == null ? null : (IProject)el.getAdapter(IProject.class);
        return p;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IProject project = this.getProject();
        IMavenWtpPreferencesManager preferencesManager = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager();
        IMavenWtpPreferences preferences = preferencesManager.getPreferences(project);
        IMavenWtpPreferences newPreferences = preferencesManager.createNewPreferences();
        if (project != null) {
            newPreferences.setEnabledProjectSpecificSettings(this.overrideButton.getSelection());
        }
        if (this.genApplicationXmlButton != null) {
            newPreferences.setApplicationXmGeneratedInBuildDirectory(this.genApplicationXmlButton.getSelection());
        }
        if (this.warMavenArchiverButton != null) {
            newPreferences.setWebMavenArchiverUsesBuildDirectory(this.warMavenArchiverButton.getSelection());
        }
        if (!newPreferences.equals(preferences)) {
            preferencesManager.savePreferences(newPreferences, this.getProject());
            boolean res = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Maven Java EE Integration Settings", (String)"Maven Java EE Integration settings have changed. Do you want to update project configuration?");
            if (res) {
                this.updateImpactedProjects();
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IProject project = this.getProject();
        IMavenWtpPreferencesManager preferencesManager = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager();
        IMavenWtpPreferences workspacePreferences = preferencesManager.getWorkspacePreferences();
        if (project == null) {
            workspacePreferences.setApplicationXmGeneratedInBuildDirectory(true);
            workspacePreferences.setWebMavenArchiverUsesBuildDirectory(true);
        }
        this.fillValues(workspacePreferences);
        super.performDefaults();
    }

    private void updateImpactedProjects() {
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        final List<IMavenProjectFacade> facades = this.getImpactedProjects(projectManager);
        if (facades.isEmpty()) {
            return;
        }
        final IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        WorkspaceJob job = new WorkspaceJob("Updating maven projects "){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Updating Maven projects", (int)100);
                    SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(5), (int)(facades.size() * 100));
                    for (IMavenProjectFacade facade : facades) {
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProject project = facade.getProject();
                        subProgress.subTask("Updating configuration for " + project.getName());
                        configurationManager.updateProjectConfiguration(project, (IProgressMonitor)subProgress);
                    }
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(configurationManager.getRule());
        job.schedule();
    }

    private List<IMavenProjectFacade> getImpactedProjects(IMavenProjectRegistry projectManager) {
        ArrayList<IMavenProjectFacade> facades = new ArrayList<IMavenProjectFacade>();
        IProject project = this.getProject();
        if (project == null) {
            IMavenProjectFacade[] iMavenProjectFacadeArray = projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                if (this.isImpacted(facade)) {
                    facades.add(facade);
                }
                ++n2;
            }
        } else {
            facades.add(projectManager.getProject(project));
        }
        return facades;
    }

    private boolean isImpacted(IMavenProjectFacade facade) {
        switch (JEEPackaging.getValue(facade.getPackaging())) {
            case WAR: 
            case EAR: {
                return true;
            }
        }
        return false;
    }
}

