/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.scoping;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.ComplexType;
import org.eclipse.mita.base.types.EnumerationType;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.platform.scoping.AbstractPlatformDSLScopeProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

public class PlatformDSLScopeProvider
extends AbstractPlatformDSLScopeProvider {
    @Inject
    private ITypeSystemInferrer typeInferrer;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public IScope scope_ElementReferenceExpression_reference(EObject context, EReference ref) {
        ConfigurationItem configItem = (ConfigurationItem)EcoreUtil2.getContainerOfType((EObject)context, ConfigurationItem.class);
        Type _type = null;
        if (configItem != null) {
            _type = configItem.getType();
        }
        Type typ = _type;
        IScope superScope = this.getDelegate().getScope(context, ref);
        if (typ instanceof SumType) {
            return Scopes.scopeFor((Iterable)((SumType)typ).getAlternatives());
        }
        return superScope;
    }

    public IScope scope_FeatureCall_feature(FeatureCall context, EReference reference) {
        Expression owner = context.getOwner();
        EObject element = this.getElement(owner);
        if (element == null) {
            return this.getDelegate().getScope((EObject)context, reference);
        }
        IScope scope = IScope.NULLSCOPE;
        ITypeSystemInferrer.InferenceResult result = this.typeInferrer.infer((EObject)owner);
        Type _type = null;
        if (result != null) {
            _type = result.getType();
        }
        Type ownerType = _type;
        return this.addScopeForType(ownerType, scope);
    }

    protected IScope _addScopeForType(EnumerationType type, IScope scope) {
        return Scopes.scopeFor((Iterable)type.getEnumerator(), (IScope)scope);
    }

    protected IScope _addScopeForType(ComplexType type, IScope scope) {
        return Scopes.scopeFor((Iterable)type.getAllFeatures(), (IScope)scope);
    }

    protected IScope _addScopeForType(Void type, IScope scope) {
        return scope;
    }

    protected EObject _getElement(Expression it) {
        return null;
    }

    protected EObject _getElement(ElementReferenceExpression it) {
        return it.getReference();
    }

    protected EObject _getElement(FeatureCall it) {
        return it.getFeature();
    }

    public IScope addScopeForType(Type type, IScope scope) {
        if (type instanceof EnumerationType) {
            return this._addScopeForType((EnumerationType)type, scope);
        }
        if (type instanceof ComplexType) {
            return this._addScopeForType((ComplexType)type, scope);
        }
        if (type == null) {
            return this._addScopeForType((Void)null, scope);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, scope).toString());
    }

    public EObject getElement(Expression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._getElement((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._getElement((FeatureCall)it);
        }
        if (it != null) {
            return this._getElement(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

