/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.scoping;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.types.Exportable;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypedElement;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class TypeDSLResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String TYPE = "TYPE";
    public static final String EXPORTED = "EXPORTED";

    public void defineUserData(EObject eObject, Map<String, String> userData) {
        if (eObject instanceof TypedElement) {
            userData.put(TYPE, TypeDSLResourceDescriptionStrategy.getTypeSpecifierType(((TypedElement)eObject).getTypeSpecifier()));
        }
        if (eObject instanceof Exportable) {
            userData.put(EXPORTED, Boolean.toString(((Exportable)eObject).isExported()));
        } else if (eObject instanceof SumAlternative) {
            EObject _eContainer = ((SumAlternative)eObject).eContainer();
            userData.put(EXPORTED, Boolean.toString(((SumType)_eContainer).isExported()));
        } else {
            userData.put(EXPORTED, Boolean.toString(true));
        }
    }

    public static String getTypeSpecifierType(TypeSpecifier specifier) {
        List typeNode;
        int _size;
        boolean _tripleEquals;
        if (specifier instanceof TypeSpecifier) {
            boolean _not;
            boolean _isOptional = specifier.isOptional();
            if (_isOptional) {
                return "optional";
            }
            boolean _isEmpty = specifier.getReferenceModifiers().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                return "reference";
            }
        }
        boolean bl = _tripleEquals = (_size = (typeNode = NodeModelUtils.findNodesForFeature((EObject)specifier, (EStructuralFeature)TypesPackage.Literals.TYPE_SPECIFIER__TYPE)).size()) == 1;
        if (_tripleEquals) {
            return ((INode)typeNode.get(0)).getText().trim();
        }
        return "void";
    }

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        return this.createEObjectDescriptions(eObject, acceptor, this.getQualifiedNameProvider());
    }

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor, IQualifiedNameProvider nameProvider) {
        boolean _not;
        boolean _tripleEquals;
        IQualifiedNameProvider _qualifiedNameProvider = this.getQualifiedNameProvider();
        boolean bl = _tripleEquals = _qualifiedNameProvider == null;
        if (_tripleEquals) {
            return false;
        }
        boolean _shouldCreateDescription = this.shouldCreateDescription(eObject);
        boolean bl2 = _not = !_shouldCreateDescription;
        if (_not) {
            return false;
        }
        try {
            QualifiedName qualifiedName = nameProvider.getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                HashMap userData = Maps.newHashMap();
                this.defineUserData(eObject, userData);
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, (Map)userData));
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception exc = (Exception)_t;
                exc.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return true;
    }

    protected boolean shouldCreateDescription(EObject object) {
        return true;
    }
}

