/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProjectErrorShouldGenerate
implements IShouldGenerate {
    @Inject
    private IResourceValidator validator;

    public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
        block7: {
            boolean _equals;
            URI uri;
            block6: {
                try {
                    uri = resource.getURI();
                    if (uri != null && uri.isPlatformResource()) break block6;
                    return false;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            String _platformString = uri.toPlatformString(true);
            Path _path = new Path(_platformString);
            IResource member = _root.findMember((IPath)_path);
            if (member == null || member.getType() != 1) break block7;
            ProjectConfigAdapter _findInEmfObject = ProjectConfigAdapter.findInEmfObject((Notifier)resource.getResourceSet());
            IProjectConfig _projectConfig = null;
            if (_findInEmfObject != null) {
                _projectConfig = _findInEmfObject.getProjectConfig();
            }
            IProjectConfig projectConfig = _projectConfig;
            IProject project = member.getProject();
            String _name = project.getName();
            String _name_1 = null;
            if (projectConfig != null) {
                _name_1 = projectConfig.getName();
            }
            if (!(_equals = Objects.equal((Object)_name, (Object)_name_1))) break block7;
            IMarker[] allMakers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            Functions.Function1<IMarker, Boolean> _function = new Functions.Function1<IMarker, Boolean>(){

                public Boolean apply(IMarker it) {
                    try {
                        return Objects.equal((Object)it.getAttribute("severity"), (Object)2) && it.getResource().getName().toLowerCase().endsWith(".mita");
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)allMakers)), (Functions.Function1)_function);
            if (!_exists) break block7;
            return false;
        }
        return this.isValid(resource, cancelIndicator);
    }

    protected boolean isValid(Resource resource, CancelIndicator cancelIndicator) {
        Functions.Function1<Issue, Boolean> _function;
        List issues = this.validator.validate(resource, CheckMode.ALL, cancelIndicator);
        boolean _exists = IterableExtensions.exists((Iterable)issues, (Functions.Function1)(_function = new Functions.Function1<Issue, Boolean>(){

            public Boolean apply(Issue it) {
                Severity _severity = it.getSeverity();
                return Objects.equal((Object)_severity, (Object)Severity.ERROR);
            }
        }));
        return !_exists;
    }
}

