/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.linking;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.TypesFactory;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.linking.OperationsLinker;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ProgramLinkingService
extends DefaultLinkingService {
    public static final String OPTIONAL_TYPE_NAME = "optional";
    public static final String REFERENCE_TYPE_NAME = "reference";
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private OperationsLinker operationsLinker;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        if (context instanceof TypeSpecifier && ref == TypesPackage.Literals.TYPE_SPECIFIER__TYPE) {
            TypeSpecifier _context = (TypeSpecifier)context;
            if (_context.isOptional()) {
                return this.getOptionalLinkedObjects((TypeSpecifier)context, ref, node);
            }
            if (_context.getReferenceModifiers().size() > 0) {
                return this.getReferenceLinkedObjects((TypeSpecifier)context, ref, node);
            }
        }
        if (context instanceof ArgumentExpression && this.isOperationCall(context)) {
            return this.getLinkedFunctions((ArgumentExpression)context, ref, node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    protected boolean isOperationCall(EObject context) {
        if (context instanceof ElementReferenceExpression) {
            return ((ElementReferenceExpression)context).isOperationCall();
        }
        if (context instanceof FeatureCall) {
            return ((FeatureCall)context).isOperationCall();
        }
        return false;
    }

    public List<EObject> getLinkedFunctions(ArgumentExpression context, EReference ref, INode node) {
        QualifiedName qualifiedLinkName;
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(node);
        if (crossRefString == null || crossRefString.equals("")) {
            return Collections.emptyList();
        }
        IScope scope = this.getScope((EObject)context, ref);
        Iterable eObjectDescription = scope.getElements(qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString));
        int size = Iterables.size((Iterable)eObjectDescription);
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(((IEObjectDescription)Iterables.getFirst((Iterable)eObjectDescription, null)).getEObjectOrProxy());
        }
        ArrayList<IEObjectDescription> candidates = new ArrayList<IEObjectDescription>();
        for (IEObjectDescription currentDescription : eObjectDescription) {
            if (!currentDescription.getEClass().isSuperTypeOf(ProgramPackage.Literals.FUNCTION_DEFINITION) && !currentDescription.getEClass().isSuperTypeOf(ProgramPackage.Literals.GENERATED_FUNCTION_DEFINITION) && !currentDescription.getEClass().isSuperTypeOf(TypesPackage.Literals.OPERATION)) continue;
            candidates.add(currentDescription);
        }
        Optional<Operation> operation = this.operationsLinker.linkOperation(candidates, context);
        if (operation.isPresent()) {
            return Collections.singletonList((EObject)operation.get());
        }
        return Collections.emptyList();
    }

    protected List<EObject> getOptionalLinkedObjects(TypeSpecifier context, EReference ref, INode node) {
        List result = super.getLinkedObjects((EObject)context, ref, node);
        if (result.size() != 1) {
            return result;
        }
        IEObjectDescription optionalDescription = this.scopeProvider.getScope(EcoreUtil2.getContainerOfType((EObject)context, Program.class), ref).getSingleElement(QualifiedName.create((String)OPTIONAL_TYPE_NAME));
        if (optionalDescription == null) {
            return result;
        }
        EObject optionalType = optionalDescription.getEObjectOrProxy();
        TypeSpecifier specifier = TypesFactory.eINSTANCE.createTypeSpecifier();
        specifier.setType((Type)result.get(0));
        context.getTypeArguments().clear();
        context.getTypeArguments().add((Object)specifier);
        return Collections.singletonList(optionalType);
    }

    protected List<EObject> getReferenceLinkedObjects(TypeSpecifier context, EReference ref, INode node) {
        List result = super.getLinkedObjects((EObject)context, ref, node);
        if (result.size() != 1) {
            return result;
        }
        IEObjectDescription referenceDescription = this.scopeProvider.getScope(EcoreUtil2.getContainerOfType((EObject)context, Program.class), ref).getSingleElement(QualifiedName.create((String)REFERENCE_TYPE_NAME));
        if (referenceDescription == null) {
            return result;
        }
        EObject referenceType = referenceDescription.getEObjectOrProxy();
        int referenceModifierCount = 0;
        for (String modifier : context.getReferenceModifiers()) {
            referenceModifierCount += modifier.length();
        }
        TypeSpecifier innerSpecifier = TypesFactory.eINSTANCE.createTypeSpecifier();
        innerSpecifier.setType((Type)result.get(0));
        int i = 0;
        while (i < referenceModifierCount - 1) {
            TypeSpecifier outerSpecifier = TypesFactory.eINSTANCE.createTypeSpecifier();
            context.getTypeArguments().clear();
            outerSpecifier.setType((Type)referenceType);
            outerSpecifier.getTypeArguments().add((Object)innerSpecifier);
            innerSpecifier = outerSpecifier;
            ++i;
        }
        context.getTypeArguments().clear();
        context.getTypeArguments().add((Object)innerSpecifier);
        return Collections.singletonList(referenceType);
    }
}

