/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.connectivity;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class WlanGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;
    @Inject
    @Extension
    protected StatementGenerator statementGenerator;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                Boolean _boolean = WlanGenerator.this.configuration.getBoolean("isHostPgmEnabled");
                if (_boolean.booleanValue()) {
                    _builder.append((Object)"exception = WLANHostPgm_Setup();");
                    _builder.newLine();
                    CodeFragment _generateLoggingExceptionHandler = WlanGenerator.this._generatorUtils.generateLoggingExceptionHandler("WLAN host programming", "setting up");
                    _builder.append((Object)_generateLoggingExceptionHandler);
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append((Object)"NetworkConfigSemaphore = xSemaphoreCreateBinary();");
                _builder.newLine();
                _builder.append((Object)"if (NULL == NetworkConfigSemaphore)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"printf(\"Failed to create Semaphore \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"WlanEventSemaphore = xSemaphoreCreateBinary();");
                _builder.newLine();
                _builder.append((Object)"if (NULL == WlanEventSemaphore)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"vSemaphoreDelete(NetworkConfigSemaphore);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"printf(\"Failed to create Semaphore \\r\\n\");");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"return (exception);");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static SemaphoreHandle_t WlanEventSemaphore = NULL;");
                _builder.newLine();
                _builder.append((Object)"static SemaphoreHandle_t NetworkConfigSemaphore = NULL;");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("semphr.h", true);
    }

    public CodeFragment generateEnable() {
        boolean _equals_1;
        boolean _equals;
        final String baseName = this._generatorUtils.getBaseName((Object)this.setup);
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object ipConfigExpr = StaticValueInferrer.infer((EObject)this.configuration.getExpression("ipConfiguration"), (Procedures.Procedure1)_function);
        Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object auth = StaticValueInferrer.infer((EObject)this.configuration.getExpression("authentication"), (Procedures.Procedure1)_function_1);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.newLine();
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/* Initialize the Wireless Network Driver */");
                _builder.newLine();
                _builder.append((Object)"exception = WlanNetworkConnect_Init(");
                _builder.append((Object)baseName);
                _builder.append((Object)"_WlanConnectStatusCallback);");
                _builder.newLineIfNotEmpty();
                CodeFragment _generateLoggingExceptionHandler = WlanGenerator.this._generatorUtils.generateLoggingExceptionHandler("WlanNetworkConnect", "init");
                _builder.append((Object)_generateLoggingExceptionHandler);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"/* Semaphore take to flush the existing queue events without timeout. Hence no need to consider the return value */");
                _builder.newLine();
                _builder.append((Object)"(void) xSemaphoreTake(WlanEventSemaphore, 0U);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.newLine();
                if (ipConfigExpr instanceof StaticValueInferrer.SumTypeRepr) {
                    boolean _contains = ((StaticValueInferrer.SumTypeRepr)ipConfigExpr).name.contains("Dhcp");
                    if (_contains) {
                        _builder.append((Object)"/* Semaphore take to flush the existing queue events without timeout. Hence no need to consider the return value */");
                        _builder.newLine();
                        _builder.append((Object)"(void) xSemaphoreTake(NetworkConfigSemaphore, 0U);");
                        _builder.newLine();
                        _builder.append((Object)"exception = WlanNetworkConfig_SetIpDhcp(");
                        _builder.append((Object)baseName);
                        _builder.append((Object)"_NetworkIpConfigStatusCallback);");
                        _builder.newLineIfNotEmpty();
                        CodeFragment _generateLoggingExceptionHandler_1 = WlanGenerator.this._generatorUtils.generateLoggingExceptionHandler("DHCP", "setting");
                        _builder.append((Object)_generateLoggingExceptionHandler_1);
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _equals = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).name, (Object)"Static");
                        if (_equals) {
                            _builder.append((Object)"WlanNetworkConfig_IpSettings_T staticIpSettings;");
                            _builder.newLine();
                            _builder.append((Object)"staticIpSettings.isDHCP = false;");
                            _builder.newLine();
                            _builder.append((Object)"staticIpSettings.ipV4          = sl_Htonl(XDK_NETWORK_IPV4(");
                            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                                public void apply(EObject it) {
                                }
                            };
                            Object _infer = StaticValueInferrer.infer((EObject)((EObject)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).properties.get("ip")), (Procedures.Procedure1)_function);
                            String[] _split = null;
                            if ((String)_infer != null) {
                                _split = ((String)_infer).split("\\.");
                            }
                            String _join = null;
                            if ((Iterable)Conversions.doWrapArray(_split) != null) {
                                _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_split)), (CharSequence)", ");
                            }
                            _builder.append(_join);
                            _builder.append((Object)"));");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"staticIpSettings.ipV4Mask      = sl_Htonl(XDK_NETWORK_IPV4(");
                            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                                public void apply(EObject it) {
                                }
                            };
                            Object _infer_1 = StaticValueInferrer.infer((EObject)((EObject)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).properties.get("subnetMask")), (Procedures.Procedure1)_function_1);
                            String[] _split_1 = null;
                            if ((String)_infer_1 != null) {
                                _split_1 = ((String)_infer_1).split("\\.");
                            }
                            String _join_1 = null;
                            if ((Iterable)Conversions.doWrapArray(_split_1) != null) {
                                _join_1 = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_split_1)), (CharSequence)", ");
                            }
                            _builder.append(_join_1);
                            _builder.append((Object)"));");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"staticIpSettings.ipV4Gateway   = sl_Htonl(XDK_NETWORK_IPV4(");
                            Procedures.Procedure1<EObject> _function_2 = new Procedures.Procedure1<EObject>(){

                                public void apply(EObject it) {
                                }
                            };
                            Object _infer_2 = StaticValueInferrer.infer((EObject)((EObject)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).properties.get("gateway")), (Procedures.Procedure1)_function_2);
                            String[] _split_2 = null;
                            if ((String)_infer_2 != null) {
                                _split_2 = ((String)_infer_2).split("\\.");
                            }
                            String _join_2 = null;
                            if ((Iterable)Conversions.doWrapArray(_split_2) != null) {
                                _join_2 = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_split_2)), (CharSequence)", ");
                            }
                            _builder.append(_join_2);
                            _builder.append((Object)"));");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"staticIpSettings.ipV4DnsServer = sl_Htonl(XDK_NETWORK_IPV4(");
                            Procedures.Procedure1<EObject> _function_3 = new Procedures.Procedure1<EObject>(){

                                public void apply(EObject it) {
                                }
                            };
                            Object _infer_3 = StaticValueInferrer.infer((EObject)((EObject)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).properties.get("dns")), (Procedures.Procedure1)_function_3);
                            String[] _split_3 = null;
                            if ((String)_infer_3 != null) {
                                _split_3 = ((String)_infer_3).split("\\.");
                            }
                            String _join_3 = null;
                            if ((Iterable)Conversions.doWrapArray(_split_3) != null) {
                                _join_3 = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_split_3)), (CharSequence)", ");
                            }
                            _builder.append(_join_3);
                            _builder.append((Object)"));");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"exception = WlanNetworkConfig_SetIpStatic(staticIpSettings);");
                            _builder.newLine();
                            CodeFragment _generateLoggingExceptionHandler_2 = WlanGenerator.this._generatorUtils.generateLoggingExceptionHandler("static IP", "setting");
                            _builder.append((Object)_generateLoggingExceptionHandler_2);
                            _builder.newLineIfNotEmpty();
                        }
                    }
                } else {
                    _builder.append((Object)"ERROR: INVALID CONFIGURATION: ipConfiguration");
                    _builder.newLine();
                }
                _builder.newLine();
                if (auth instanceof StaticValueInferrer.SumTypeRepr) {
                    boolean _equals_1 = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)auth).name, (Object)"None");
                    if (_equals_1) {
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"NETWORK_SSID");
                            }
                        };
                        CodeFragment _generateLogStatement = WlanGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "Connecting to open network: %s", new CodeFragment[]{WlanGenerator.this.codeFragmentProvider.create(_client)});
                        _builder.append((Object)_generateLogStatement);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"exception = WlanNetworkConnect_Open((WlanNetworkConnect_SSID_T) NETWORK_SSID);");
                        _builder.newLine();
                        _builder.append((Object)"if(RETCODE_OK != exception)");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"return exception;");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    } else {
                        boolean _equals_2 = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)auth).name, (Object)"Personal");
                        if (_equals_2) {
                            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)"NETWORK_SSID");
                                }
                            };
                            CodeFragment _generateLogStatement_1 = WlanGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "Connecting to personal network: %s", new CodeFragment[]{WlanGenerator.this.codeFragmentProvider.create(_client_1)});
                            _builder.append((Object)_generateLogStatement_1);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"exception = WlanNetworkConnect_PersonalWPA((WlanNetworkConnect_SSID_T) NETWORK_SSID, (WlanNetworkConnect_PassPhrase_T) NETWORK_PSK);");
                            _builder.newLine();
                            _builder.append((Object)"if(RETCODE_OK != exception)");
                            _builder.newLine();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"return exception;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        } else {
                            boolean _equals_3 = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)auth).name, (Object)"Enterprise");
                            if (_equals_3) {
                                Boolean _boolean = WlanGenerator.this.configuration.getBoolean("isHostPgmEnabled");
                                if (_boolean.booleanValue()) {
                                    StringConcatenationClient _client_2 = new StringConcatenationClient(){

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)"NETWORK_SSID");
                                        }
                                    };
                                    CodeFragment _generateLogStatement_2 = WlanGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "Connecting to enterprise network with host programming: %s", new CodeFragment[]{WlanGenerator.this.codeFragmentProvider.create(_client_2)});
                                    _builder.append((Object)_generateLogStatement_2);
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"exception = WLANHostPgm_Enable();");
                                    _builder.newLine();
                                    CodeFragment _generateLoggingExceptionHandler_3 = WlanGenerator.this._generatorUtils.generateLoggingExceptionHandler("WLAN host programming", "enable");
                                    _builder.append((Object)_generateLoggingExceptionHandler_3);
                                    _builder.newLineIfNotEmpty();
                                } else {
                                    StringConcatenationClient _client_3 = new StringConcatenationClient(){

                                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                            _builder.append((Object)"NETWORK_SSID");
                                        }
                                    };
                                    CodeFragment _generateLogStatement_3 = WlanGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "Connecting to enterprise network without host programming: %s", new CodeFragment[]{WlanGenerator.this.codeFragmentProvider.create(_client_3)});
                                    _builder.append((Object)_generateLogStatement_3);
                                    _builder.newLineIfNotEmpty();
                                }
                                _builder.append((Object)"/* disable server authentication */");
                                _builder.newLine();
                                _builder.append((Object)"unsigned char pValues;");
                                _builder.newLine();
                                _builder.append((Object)"pValues = 0; //0 - Disable the server authentication | 1 - Enable (this is the default)");
                                _builder.newLine();
                                _builder.append((Object)"if (0U != sl_WlanSet(SL_WLAN_CFG_GENERAL_PARAM_ID, 19, 1, &pValues))");
                                _builder.newLine();
                                _builder.append((Object)"{");
                                _builder.newLine();
                                _builder.append((Object)"\t");
                                _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_WLAN_SL_SET_FAILED);");
                                _builder.newLine();
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.newLine();
                                _builder.append((Object)"exception = WlanNetworkConnect_EnterpriseWPA((WlanNetworkConnect_SSID_T) NETWORK_SSID, (WlanNetworkConnect_Username_T) NETWORK_USERNAME, (WlanNetworkConnect_PassPhrase_T) NETWORK_PASSWORD);");
                                _builder.newLine();
                                _builder.append((Object)"if(RETCODE_OK != exception)");
                                _builder.newLine();
                                _builder.append((Object)"{");
                                _builder.newLine();
                                _builder.append((Object)"\t");
                                _builder.append((Object)"return exception;");
                                _builder.newLine();
                                _builder.append((Object)"}");
                                _builder.newLine();
                                _builder.append((Object)"else");
                                _builder.newLine();
                                _builder.append((Object)"{");
                                _builder.newLine();
                                _builder.append((Object)"\t");
                                _builder.append((Object)"vTaskDelay(pdMS_TO_TICKS(1000));");
                                _builder.newLine();
                                _builder.append((Object)"}");
                                _builder.newLine();
                            }
                        }
                    }
                } else {
                    _builder.append((Object)"ERROR: INVALID CONFIGURATION: authentication");
                    _builder.newLine();
                }
                _builder.newLine();
                if (ipConfigExpr instanceof StaticValueInferrer.SumTypeRepr) {
                    boolean _contains_1 = ((StaticValueInferrer.SumTypeRepr)ipConfigExpr).name.contains("Dhcp");
                    if (_contains_1) {
                        _builder.append((Object)"if (pdTRUE == xSemaphoreTake(NetworkConfigSemaphore, 200000))");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"exception = WlanEventSemaphoreHandle();");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"else");
                        _builder.newLine();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                    } else {
                        boolean _equals_4 = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).name, (Object)"Static");
                        if (_equals_4) {
                            _builder.append((Object)"exception = WlanEventSemaphoreHandle();");
                            _builder.newLine();
                        }
                    }
                }
                _builder.newLine();
                _builder.append((Object)"WlanNetworkConfig_IpSettings_T currentIpSettings;");
                _builder.newLine();
                _builder.append((Object)"exception = WlanNetworkConfig_GetIpSettings(&currentIpSettings);");
                _builder.newLine();
                _builder.append((Object)"if(RETCODE_OK != exception)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"uint32_t ipAddress = Basics_htonl(currentIpSettings.ipV4);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"char humanReadableIpAddress[SERVAL_IP_ADDR_LEN] = { 0 };");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"int conversionStatus = Ip_convertAddrToString(&ipAddress, humanReadableIpAddress);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (conversionStatus < 0)");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement_4 = WlanGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Warning, "Couldn't convert the IP address to string format", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement_4, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                StringConcatenationClient _client_4 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"humanReadableIpAddress");
                    }
                };
                CodeFragment _generateLogStatement_5 = WlanGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Info, "Connected to WLAN. IP address of this device is: %s", new CodeFragment[]{WlanGenerator.this.codeFragmentProvider.create(_client_4)});
                _builder.append((Object)_generateLogStatement_5, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"return RETCODE_OK;");
                _builder.newLine();
            }
        };
        CodeFragment _create = this.codeFragmentProvider.create(_client);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"#define NETWORK_SSID  \"");
                String _string = WlanGenerator.this.configuration.getString("ssid");
                _builder.append((Object)_string);
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                if (auth instanceof StaticValueInferrer.SumTypeRepr) {
                    boolean _equals = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)auth).name, (Object)"Personal");
                    if (_equals) {
                        _builder.append((Object)"#define NETWORK_PSK  ");
                        IGeneratorNode _code = WlanGenerator.this.statementGenerator.code((EObject)((StaticValueInferrer.SumTypeRepr)auth).properties.get("psk"));
                        _builder.append((Object)_code);
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _equals_1 = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)auth).name, (Object)"Enterprise");
                        if (_equals_1) {
                            _builder.append((Object)"#define NETWORK_USERNAME ");
                            IGeneratorNode _code_1 = WlanGenerator.this.statementGenerator.code((EObject)((StaticValueInferrer.SumTypeRepr)auth).properties.get("username"));
                            _builder.append((Object)_code_1);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"#define NETWORK_PASSWORD ");
                            IGeneratorNode _code_2 = WlanGenerator.this.statementGenerator.code((EObject)((StaticValueInferrer.SumTypeRepr)auth).properties.get("password"));
                            _builder.append((Object)_code_2);
                            _builder.newLineIfNotEmpty();
                        }
                    }
                } else {
                    _builder.append((Object)"ERROR: INVALID CONFIGURATION: authentication");
                    _builder.newLine();
                }
                _builder.newLine();
                CodeFragment _buildStatusCallbacks = WlanGenerator.this.buildStatusCallbacks(WlanGenerator.this.setup);
                _builder.append((Object)_buildStatusCallbacks);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"static Retcode_T WlanEventSemaphoreHandle(void)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"Retcode_T exception = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"uint8_t count = 0;");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"if (pdTRUE == xSemaphoreTake(WlanEventSemaphore, 200000))");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"do");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"if ((WLANNETWORKCONFIG_IPV4_ACQUIRED == WlanNetworkConfig_GetIpStatus()) && (WLANNETWORK_CONNECTED == WlanNetworkConnect_GetStatus()))");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"                ");
                _builder.append((Object)"exception = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"                ");
                _builder.append((Object)"vTaskDelay(500);");
                _builder.newLine();
                _builder.append((Object)"                ");
                _builder.append((Object)"count++;");
                _builder.newLine();
                _builder.append((Object)"                ");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_WLAN_CONNECT_FAILED);");
                _builder.newLine();
                _builder.append((Object)"            ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"} while ((RETCODE_OK != exception)");
                _builder.newLine();
                _builder.append((Object)"                ");
                _builder.append((Object)"&& (UINT8_C(5) >= count));");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"        ");
                _builder.append((Object)"exception = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_SEMAPHORE_ERROR);");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"return exception;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        CodeFragment result = _create.setPreamble(_client_1).addHeader("XdkCommonInfo.h", true, 750).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Wlan.h", true, 750).addHeader("BCDS_WlanNetworkConfig.h", true, 750).addHeader("Serval_Network.h", true, 750).addHeader("Serval_Ip.h", true, 750).addHeader("wlan.h", true, 750);
        if (auth instanceof StaticValueInferrer.SumTypeRepr && (_equals = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)auth).name, (Object)"Enterprise"))) {
            result.addHeader("WLANHostPgm.h", true, 750);
        }
        if (ipConfigExpr instanceof StaticValueInferrer.SumTypeRepr && (_equals_1 = Objects.equal((Object)((StaticValueInferrer.SumTypeRepr)ipConfigExpr).name, (Object)"Static"))) {
            result.addHeader("XDK_Utils.h", true);
        }
        return result;
    }

    private CodeFragment buildStatusCallbacks(SystemResourceSetup component) {
        CodeFragment _xblockexpression = null;
        final String baseName = this._generatorUtils.getBaseName((Object)component);
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static void ");
                _builder.append((Object)baseName);
                _builder.append((Object)"_WlanConnectStatusCallback(WlanNetworkConnect_Status_T connectStatus)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BCDS_UNUSED(connectStatus);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"(void) xSemaphoreGive(WlanEventSemaphore);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"static void ");
                _builder.append((Object)baseName);
                _builder.append((Object)"_NetworkIpConfigStatusCallback(WlanNetworkConfig_IpStatus_T ipStatus)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"BCDS_UNUSED(ipStatus);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"(void) xSemaphoreGive(NetworkConfigSemaphore);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client);
        return _xblockexpression;
    }
}

