/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.stdlib;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentOperator;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.Literal;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.types.NamedElement;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.ArrayLiteral;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.generator.AbstractFunctionGenerator;
import org.eclipse.mita.program.generator.AbstractTypeGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.StatementGenerator;
import org.eclipse.mita.program.generator.TypeGenerator;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ArrayGenerator
extends AbstractTypeGenerator {
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    @Extension
    protected GeneratorUtils generatorUtils;
    @Inject
    protected ElementSizeInferrer sizeInferrer;
    @Inject
    @Extension
    protected StatementGenerator statementGenerator;
    @Inject
    protected TypeGenerator typeGenerator;

    private static Integer getArraySize(VariableDeclaration stmt, ElementSizeInferrer sizeInferrer) {
        ElementSizeInferenceResult inference = sizeInferrer.infer((EObject)stmt);
        int _xifexpression = 0;
        if (!(inference instanceof ValidElementSizeInferenceResult)) {
            return -1;
        }
        _xifexpression = ((ValidElementSizeInferenceResult)inference).getElementCount();
        return _xifexpression;
    }

    private static Integer getArraySize(NewInstanceExpression stmt, ElementSizeInferrer sizeInferrer) {
        ElementSizeInferenceResult inference = sizeInferrer.infer((EObject)stmt);
        int _xifexpression = 0;
        if (!(inference instanceof ValidElementSizeInferenceResult)) {
            return -1;
        }
        _xifexpression = ((ValidElementSizeInferenceResult)inference).getElementCount();
        return _xifexpression;
    }

    public CodeFragment generateHeader(final TypeSpecifier type) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"typedef struct {");
                _builder.newLine();
                _builder.append((Object)"\t");
                CodeFragment _code = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                _builder.append((Object)_code, "\t");
                _builder.append((Object)"* data;");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"uint32_t length;");
                _builder.newLine();
                _builder.append((Object)"} ");
                CodeFragment _code_1 = ArrayGenerator.this.typeGenerator.code(type);
                _builder.append((Object)_code_1);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("MitaGeneratedTypes.h", false);
    }

    protected boolean getIsOperationCall(EObject object) {
        if (object instanceof ElementReferenceExpression) {
            return ((ElementReferenceExpression)object).isOperationCall() && ((ElementReferenceExpression)object).getReference() instanceof Operation;
        }
        return false;
    }

    public CodeFragment generateVariableDeclaration(final TypeSpecifier type, final VariableDeclaration stmt) {
        final Integer size = ArrayGenerator.getArraySize(stmt, this.sizeInferrer);
        final boolean topLevel = EcoreUtil2.getContainerOfType((EObject)stmt, FunctionDefinition.class) == null && EcoreUtil2.getContainerOfType((EObject)stmt, EventHandlerDeclaration.class) == null;
        final int occurrence = this.generatorUtils.getOccurrence((EObject)stmt);
        final boolean initWithValueLiteral = stmt.getInitialization() != null && stmt.getInitialization() instanceof PrimitiveValueExpression && ((PrimitiveValueExpression)stmt.getInitialization()).getValue() instanceof ArrayLiteral;
        boolean operationCallInit = !topLevel && stmt.getInitialization() != null && this.getIsOperationCall((EObject)stmt.getInitialization());
        final boolean otherInit = stmt.getInitialization() != null && !initWithValueLiteral && !operationCallInit;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (size > 0) {
                    _builder.append((Object)"// buffer for ");
                    String _name = stmt.getName();
                    _builder.append((Object)_name);
                    _builder.newLineIfNotEmpty();
                    CodeFragment _code = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                    _builder.append((Object)_code);
                    _builder.append((Object)" data_");
                    String _name_1 = stmt.getName();
                    _builder.append((Object)_name_1);
                    _builder.append((Object)"_");
                    _builder.append((Object)occurrence);
                    _builder.append((Object)"[");
                    _builder.append((Object)size);
                    _builder.append((Object)"]");
                    if (initWithValueLiteral) {
                        _builder.append((Object)" = ");
                        IGeneratorNode _code_1 = ArrayGenerator.this.statementGenerator.code((EObject)stmt.getInitialization());
                        _builder.append((Object)_code_1);
                    }
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"// WARNING: Couldn't infer size!");
                    _builder.newLine();
                }
                _builder.append((Object)"// var ");
                String _name_2 = stmt.getName();
                _builder.append((Object)_name_2);
                _builder.append((Object)": array<");
                CodeFragment _code_2 = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                _builder.append((Object)_code_2);
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                CodeFragment _code_3 = ArrayGenerator.this.typeGenerator.code(type);
                _builder.append((Object)_code_3);
                _builder.append((Object)" ");
                String _name_3 = stmt.getName();
                _builder.append((Object)_name_3);
                if (topLevel || stmt.getInitialization() != null) {
                    _builder.append((Object)" = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".data = data_");
                    String _name_4 = stmt.getName();
                    _builder.append((Object)_name_4, "\t");
                    _builder.append((Object)"_");
                    _builder.append((Object)occurrence, "\t");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".length = ");
                    _builder.append((Object)size, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                }
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                if (!topLevel && otherInit) {
                    CodeFragment _generateExpression = ArrayGenerator.this.generateExpression(type, (EObject)stmt, AssignmentOperator.ASSIGN, (EObject)stmt.getInitialization());
                    _builder.append((Object)_generateExpression);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        CodeFragment cf = this.codeFragmentProvider.create(_client).addHeader("MitaGeneratedTypes.h", false);
        return cf;
    }

    public CodeFragment generateTypeSpecifier(final TypeSpecifier type, EObject context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"array_");
                CodeFragment _code = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                _builder.append((Object)_code);
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("MitaGeneratedTypes.h", false);
    }

    public CodeFragment generateNewInstance(final TypeSpecifier type, NewInstanceExpression expr) {
        CodeFragment _xblockexpression = null;
        if (EcoreUtil2.getContainerOfType((EObject)expr, FunctionDefinition.class) == null && EcoreUtil2.getContainerOfType((EObject)expr, EventHandlerDeclaration.class) == null) {
            return CodeFragment.EMPTY;
        }
        final Integer size = ArrayGenerator.getArraySize(expr, this.sizeInferrer);
        EObject parent = expr.eContainer();
        final int occurrence = this.generatorUtils.getOccurrence(parent);
        final String varName = this.generatorUtils.getBaseName((Object)parent);
        VariableDeclaration _containerOfType = (VariableDeclaration)EcoreUtil2.getContainerOfType((EObject)expr, VariableDeclaration.class);
        final boolean generateBuffer = _containerOfType == null;
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (generateBuffer) {
                    CodeFragment _code = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                    _builder.append((Object)_code);
                    _builder.append((Object)" data_");
                    _builder.append((Object)varName);
                    _builder.append((Object)"_");
                    _builder.append((Object)occurrence);
                    _builder.append((Object)"[");
                    _builder.append((Object)size);
                    _builder.append((Object)"];");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"// ");
                _builder.append((Object)varName);
                _builder.append((Object)" = new array<");
                CodeFragment _code_1 = ArrayGenerator.this.typeGenerator.code(type);
                _builder.append((Object)_code_1);
                _builder.append((Object)">(size = ");
                _builder.append((Object)size);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)varName);
                _builder.append((Object)" = (");
                CodeFragment _code_2 = ArrayGenerator.this.typeGenerator.code(type);
                _builder.append((Object)_code_2);
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".data = data_");
                _builder.append((Object)varName, "\t");
                _builder.append((Object)"_");
                _builder.append((Object)occurrence, "\t");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".length = ");
                _builder.append((Object)size, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"};");
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client).addHeader("MitaGeneratedTypes.h", false);
        return _xblockexpression;
    }

    public CodeFragment generateExpression(final TypeSpecifier type, final EObject left, AssignmentOperator operator, EObject right) {
        boolean staticSize;
        CodeFragment _xblockexpression = null;
        if (right == null) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        final boolean isReturnStmt = left instanceof ReturnStatement;
        CodeFragment _xifexpression = null;
        if (left instanceof VariableDeclaration) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ((VariableDeclaration)left).getName();
                    _builder.append((Object)_name);
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        } else {
            CodeFragment _xifexpression_1 = null;
            if (isReturnStmt) {
                StringConcatenationClient _client_2 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"(*_result)");
                    }
                };
                _xifexpression_1 = this.codeFragmentProvider.create(_client_2);
            } else {
                StringConcatenationClient _client_3 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        IGeneratorNode _noTerminator = ArrayGenerator.this.generatorUtils.noTerminator(ArrayGenerator.this.statementGenerator.code(left));
                        _builder.append((Object)_noTerminator);
                    }
                };
                _xifexpression_1 = this.codeFragmentProvider.create(_client_3);
            }
            _xifexpression = _xifexpression_1;
        }
        final CodeFragment varNameLeft = _xifexpression;
        Expression _xifexpression_2 = null;
        if (right instanceof ArrayAccessExpression) {
            _xifexpression_2 = ((ArrayAccessExpression)right).getOwner();
        } else {
            Object _xifexpression_3 = null;
            _xifexpression_3 = isReturnStmt ? ((ReturnStatement)left).getValue() : right;
            _xifexpression_2 = _xifexpression_3;
        }
        Expression rightRef = _xifexpression_2;
        StringConcatenationClient _client_4 = new StringConcatenationClient((EObject)rightRef){
            private final /* synthetic */ EObject val$rightRef;
            {
                this.val$rightRef = eObject;
            }

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                IGeneratorNode _noTerminator = ArrayGenerator.this.generatorUtils.noTerminator(ArrayGenerator.this.statementGenerator.code(this.val$rightRef));
                _builder.append((Object)_noTerminator);
            }
        };
        final CodeFragment codeRightExpr = this.codeFragmentProvider.create(_client_4);
        final boolean rightExprIsValueLit = right instanceof PrimitiveValueExpression;
        ArrayLiteral _xifexpression_4 = null;
        if (right instanceof PrimitiveValueExpression) {
            Literal _value = ((PrimitiveValueExpression)right).getValue();
            _xifexpression_4 = (ArrayLiteral)_value;
        } else {
            _xifexpression_4 = null;
        }
        final ArrayLiteral rightValueLit = _xifexpression_4;
        ValueRange _xifexpression_5 = null;
        if (right instanceof ArrayAccessExpression) {
            ValueRange _xifexpression_6 = null;
            Expression _arraySelector = ((ArrayAccessExpression)right).getArraySelector();
            if (_arraySelector instanceof ValueRange) {
                Expression _arraySelector_1 = ((ArrayAccessExpression)right).getArraySelector();
                _xifexpression_6 = (ValueRange)_arraySelector_1;
            }
            _xifexpression_5 = _xifexpression_6;
        }
        final ValueRange valRange = _xifexpression_5;
        StringConcatenationClient _client_5 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)varNameLeft);
                _builder.append((Object)".length");
            }
        };
        final CodeFragment lengthLeft = this.codeFragmentProvider.create(_client_5);
        StringConcatenationClient _client_6 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (rightExprIsValueLit) {
                    int _length = ((Object[])Conversions.unwrapArray((Object)rightValueLit.getValues(), Object.class)).length;
                    _builder.append((Object)_length);
                } else {
                    _builder.append((Object)codeRightExpr);
                    _builder.append((Object)".length");
                }
            }
        };
        final CodeFragment lengthRight = this.codeFragmentProvider.create(_client_6);
        final TypeSpecifier valueType = (TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments());
        StringConcatenationClient _client_7 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)varNameLeft);
                _builder.append((Object)".data");
            }
        };
        final CodeFragment dataLeft = this.codeFragmentProvider.create(_client_7);
        StringConcatenationClient _client_8 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)codeRightExpr);
                _builder.append((Object)".data");
                if (valRange != null) {
                    boolean _tripleNotEquals;
                    Expression _lowerBound = valRange.getLowerBound();
                    boolean bl = _tripleNotEquals = _lowerBound != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)" + ");
                        IGeneratorNode _noTerminator = ArrayGenerator.this.generatorUtils.noTerminator(ArrayGenerator.this.statementGenerator.code((EObject)valRange.getLowerBound()));
                        _builder.append((Object)_noTerminator);
                        _builder.append((Object)" * sizeof(");
                        IGeneratorNode _noTerminator_1 = ArrayGenerator.this.generatorUtils.noTerminator((IGeneratorNode)ArrayGenerator.this.typeGenerator.code(valueType));
                        _builder.append((Object)_noTerminator_1);
                        _builder.append((Object)")");
                    }
                }
            }
        };
        final CodeFragment dataRight = this.codeFragmentProvider.create(_client_8);
        ElementSizeInferenceResult sizeResLeft = this.sizeInferrer.infer(left);
        ElementSizeInferenceResult sizeResRight = this.sizeInferrer.infer(right);
        int newElementCount = -1;
        int oldElementCount = -1;
        boolean bl = staticSize = sizeResLeft.isValid() && sizeResRight.isValid();
        if (staticSize) {
            oldElementCount = ((ValidElementSizeInferenceResult)sizeResLeft).getElementCount();
            newElementCount = ((ValidElementSizeInferenceResult)sizeResRight).getElementCount();
        }
        final boolean modifyLength = !staticSize || newElementCount != oldElementCount || isReturnStmt;
        String _xifexpression_7 = null;
        if (!staticSize) {
            _xifexpression_7 = "Could not infer size of one of the operands";
        } else {
            String _xifexpression_8 = null;
            _xifexpression_8 = newElementCount != oldElementCount ? "Array sizes are different" : "For safety we assign length of return variable";
            _xifexpression_7 = _xifexpression_8;
        }
        final String modifyLengthReason = _xifexpression_7;
        abstract class __ArrayGenerator_1 {
            boolean field;

            __ArrayGenerator_1() {
            }
        }
        final __ArrayGenerator_1 staticAccessors = new __ArrayGenerator_1(this){
            {
                this.field = true;
            }
        };
        if (valRange != null) {
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){
                {
                }

                public void apply(EObject x) {
                    if (x != null) {
                        staticAccessors.field = false;
                    }
                }
            };
            StaticValueInferrer.infer((EObject)valRange.getLowerBound(), (Procedures.Procedure1)_function);
            Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){
                {
                }

                public void apply(EObject x) {
                    if (x != null) {
                        staticAccessors.field = false;
                    }
                }
            };
            StaticValueInferrer.infer((EObject)valRange.getUpperBound(), (Procedures.Procedure1)_function_1);
        }
        final boolean createNewBuffer = rightExprIsValueLit || !staticSize || oldElementCount < newElementCount;
        String _xifexpression_9 = null;
        if (rightExprIsValueLit) {
            _xifexpression_9 = "Need to store the array literal";
        } else {
            String _xifexpression_10 = null;
            if (!staticSize) {
                _xifexpression_10 = "Could not infer size of one of the operands or one of the operands is uninitialized";
            } else {
                String _xifexpression_11 = null;
                if (oldElementCount < newElementCount) {
                    _xifexpression_11 = "Left array is too small";
                }
                _xifexpression_10 = _xifexpression_11;
            }
            _xifexpression_9 = _xifexpression_10;
        }
        final String createNewBufferReason = _xifexpression_9;
        StringConcatenationClient _client_9 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"dataRealloc_");
                String _uniqueIdentifier = ArrayGenerator.this.generatorUtils.getUniqueIdentifier(left);
                _builder.append((Object)_uniqueIdentifier);
            }
        };
        final CodeFragment reallocBufferName = this.codeFragmentProvider.create(_client_9);
        StringConcatenationClient _client_10 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)lengthLeft);
                _builder.append((Object)" = ");
                _builder.append((Object)lengthRight);
                if (valRange != null) {
                    Expression _upperBound;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    Expression _lowerBound = valRange.getLowerBound();
                    boolean bl = _tripleNotEquals = _lowerBound != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)" - ");
                        IGeneratorNode _noTerminator = ArrayGenerator.this.generatorUtils.noTerminator(ArrayGenerator.this.statementGenerator.code((EObject)valRange.getLowerBound()));
                        _builder.append((Object)_noTerminator);
                    }
                    boolean bl2 = _tripleNotEquals_1 = (_upperBound = valRange.getUpperBound()) != null;
                    if (_tripleNotEquals_1) {
                        _builder.append((Object)" - (");
                        _builder.append((Object)lengthRight);
                        _builder.append((Object)" - ");
                        IGeneratorNode _noTerminator_1 = ArrayGenerator.this.generatorUtils.noTerminator(ArrayGenerator.this.statementGenerator.code((EObject)valRange.getUpperBound()));
                        _builder.append((Object)_noTerminator_1);
                        _builder.append((Object)")");
                    }
                }
            }
        };
        final CodeFragment lengthModifyStmt = this.codeFragmentProvider.create(_client_10);
        StringConcatenationClient _client_11 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                if (rightExprIsValueLit) {
                    int _length = ((Object[])Conversions.unwrapArray((Object)rightValueLit.getValues(), Object.class)).length;
                    _builder.append((Object)_length);
                } else {
                    _builder.append((Object)varNameLeft);
                    _builder.append((Object)".length");
                }
            }
        };
        final CodeFragment newLengthExpr = this.codeFragmentProvider.create(_client_11);
        StringConcatenationClient _client_12 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _code = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                _builder.append((Object)_code);
                _builder.append((Object)" ");
                _builder.append((Object)reallocBufferName);
                _builder.append((Object)"[");
                _builder.append((Object)newLengthExpr);
                _builder.append((Object)"]");
                if (rightExprIsValueLit) {
                    _builder.append((Object)" = ");
                    _builder.append((Object)codeRightExpr);
                }
            }
        };
        final CodeFragment newBufferStmt = this.codeFragmentProvider.create(_client_12);
        CodeFragment _xifexpression_12 = null;
        if (isReturnStmt) {
            StringConcatenationClient _client_13 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"// We need enough space in our target array");
                    _builder.newLine();
                    _builder.append((Object)"if(");
                    _builder.append((Object)lengthRight);
                    _builder.append((Object)" < ");
                    _builder.append((Object)lengthLeft);
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    CharSequence _generateExceptionHandler = ArrayGenerator.this.generatorUtils.generateExceptionHandler(left, "EXCEPTION_INVALIDRANGEEXCEPTION");
                    _builder.append((Object)_generateExceptionHandler, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            _xifexpression_12 = this.codeFragmentProvider.create(_client_13);
        } else {
            _xifexpression_12 = CodeFragment.EMPTY;
        }
        final CodeFragment returnStatementLengthCheck = _xifexpression_12;
        StringConcatenationClient _client_14 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"sizeof(");
                CodeFragment _code = ArrayGenerator.this.typeGenerator.code((TypeSpecifier)IterableExtensions.head((Iterable)type.getTypeArguments()));
                _builder.append((Object)_code);
                _builder.append((Object)")");
            }
        };
        final CodeFragment typeSize = this.codeFragmentProvider.create(_client_14);
        StringConcatenationClient _client_15 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)returnStatementLengthCheck);
                _builder.newLineIfNotEmpty();
                if (modifyLength) {
                    _builder.append((Object)"// Need to modify length: ");
                    _builder.append((Object)modifyLengthReason);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)lengthModifyStmt);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                if (createNewBuffer) {
                    _builder.append((Object)"// Need to create new buffer: ");
                    _builder.append((Object)createNewBufferReason);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)newBufferStmt);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    if (!isReturnStmt) {
                        _builder.append((Object)dataLeft);
                        _builder.append((Object)" = ");
                        _builder.append((Object)reallocBufferName);
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
                if (!rightExprIsValueLit) {
                    _builder.append((Object)"// ");
                    _builder.append((Object)varNameLeft);
                    _builder.append((Object)" = ");
                    _builder.append((Object)codeRightExpr);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"memcpy(");
                    _builder.append((Object)dataLeft);
                    _builder.append((Object)", ");
                    _builder.append((Object)dataRight);
                    _builder.append((Object)", ");
                    _builder.append((Object)typeSize);
                    _builder.append((Object)" * ");
                    _builder.append((Object)newLengthExpr);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                } else if (isReturnStmt && createNewBuffer) {
                    _builder.append((Object)"memcpy(");
                    _builder.append((Object)dataLeft);
                    _builder.append((Object)", ");
                    _builder.append((Object)reallocBufferName);
                    _builder.append((Object)", ");
                    _builder.append((Object)typeSize);
                    _builder.append((Object)" * ");
                    _builder.append((Object)newLengthExpr);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client_15).addHeader("MitaGeneratedTypes.h", false);
        return _xblockexpression;
    }

    public static class LengthGenerator
    extends AbstractFunctionGenerator {
        @Inject
        protected CodeFragmentProvider codeFragmentProvider;
        @Inject
        protected ElementSizeInferrer sizeInferrer;

        public CodeFragment generate(ElementReferenceExpression ref, final IGeneratorNode resultVariableName) {
            EObject _reference = ref.getReference();
            Expression variable = ModelUtils.getArgumentValue((Operation)((Operation)_reference), (ArgumentExpression)ref, (String)"self");
            String _xifexpression = null;
            if (variable instanceof ElementReferenceExpression) {
                String _xblockexpression = null;
                EObject varref = ((ElementReferenceExpression)variable).getReference();
                String _xifexpression_1 = null;
                if (varref instanceof NamedElement) {
                    _xifexpression_1 = ((NamedElement)varref).getName();
                }
                _xifexpression = _xblockexpression = _xifexpression_1;
            }
            final String varref = _xifexpression;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    if (resultVariableName != null) {
                        _builder.append((Object)resultVariableName);
                        _builder.append((Object)" = ");
                    }
                    _builder.append((Object)varref);
                    _builder.append((Object)".length");
                }
            };
            return this.codeFragmentProvider.create(_client).addHeader("MitaGeneratedTypes.h", false);
        }

        public boolean callShouldBeUnraveled(ElementReferenceExpression expression) {
            return false;
        }
    }
}

