/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.ocl.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.engine.AtlCompiler;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMEmitter;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.ocl.core.ATLVMTools;
import org.eclipse.m2m.atl.ocl.core.DummyFile;

public abstract class OclEvaluator {
    private static long id = 0L;
    private static Map dumpedASMs = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.m2m.atl.ocl.core.OclEvaluator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ATLVMTools.addVMOperation(ASMEmitter.myType, ATLVMTools.toVMOperation(clazz, "dumpASM"));
        }
        catch (Exception exception) {}
    }

    protected ASM compile(String atl) throws Exception {
        ASM ret = null;
        AtlCompiler ac = AtlCompiler.getDefault();
        String key = "ID=" + id++;
        ByteArrayInputStream input = new ByteArrayInputStream(atl.getBytes());
        EObject[] pbs = ac.compile((InputStream)input, (IFile)new DummyFile(key));
        input.close();
        int i = 0;
        while (i < pbs.length) {
            String sev = OclEvaluator.get(pbs[i], "severity").toString();
            System.out.println(String.valueOf(sev) + ":" + OclEvaluator.get(pbs[i], "location") + ":" + OclEvaluator.get(pbs[i], "description"));
            ++i;
        }
        ret = (ASM)dumpedASMs.get(key);
        return ret;
    }

    private static Object get(EObject o, String f) {
        EStructuralFeature sf = o.eClass().getEStructuralFeature(f);
        return o.eGet(sf);
    }

    public static void dumpASM(StackFrame frame, ASMEmitter self, ASMString fileName) {
        self.finishOperation();
        String key = ((ASMString)((ASMExecEnv)frame.getExecEnv()).getASMModule().get(frame, "fileName")).getSymbol();
        if (key.startsWith("ID=")) {
            dumpedASMs.put(key, self.getASM());
        } else {
            self.dumpASM(fileName.getSymbol());
        }
    }
}

