/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Feature;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.OutputRuleElement;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleElement;
import org.eclipse.m2m.atl.emftvm.RuleMode;
import org.eclipse.m2m.atl.emftvm.constraints.StackUnderflowValidator;
import org.eclipse.m2m.atl.emftvm.constraints.ValidCodeBlockStackLevelValidator;
import org.eclipse.m2m.atl.emftvm.constraints.Validator;
import org.eclipse.m2m.atl.emftvm.jit.CodeBlockJIT;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLink;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.util.DuplicateEntryException;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.FieldContainer;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.NativeCodeBlock;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.OCLOperations;
import org.eclipse.m2m.atl.emftvm.util.ResourceIterable;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.TimingData;
import org.eclipse.m2m.atl.emftvm.util.TypeHashMap;
import org.eclipse.m2m.atl.emftvm.util.TypeMap;
import org.eclipse.m2m.atl.emftvm.util.Types;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.emftvm.util.VMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecEnvImpl
extends EObjectImpl
implements ExecEnv {
    protected Map<String, Metamodel> metaModels;
    protected Map<String, Model> inputModels;
    protected Map<String, Model> inoutModels;
    protected Map<String, Model> outputModels;
    protected Map<String, Module> modules;
    protected TraceLinkSet matches;
    protected TraceLinkSet traces;
    protected Map<TraceLink, Object> uniqueResults;
    protected static final boolean JIT_DISABLED_EDEFAULT = false;
    protected boolean jitDisabled = false;
    protected static final RuleMode CURRENT_PHASE_EDEFAULT = RuleMode.MANUAL;
    protected RuleMode currentPhase = CURRENT_PHASE_EDEFAULT;
    protected final Map<String, Metamodel> internalMetaModels = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Model> internalInputModels = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Model> internalInoutModels = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Model> internalOutputModels = Collections.synchronizedMap(new HashMap());
    protected final Map<String, Module> internalModules = Collections.synchronizedMap(new LinkedHashMap());
    protected final Set<String> loadedModules = new HashSet<String>();
    protected final EList<Operation> mainChain = new BasicEList();
    protected final FieldContainer fieldContainer = new FieldContainer();
    protected final Map<String, Map<Integer, TypeMap<Object, Object>>> operations = new HashMap<String, Map<Integer, TypeMap<Object, Object>>>();
    protected final Map<String, Map<Integer, TypeMap<Object, Object>>> staticOperations = new HashMap<String, Map<Integer, TypeMap<Object, Object>>>();
    protected final Map<String, Rule> rules = new LinkedHashMap<String, Rule>();
    protected final Map<Resource, Model> modelOf = new HashMap<Resource, Model>();
    protected final Map<Resource, Model> inputModelOf = new HashMap<Resource, Model>();
    protected final Map<Resource, Model> inoutModelOf = new HashMap<Resource, Model>();
    protected final Map<Resource, Model> outputModelOf = new HashMap<Resource, Model>();
    protected final Map<Resource, Metamodel> metaModelOf = new HashMap<Resource, Metamodel>();
    protected final Map<Model, String> modelId = new HashMap<Model, String>();
    protected final Map<Metamodel, String> metaModelId = new HashMap<Metamodel, String>();
    protected boolean modelCacheInit;
    protected VMMonitor monitor;
    protected final Queue<DeletionEntry> deletionQueue = new LinkedList<DeletionEntry>();
    protected final Queue<QueueEntry> setQueue = new LinkedList<QueueEntry>();
    protected final Map<EObject, RemapEntry> remapQueue = new HashMap<EObject, RemapEntry>();
    protected final Validator<CodeBlock> cbStackValidator = new ValidCodeBlockStackLevelValidator();
    protected final Validator<Instruction> instrStackValidator = new StackUnderflowValidator();
    private CodeBlockJIT cbJit;
    private boolean ruleStateCompiled;

    protected ExecEnvImpl() {
        this.registerMetaModel("ecore".toUpperCase(), EMFTVMUtil.getEcoreMetamodel());
        this.registerMetaModel("emftvm".toUpperCase(), EMFTVMUtil.getEmfTvmMetamodel());
        this.registerMetaModel("trace".toUpperCase(), EMFTVMUtil.getTraceMetamodel());
        this.createField("matches", true, Types.EXEC_ENV_TYPE, Types.TRACE_LINK_SET_TYPE, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ExecEnvImpl.this.getMatches();
            }
        });
        this.createField("traces", true, Types.EXEC_ENV_TYPE, Types.TRACE_LINK_SET_TYPE, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ExecEnvImpl.this.getTraces();
            }
        });
        final Module oclModule = OCLOperations.getInstance().getOclModule();
        this.loadModule(new ModuleResolver(){

            public Module resolveModule(String name) throws ModuleNotFoundException {
                return oclModule;
            }
        }, oclModule.getName());
    }

    private void createField(String name, boolean isStatic, String[] context, String[] type, CodeBlock initialiser) {
        Field f = EMFTVMUtil.createField(name, isStatic, context, type, initialiser);
        this.registerFeature(f);
    }

    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.EXEC_ENV;
    }

    @Override
    public Map<String, Module> getModules() {
        if (this.modules == null) {
            this.modules = Collections.unmodifiableMap(this.internalModules);
        }
        return this.modules;
    }

    @Override
    public TraceLinkSet getMatches() {
        if (this.matches == null) {
            this.basicGetMatches();
        }
        if (this.matches != null && this.matches.eIsProxy()) {
            InternalEObject oldMatches = (InternalEObject)this.matches;
            this.matches = (TraceLinkSet)this.eResolveProxy(oldMatches);
            if (this.matches != oldMatches && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldMatches, (Object)this.matches));
            }
        }
        return this.matches;
    }

    public TraceLinkSet basicGetMatches() {
        if (this.matches == null) {
            Map<String, Model> oms = this.getOutputModels();
            Map<String, Model> ioms = this.getInoutModels();
            this.matches = oms.containsKey("match") ? (TraceLinkSet)oms.get("match").newElement(TracePackage.eINSTANCE.getTraceLinkSet()) : (ioms.containsKey("match") ? (TraceLinkSet)ioms.get("match").newElement(TracePackage.eINSTANCE.getTraceLinkSet()) : TraceFactory.eINSTANCE.createTraceLinkSet());
            assert (this.matches != null);
        }
        return this.matches;
    }

    @Override
    public TraceLinkSet getTraces() {
        if (this.traces == null) {
            this.basicGetTraces();
        }
        if (this.traces != null && this.traces.eIsProxy()) {
            InternalEObject oldTraces = (InternalEObject)this.traces;
            this.traces = (TraceLinkSet)this.eResolveProxy(oldTraces);
            if (this.traces != oldTraces && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldTraces, (Object)this.traces));
            }
        }
        return this.traces;
    }

    public TraceLinkSet basicGetTraces() {
        if (this.traces == null) {
            Map<String, Model> oms = this.getOutputModels();
            Map<String, Model> ioms = this.getInoutModels();
            this.traces = oms.containsKey("trace") ? (TraceLinkSet)oms.get("trace").newElement(TracePackage.eINSTANCE.getTraceLinkSet()) : (ioms.containsKey("trace") ? (TraceLinkSet)ioms.get("trace").newElement(TracePackage.eINSTANCE.getTraceLinkSet()) : TraceFactory.eINSTANCE.createTraceLinkSet());
            assert (this.traces != null);
        }
        return this.traces;
    }

    @Override
    public Map<TraceLink, Object> getUniqueResults() {
        if (this.uniqueResults == null) {
            this.uniqueResults = new HashMap<TraceLink, Object>();
        }
        return this.uniqueResults;
    }

    @Override
    public boolean isJitDisabled() {
        return this.jitDisabled;
    }

    @Override
    public void setJitDisabled(boolean newJitDisabled) {
        boolean oldJitDisabled = this.jitDisabled;
        this.jitDisabled = newJitDisabled;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldJitDisabled, this.jitDisabled));
        }
    }

    @Override
    public RuleMode getCurrentPhase() {
        return this.currentPhase;
    }

    @Override
    public VMMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public synchronized void setMonitor(VMMonitor monitor) {
        if (this.monitor == null) {
            if (monitor != null) {
                this.resetJITCompiler();
            }
        } else if (monitor == null) {
            this.resetJITCompiler();
        }
        this.monitor = monitor;
    }

    @Override
    public synchronized void registerMetaModel(String name, Metamodel metamodel) {
        this.internalMetaModels.put(name, metamodel);
        this.clearModelCaches();
        this.resetJITCompiler();
    }

    @Override
    public synchronized void registerInputModel(String name, Model model) {
        this.internalInputModels.put(name, model);
        this.clearModelCaches();
    }

    @Override
    public synchronized void registerInOutModel(String name, Model model) {
        this.internalInoutModels.put(name, model);
        this.clearModelCaches();
    }

    @Override
    public synchronized void registerOutputModel(String name, Model model) {
        this.internalOutputModels.put(name, model);
        this.clearModelCaches();
    }

    @Override
    public void clearModels() {
        this.internalInputModels.clear();
        this.internalInoutModels.clear();
        this.internalOutputModels.clear();
        this.clearModelCaches();
    }

    @Override
    public Metamodel getMetaModel(Resource resource) {
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return resource == null ? null : this.metaModelOf.get(resource);
    }

    @Override
    public void queueForSet(final EStructuralFeature feature, final EObject object, final Object value, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                EMFTVMUtil.set(ExecEnvImpl.this, object, feature, value);
            }
        });
    }

    @Override
    public void queueForSet(final Field field, final Object object, final Object value, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                field.setValue(object, value);
            }
        });
    }

    @Override
    public void queueXmiIDForSet(final EObject object, final Object value, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                Resource resource = object.eResource();
                ((XMIResource)resource).setID(object, value.toString());
            }
        });
    }

    @Override
    public void queueForAdd(final EStructuralFeature feature, final EObject object, final Object value, final int index, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                EMFTVMUtil.add(ExecEnvImpl.this, object, feature, value, index);
            }
        });
    }

    @Override
    public void queueForAdd(final Field field, final Object object, final Object value, final int index, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                if (object instanceof EObject) {
                    EObject eo = (EObject)object;
                    if (ExecEnvImpl.this.getInputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Cannot add to properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, (ExecEnv)ExecEnvImpl.this)));
                    }
                    if (ExecEnvImpl.this.getOutputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Adding to transient field %s of %s, which cannot be read back as %1s is contained in an output model", field.getName(), EMFTVMUtil.toPrettyString(eo, (ExecEnv)ExecEnvImpl.this)));
                    }
                }
                field.addValue(object, value, index, this.frame);
            }
        });
    }

    @Override
    public void queueXmiIDForAdd(final EObject object, final Object value, final int index, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                Resource resource = object.eResource();
                if (((XMIResource)resource).getID(object) != null) {
                    throw new IllegalArgumentException(String.format("Cannot add %s to field %s::%s: maximum multiplicity of 1 reached", value, EMFTVMUtil.toPrettyString(object, (ExecEnv)ExecEnvImpl.this), "__xmiID__"));
                }
                if (index > 0) {
                    throw new IndexOutOfBoundsException(String.valueOf(index));
                }
                ((XMIResource)resource).setID(object, value.toString());
            }
        });
    }

    @Override
    public void queueForRemove(final EStructuralFeature feature, final EObject object, final Object value, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                EMFTVMUtil.remove(ExecEnvImpl.this, object, feature, value);
            }
        });
    }

    @Override
    public void queueForRemove(final Field field, final Object object, final Object value, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                if (object instanceof EObject) {
                    EObject eo = (EObject)object;
                    if (ExecEnvImpl.this.getInputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Cannot remove from properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, (ExecEnv)ExecEnvImpl.this)));
                    }
                    if (ExecEnvImpl.this.getOutputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Removing from transient field %s of %s, which cannot be read back as %1s is contained in an output model", field.getName(), EMFTVMUtil.toPrettyString(eo, (ExecEnv)ExecEnvImpl.this)));
                    }
                }
                field.removeValue(object, value, this.frame);
            }
        });
    }

    @Override
    public void queueXmiIDForRemove(final EObject object, final Object value, StackFrame frame) {
        this.setQueue.offer(new QueueEntry(frame){

            protected void perform() {
                Resource resource = object.eResource();
                XMIResource xmiRes = (XMIResource)resource;
                String xmiID = xmiRes.getID(object);
                if (xmiID == null ? value == null : xmiID.equals(value)) {
                    xmiRes.setID(object, null);
                }
            }
        });
    }

    @Override
    public void setQueue() {
        try {
            while (!this.setQueue.isEmpty()) {
                this.setQueue.poll().process();
            }
        }
        finally {
            this.setQueue.clear();
        }
    }

    @Override
    public void queueForRemap(EObject source, EObject target, StackFrame frame) {
        if (this.remapQueue.containsKey(source)) {
            throw new IllegalArgumentException(String.format("Source element %s already queued for remap", EMFTVMUtil.toPrettyString(source, (ExecEnv)this)));
        }
        this.remapQueue.put(source, new RemapEntry(source, target, frame));
    }

    @Override
    public void remapQueue() {
        try {
            for (Model m : this.getInoutModels().values()) {
                ArrayList<EObject> eObjects = new ArrayList<EObject>();
                for (EObject o : new ResourceIterable(m.getResource())) {
                    eObjects.add(o);
                }
                for (EObject o : eObjects) {
                    for (EReference ref : o.eClass().getEAllReferences()) {
                        if (!ref.isChangeable() || ref.isContainer()) continue;
                        Object val = o.eGet((EStructuralFeature)ref);
                        if (val instanceof EList) {
                            EList listVal = (EList)val;
                            int index = 0;
                            while (index < listVal.size()) {
                                Object source = listVal.get(index);
                                if (this.remapQueue.containsKey(source)) {
                                    this.remapQueue.get(source).process(o, ref, index);
                                }
                                ++index;
                            }
                            continue;
                        }
                        if (!this.remapQueue.containsKey(val)) continue;
                        this.remapQueue.get(val).process(o, ref);
                    }
                }
            }
        }
        finally {
            this.remapQueue.clear();
        }
    }

    @Override
    public Map<String, Metamodel> getMetaModels() {
        if (this.metaModels == null) {
            this.metaModels = Collections.unmodifiableMap(this.internalMetaModels);
        }
        return this.metaModels;
    }

    @Override
    public Map<String, Model> getInputModels() {
        if (this.inputModels == null) {
            this.inputModels = Collections.unmodifiableMap(this.internalInputModels);
        }
        return this.inputModels;
    }

    @Override
    public Map<String, Model> getInoutModels() {
        if (this.inoutModels == null) {
            this.inoutModels = Collections.unmodifiableMap(this.internalInoutModels);
        }
        return this.inoutModels;
    }

    @Override
    public Map<String, Model> getOutputModels() {
        if (this.outputModels == null) {
            this.outputModels = Collections.unmodifiableMap(this.internalOutputModels);
        }
        return this.outputModels;
    }

    @Override
    public synchronized Module loadModule(ModuleResolver resolver, String name) {
        this.resetJITCompiler();
        if (this.isRuleStateCompiled()) {
            for (Rule r : this.getRules()) {
                r.resetState();
            }
        }
        this.setRuleStateCompiled(false);
        try {
            Object invalidObject;
            if (this.internalModules.containsKey(name)) {
                if (!this.loadedModules.contains(name)) {
                    ATLLogger.warning((String)String.format("Cyclic import of module %s detected; element redefinition will not work", name));
                }
                return this.internalModules.get(name);
            }
            Module module = resolver.resolveModule(name);
            if (module.eResource() != null && (invalidObject = this.validate(module)) != null) {
                throw new VMException(null, String.format("Byte code validation of %s failed", invalidObject));
            }
            this.internalModules.put(name, module);
            this.resolveImports(module, resolver);
            for (Feature f : module.getFeatures()) {
                this.registerFeature(f);
            }
            for (Rule r : module.getRules()) {
                this.registerRule(r);
            }
            for (Rule r : this.getRules()) {
                this.resolveSuperRules(r);
            }
            this.loadedModules.add(name);
            return module;
        }
        catch (Exception e) {
            throw new VMException(null, String.format("Error during module loading: %s", e.getMessage()), e);
        }
    }

    private Object validate(Module module) {
        Model mmodel = EmftvmFactory.eINSTANCE.createModel();
        mmodel.setResource(module.eResource());
        for (EObject eObject : mmodel.allInstancesOf(EmftvmPackage.eINSTANCE.getCodeBlock())) {
            CodeBlock cb = (CodeBlock)eObject;
            if (!this.cbStackValidator.validate(cb)) {
                return cb;
            }
            for (Instruction i : cb.getCode()) {
                if (this.instrStackValidator.validate(i)) continue;
                return i;
            }
        }
        return null;
    }

    private void resolveImports(Module module, ModuleResolver resolver) {
        EList<Module> eImports = module.getEImports();
        for (String imp : module.getImports()) {
            Module impModule = this.loadModule(resolver, imp);
            eImports.add((Object)impModule);
        }
    }

    protected void registerFeature(Feature feature) {
        feature.setEContext(this.findEClassifier(feature.getContextModel(), feature.getContext()));
        feature.setEType(this.findEClassifier(feature.getTypeModel(), feature.getType()));
        switch (feature.eClass().getClassifierID()) {
            case 6: {
                this.fieldContainer.registerField((Field)feature);
                break;
            }
            case 7: {
                this.registerOperation((Operation)feature);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Feature of class %s not supported", feature.eClass()));
            }
        }
    }

    private void registerOperation(Operation op) {
        if (op.isStatic()) {
            if ("main".equals(op.getName()) && op.getParameters().isEmpty()) {
                this.mainChain.add((Object)op);
            } else {
                this.registerOperationIn(op, this.staticOperations);
            }
        } else {
            this.registerOperationIn(op, this.operations);
        }
    }

    private void registerOperationIn(Operation op, Map<String, Map<Integer, TypeMap<Object, Object>>> reg) {
        EList<Parameter> args = op.getParameters();
        Integer argCount = args.size();
        String opname = op.getName();
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = reg.get(opname);
        if (argcountOpsMap == null) {
            argcountOpsMap = new HashMap<Integer, TypeMap<Object, Object>>();
            reg.put(opname, argcountOpsMap);
        }
        EClassifier ectx = op.getEContext();
        assert (ectx != null);
        Object ctx = EMFTVMUtil.getRegistryType(ectx);
        TypeMap<Object, Object> ctxMap = argcountOpsMap.get(argCount);
        if (ctxMap == null) {
            ctxMap = new TypeHashMap<Object, Object>();
            argcountOpsMap.put(argCount, ctxMap);
        }
        if (argCount == 0) {
            ctxMap.put(ctx, op);
        } else {
            TypeHashMap<Object, Object> opsMap = (TypeHashMap<Object, Object>)ctxMap.get(ctx);
            if (opsMap == null) {
                opsMap = new TypeHashMap<Object, Object>();
                ctxMap.put(ctx, opsMap);
            }
            ExecEnvImpl.registerOperationByArgTypes(op, opsMap, this.getTypesOfParameters(op.getParameters()), 0);
        }
    }

    private Object[] getTypesOfParameters(EList<Parameter> eList) {
        Object[] types = new Object[eList.size()];
        int i = 0;
        while (i < types.length) {
            Parameter par = (Parameter)eList.get(i);
            par.setEType(this.findEClassifier(par.getTypeModel(), par.getType()));
            types[i] = EMFTVMUtil.getRegistryType(par.getEType());
            ++i;
        }
        return types;
    }

    private static void registerOperationByArgTypes(Operation op, TypeMap<Object, Object> reg, Object[] argTypes, int argIndex) {
        int argCount = argTypes.length;
        assert (argIndex >= 0 && argIndex < argCount);
        Object regType = argTypes[argIndex];
        if (argIndex < argCount - 1) {
            TypeHashMap<Object, Object> nestedReg = (TypeHashMap<Object, Object>)reg.get(regType);
            if (nestedReg == null) {
                nestedReg = new TypeHashMap<Object, Object>();
                reg.put(regType, nestedReg);
            }
            ExecEnvImpl.registerOperationByArgTypes(op, nestedReg, argTypes, argIndex + 1);
        } else {
            reg.put(regType, op);
        }
    }

    private static boolean isMoreSpecific(EList<Parameter> first, EList<Parameter> second, int index) {
        Class sCls;
        assert (first.size() == second.size());
        EClassifier f = ((Parameter)first.get(index)).getEType();
        EClassifier s = ((Parameter)second.get(index)).getEType();
        assert (f != null);
        assert (s != null);
        if (f == s && index < first.size() - 1) {
            return ExecEnvImpl.isMoreSpecific(first, second, index + 1);
        }
        if (f instanceof EClass && s instanceof EClass) {
            return ((EClass)s).isSuperTypeOf((EClass)f);
        }
        assert (f instanceof EClass || f.getInstanceClass() != null);
        assert (s instanceof EClass || s.getInstanceClass() != null);
        Class fCls = f.getInstanceClass() == null ? EObject.class : f.getInstanceClass();
        Class clazz = sCls = s.getInstanceClass() == null ? EObject.class : s.getInstanceClass();
        assert (fCls != null);
        assert (sCls != null);
        if (fCls == sCls && index < first.size() - 1) {
            return ExecEnvImpl.isMoreSpecific(first, second, index + 1);
        }
        return sCls.isAssignableFrom(fCls);
    }

    private static boolean isMoreSpecific(Operation first, Operation second) {
        Class sCls;
        EClassifier f = first.getEContext();
        EClassifier s = second.getEContext();
        assert (f != null);
        assert (s != null);
        if (f == s) {
            return ExecEnvImpl.isMoreSpecific(first.getParameters(), second.getParameters(), 0);
        }
        if (f instanceof EClass && s instanceof EClass) {
            return ((EClass)s).isSuperTypeOf((EClass)f);
        }
        assert (f instanceof EClass || f.getInstanceClass() != null);
        assert (s instanceof EClass || s.getInstanceClass() != null);
        Class fCls = f.getInstanceClass() == null ? EObject.class : f.getInstanceClass();
        Class clazz = sCls = s.getInstanceClass() == null ? EObject.class : s.getInstanceClass();
        assert (fCls != null);
        assert (sCls != null);
        if (fCls == sCls) {
            return ExecEnvImpl.isMoreSpecific(first.getParameters(), second.getParameters(), 0);
        }
        return sCls.isAssignableFrom(fCls);
    }

    protected void registerRule(Rule r) {
        String rName = r.getName();
        if (this.rules.containsKey(rName)) {
            Rule oldRule = this.rules.get(rName);
            if (r.getMode() != oldRule.getMode()) {
                throw new IllegalArgumentException(String.format("Rule %s with mode %s cannot redefine existing rule with mode %s", new Object[]{rName, r.getMode(), oldRule.getMode()}));
            }
        }
        this.rules.put(rName, r);
        for (RuleElement re : r.getInputElements()) {
            this.resolveRuleElement(re);
        }
        for (RuleElement re : r.getOutputElements()) {
            this.resolveRuleElement(re);
        }
        for (Field field : r.getFields()) {
            field.setEContext(this.findEClassifier(field.getContextModel(), field.getContext()));
            field.setEType(this.findEClassifier(field.getTypeModel(), field.getType()));
            r.registerField(field);
        }
    }

    private void resolveRuleElement(RuleElement re) {
        re.setEType(this.findEClassifier(re.getTypeModel(), re.getType()));
    }

    private void resolveSuperRules(Rule rule) {
        EList<Rule> eSuperRules = rule.getESuperRules();
        eSuperRules.clear();
        for (String superRuleName : rule.getSuperRules()) {
            Rule superRule = this.findRule(superRuleName);
            if (superRule == null) {
                throw new IllegalArgumentException(String.format("Super-rule %s of %s is not found in any module loaded before %s", superRuleName, rule.getName(), rule.getModule()));
            }
            if (superRule.getMode() != rule.getMode()) {
                throw new IllegalArgumentException(String.format("Rule %s with mode %s cannot inherit from super-rule %s with mode %s", new Object[]{rule.getName(), rule.getMode(), superRule.getName(), superRule.getMode()}));
            }
            for (OutputRuleElement sre : superRule.getOutputElements()) {
                for (OutputRuleElement re : rule.getOutputElements()) {
                    if (!sre.getName().equals(re.getName()) || ((EClass)sre.getEType()).isSuperTypeOf((EClass)re.getEType())) continue;
                    throw new IllegalArgumentException(String.format("Output element %s of type %s in rule %s is not compatible with element %s of type %s in super-rule %s", re.getName(), EMFTVMUtil.toPrettyString(re.getEType(), (ExecEnv)this), rule.getName(), sre.getName(), EMFTVMUtil.toPrettyString(sre.getEType(), (ExecEnv)this), superRule.getName()));
                }
            }
            eSuperRules.add((Object)superRule);
        }
    }

    protected void resolveRuleModels(Rule r) {
        LinkedHashMap<String, Model> inModels = new LinkedHashMap<String, Model>(this.getInputModels());
        inModels.putAll(this.getInoutModels());
        for (RuleElement re : r.getInputElements()) {
            this.resolveRuleElementModels(re, inModels);
        }
        LinkedHashMap<String, Model> outModels = new LinkedHashMap<String, Model>(this.getOutputModels());
        outModels.putAll(this.getInoutModels());
        for (OutputRuleElement re : r.getOutputElements()) {
            this.resolveRuleElementModels(re, outModels);
        }
        r.compileIterables(this);
    }

    private void resolveRuleElementModels(RuleElement re, Map<String, Model> models) {
        re.setEType(this.findEClassifier(re.getTypeModel(), re.getType()));
        EList<Model> eModels = re.getEModels();
        eModels.clear();
        for (String modelName : re.getModels()) {
            Model model = models.get(modelName);
            if (model == null) {
                throw new IllegalArgumentException(String.format("Model %s not found", modelName));
            }
            eModels.add((Object)model);
        }
    }

    protected void clearRuleModels(Rule r) {
        for (RuleElement re : r.getInputElements()) {
            re.getEModels().clear();
        }
        for (RuleElement re : r.getOutputElements()) {
            re.getEModels().clear();
        }
    }

    @Override
    public Operation findOperation(Object context, String name, Object[] parameterTypes) {
        int argCount;
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.operations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(argCount = parameterTypes.length)) != null) {
            TypeMap<Object, Object> argMap = (TypeHashMap<Object, Object>)ctxMap.get(context);
            if (argMap != null) {
                op = ExecEnvImpl.findOperationDirect(argMap, parameterTypes, 0);
            }
            if (op == null) {
                HashSet<Object> ctxKeys = new HashSet<Object>();
                ctxMap.findAllKeys(context, ctxKeys);
                LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
                for (Object e : ctxKeys) {
                    argMap = (TypeMap)ctxMap.get(e);
                    ExecEnvImpl.findOperations(argMap, parameterTypes, ops, 0);
                }
                op = ExecEnvImpl.findMostSpecificOperation(ops);
                if (op != null) {
                    argMap = (TypeMap)ctxMap.get(context);
                    if (argMap == null) {
                        argMap = new TypeHashMap<Object, Object>();
                        ctxMap.put(context, argMap);
                    }
                    ExecEnvImpl.registerOperationByArgTypes(op, argMap, parameterTypes, 0);
                }
            }
        }
        return op;
    }

    @Override
    public Operation findOperation(Object context, String name) {
        Object ctxKey;
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.operations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(0)) != null && (op = (Operation)ctxMap.get(context)) == null && (ctxKey = ctxMap.findKey(context)) != null) {
            op = (Operation)ctxMap.get(ctxKey);
            assert (op != null);
            ctxMap.put(context, op);
        }
        return op;
    }

    @Override
    public Operation findOperation(Object context, String name, Object parameterType) {
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.operations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(1)) != null) {
            TypeMap<Object, Operation> argMap = (TypeHashMap<Object, Operation>)ctxMap.get(context);
            if (argMap != null) {
                op = (Operation)argMap.get(parameterType);
            }
            if (op == null) {
                HashSet<Object> ctxKeys = new HashSet<Object>();
                ctxMap.findAllKeys(context, ctxKeys);
                LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
                for (Object e : ctxKeys) {
                    argMap = (TypeMap)ctxMap.get(e);
                    HashSet<Object> argTypeKeys = new HashSet<Object>();
                    argMap.findAllKeys(parameterType, argTypeKeys);
                    for (Object e2 : argTypeKeys) {
                        ops.add((Operation)argMap.get(e2));
                    }
                }
                op = ExecEnvImpl.findMostSpecificOperation(ops);
                if (op != null) {
                    argMap = (TypeMap)ctxMap.get(context);
                    if (argMap == null) {
                        argMap = new TypeHashMap<Object, Operation>();
                        ctxMap.put(context, argMap);
                    }
                    argMap.put(parameterType, op);
                }
            }
        }
        return op;
    }

    @Override
    public boolean hasOperation(String name, int argcount) {
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.operations.get(name);
        if (argcountOpsMap != null) {
            return argcountOpsMap.get(argcount) != null;
        }
        return false;
    }

    @Override
    public Operation findStaticOperation(Object context, String name, Object[] parameterTypes) {
        TypeMap argMap;
        int argCount;
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.staticOperations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(argCount = parameterTypes.length)) != null && (argMap = (TypeMap)ctxMap.get(context)) != null && (op = ExecEnvImpl.findOperationDirect(argMap, parameterTypes, 0)) == null) {
            LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
            ExecEnvImpl.findOperations(argMap, parameterTypes, ops, 0);
            op = ExecEnvImpl.findMostSpecificOperation(ops);
            if (op != null) {
                ExecEnvImpl.registerOperationByArgTypes(op, argMap, parameterTypes, 0);
            }
        }
        return op;
    }

    @Override
    public Operation findStaticOperation(Object context, String name) {
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.staticOperations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(0)) != null) {
            op = (Operation)ctxMap.get(context);
        }
        return op;
    }

    @Override
    public Operation findStaticOperation(Object context, String name, Object parameterType) {
        TypeMap<Object, Operation> argMap;
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.staticOperations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(1)) != null && (argMap = (TypeHashMap<Object, Operation>)ctxMap.get(context)) != null && (op = (Operation)argMap.get(parameterType)) == null) {
            LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
            HashSet<Object> argTypeKeys = new HashSet<Object>();
            argMap.findAllKeys(parameterType, argTypeKeys);
            for (Object e : argTypeKeys) {
                ops.add((Operation)argMap.get(e));
            }
            op = ExecEnvImpl.findMostSpecificOperation(ops);
            if (op != null) {
                argMap = (TypeMap)ctxMap.get(context);
                if (argMap == null) {
                    argMap = new TypeHashMap<Object, Operation>();
                    ctxMap.put(context, argMap);
                }
                argMap.put(parameterType, op);
            }
        }
        return op;
    }

    @Override
    public boolean hasStaticOperation(String name, int argcount) {
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.staticOperations.get(name);
        if (argcountOpsMap != null) {
            return argcountOpsMap.get(argcount) != null;
        }
        return false;
    }

    private static Operation findOperationDirect(TypeMap<Object, Object> typeMap, Object[] parameterTypes, int argIndex) {
        int argCount = parameterTypes.length;
        assert (argIndex >= 0 && argIndex < argCount);
        Object argType = parameterTypes[argIndex];
        if (argIndex < argCount - 1) {
            TypeMap nestedTypeMap = (TypeMap)typeMap.get(argType);
            if (nestedTypeMap != null) {
                return ExecEnvImpl.findOperationDirect(nestedTypeMap, parameterTypes, argIndex + 1);
            }
            return null;
        }
        return (Operation)typeMap.get(argType);
    }

    private static void findOperations(TypeMap<Object, Object> typeMap, Object[] parameterTypes, Set<Operation> ops, int argIndex) {
        int argCount = parameterTypes.length;
        assert (argIndex >= 0 && argIndex < argCount);
        Object argType = parameterTypes[argIndex];
        HashSet<Object> argTypeKeys = new HashSet<Object>();
        typeMap.findAllKeys(argType, argTypeKeys);
        if (argIndex < argCount - 1) {
            for (Object e : argTypeKeys) {
                TypeMap nestedTypeMap = (TypeMap)typeMap.get(e);
                ExecEnvImpl.findOperations(nestedTypeMap, parameterTypes, ops, argIndex + 1);
            }
        } else {
            for (Object e : argTypeKeys) {
                ops.add((Operation)typeMap.get(e));
            }
        }
    }

    private static Operation findMostSpecificOperation(Collection<Operation> ops) {
        Operation msOp = null;
        HashSet<Operation> conflicts = new HashSet<Operation>();
        for (Operation op : ops) {
            if (msOp == null || ExecEnvImpl.isMoreSpecific(op, msOp)) {
                msOp = op;
                continue;
            }
            if (ExecEnvImpl.isMoreSpecific(msOp, op)) continue;
            conflicts.add(op);
        }
        assert (msOp != null || ops.isEmpty() && conflicts.isEmpty());
        for (Operation op : conflicts) {
            if (ExecEnvImpl.isMoreSpecific(msOp, op)) continue;
            throw new DuplicateEntryException(String.format("More than one operation found for given context/arguments: %s and %s", msOp, op));
        }
        return msOp;
    }

    @Override
    public Field findField(Object context, String name) {
        return this.fieldContainer.findField(context, name);
    }

    @Override
    public boolean hasField(String name) {
        return this.fieldContainer.hasField(name);
    }

    @Override
    public Field findStaticField(Object context, String name) {
        return this.fieldContainer.findStaticField(context, name);
    }

    @Override
    public boolean hasStaticField(String name) {
        return this.fieldContainer.hasStaticField(name);
    }

    @Override
    public Rule findRule(String name) {
        return this.rules.get(name);
    }

    @Override
    public Object findType(String modelName, String typeName) throws ClassNotFoundException {
        if ("#native".equals(modelName)) {
            return NativeTypes.findType(typeName);
        }
        Metamodel mm = this.getMetaModels().get(modelName);
        if (mm == null) {
            throw new IllegalArgumentException(String.format("Metamodel %s not found", modelName));
        }
        return mm.findType(typeName);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Object run(TimingData timingData) {
        result = null;
        try {
            try {
                if (!ExecEnvImpl.$assertionsDisabled && !this.deletionQueue.isEmpty()) {
                    throw new AssertionError();
                }
                if (!this.isRuleStateCompiled()) {
                    for (Rule r : this.getRules()) {
                        r.compileState(this);
                    }
                }
                var4_3 = this.getRules().iterator();
                while (true) {
                    if (!var4_3.hasNext()) {
                        mains = this.mainChain.iterator();
                        if (mains.hasNext()) break;
                        throw new UnsupportedOperationException(String.format("Operation %s not found", new Object[]{"main"}));
                    }
                    r = (Rule)var4_3.next();
                    this.resolveRuleModels(r);
                }
                rootFrame = new StackFrame(this, ((Operation)this.mainChain.get(this.mainChain.size() - 1)).getBody());
                this.currentPhase = RuleMode.AUTOMATIC_SINGLE;
                this.matchAllSingle(rootFrame, timingData);
                this.currentPhase = RuleMode.AUTOMATIC_RECURSIVE;
                this.matchAllRecursive(rootFrame, timingData);
                this.currentPhase = RuleMode.MANUAL;
                while (true) {
                    if (!mains.hasNext()) {
                        this.setQueue();
                        this.remapQueue();
                        this.deleteQueue();
                        if (this.monitor != null) {
                            this.monitor.terminated();
                        }
                        break;
                    }
                    cb = ((Operation)mains.next()).getBody();
                    if (cb.getStackLevel() > 0) {
                        result = cb.execute(new StackFrame(this, cb));
                        continue;
                    }
                    cb.execute(new StackFrame(this, cb));
                }
            }
            catch (VMException e) {
                if (this.monitor != null) {
                    this.monitor.error(e.getFrame(), e.getLocalizedMessage(), e);
                    this.monitor.terminated();
                }
                throw e;
            }
        }
        finally {
            this.currentPhase = null;
            this.matches = null;
            this.traces = null;
            this.uniqueResults = null;
            this.fieldContainer.clear();
            ** for (r : this.getRules())
        }
lbl-1000:
        // 1 sources

        {
            r.clearFields();
            this.clearRuleModels(r);
            continue;
        }
lbl58:
        // 1 sources

        if (!ExecEnvImpl.$assertionsDisabled && this.findStaticField(this.eClass(), "matches").getStaticValue() != null) {
            throw new AssertionError();
        }
        if (!ExecEnvImpl.$assertionsDisabled && this.findStaticField(this.eClass(), "traces").getStaticValue() != null) {
            throw new AssertionError();
        }
        return result;
    }

    private EClassifier findEClassifier(String modelName, String typeName) {
        try {
            Object type = this.findType(modelName, typeName);
            if (type instanceof Class) {
                EDataType dt = EcoreFactory.eINSTANCE.createEDataType();
                dt.setName(typeName);
                dt.setInstanceClass((Class)type);
                return dt;
            }
            return (EClassifier)type;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected synchronized void cacheModels() {
        this.cacheMetaModels(this.getMetaModels(), this.metaModelOf);
        this.cacheModels(this.getInputModels(), this.inputModelOf);
        this.cacheModels(this.getOutputModels(), this.outputModelOf);
        this.cacheModels(this.getInoutModels(), this.inoutModelOf);
        this.cacheModels(this.getMetaModels(), null);
        this.modelCacheInit = true;
    }

    protected synchronized void clearModelCaches() {
        this.metaModelOf.clear();
        this.modelOf.clear();
        this.inputModelOf.clear();
        this.inoutModelOf.clear();
        this.outputModelOf.clear();
        this.metaModelId.clear();
        this.modelId.clear();
        this.modelCacheInit = false;
    }

    private void cacheModels(Map<String, ? extends Model> models, Map<Resource, Model> thisModelOf) {
        for (Map.Entry<String, ? extends Model> entry : models.entrySet()) {
            String id = entry.getKey();
            Model model = entry.getValue();
            this.modelOf.put(model.getResource(), model);
            if (thisModelOf != null) {
                thisModelOf.put(model.getResource(), model);
            }
            this.modelId.put(model, id);
        }
    }

    private void cacheMetaModels(Map<String, ? extends Metamodel> models, Map<Resource, Metamodel> thisModelOf) {
        for (Map.Entry<String, ? extends Metamodel> entry : models.entrySet()) {
            String id = entry.getKey();
            Metamodel model = entry.getValue();
            if (thisModelOf != null) {
                thisModelOf.put(model.getResource(), model);
            }
            this.metaModelId.put(model, id);
        }
    }

    private void matchAllSingle(StackFrame frame, TimingData timingData) {
        boolean match;
        LazyList<Rule> rules = this.getRules();
        LinkedHashSet<Rule> matchedRules = new LinkedHashSet<Rule>();
        do {
            match = false;
            for (Rule rule : rules) {
                if (matchedRules.contains(rule) || !matchedRules.containsAll((Collection<?>)rule.getESuperRules()) || !rule.matchSingle(frame)) continue;
                match = true;
                matchedRules.add(rule);
            }
        } while (match);
        for (Rule rule : matchedRules) {
            rule.createTraces(frame);
        }
        if (timingData != null) {
            timingData.finishMatch();
        }
        for (Rule rule : matchedRules) {
            rule.apply(frame);
        }
        this.setQueue();
        this.remapQueue();
        if (timingData != null) {
            timingData.finishApply();
        }
        for (Rule rule : matchedRules) {
            rule.postApply(frame);
        }
        this.setQueue();
        this.remapQueue();
        this.deleteQueue();
        if (timingData != null) {
            timingData.finishPostApply();
        }
    }

    private void matchAllRecursive(StackFrame frame, TimingData timingData) {
        boolean outerMatch;
        LazyList<Rule> rules = this.getRules();
        LinkedHashSet<Rule> matchedRules = new LinkedHashSet<Rule>();
        block0: do {
            boolean match;
            outerMatch = false;
            matchedRules.clear();
            block1: do {
                match = false;
                for (Rule rule : rules) {
                    if (matchedRules.contains(rule) || !matchedRules.containsAll((Collection<?>)rule.getESuperRules())) continue;
                    boolean[] matchResult = rule.matchRecursive(frame);
                    if (matchResult[1]) {
                        outerMatch = true;
                        matchedRules.add(rule);
                        break block1;
                    }
                    if (!matchResult[0]) continue;
                    match = true;
                    matchedRules.add(rule);
                    outerMatch |= !rule.isAbstract();
                }
            } while (match);
            for (Rule rule : matchedRules) {
                if (rule.applyFirst(frame)) continue block0;
            }
        } while (outerMatch);
        if (timingData != null) {
            timingData.finishRecursive();
        }
    }

    @Override
    public LazyList<Rule> getRules() {
        return new LazyList<Rule>(this.rules.values());
    }

    @Override
    public Model getModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.modelOf.get(r);
    }

    @Override
    public String getModelID(Model model) {
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return model == null ? null : this.modelId.get(model);
    }

    @Override
    public String getMetaModelID(Metamodel metamodel) {
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return metamodel == null ? null : this.metaModelId.get(metamodel);
    }

    @Override
    public void queueForDelete(EObject element, StackFrame frame) {
        this.deletionQueue.offer(new DeletionEntry(element, frame));
    }

    @Override
    public void deleteQueue() {
        try {
            while (!this.deletionQueue.isEmpty()) {
                this.deletionQueue.poll().process();
            }
        }
        finally {
            this.deletionQueue.clear();
        }
    }

    @Override
    public Model getInputModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.inputModelOf.get(r);
    }

    @Override
    public Model getInoutModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.inoutModelOf.get(r);
    }

    @Override
    public Model getOutputModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.outputModelOf.get(r);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getMetaModels();
            }
            case 1: {
                return this.getInputModels();
            }
            case 2: {
                return this.getInoutModels();
            }
            case 3: {
                return this.getOutputModels();
            }
            case 4: {
                return this.getModules();
            }
            case 5: {
                if (resolve) {
                    return this.getMatches();
                }
                return this.basicGetMatches();
            }
            case 6: {
                if (resolve) {
                    return this.getTraces();
                }
                return this.basicGetTraces();
            }
            case 7: {
                return this.getUniqueResults();
            }
            case 8: {
                return this.isJitDisabled();
            }
            case 9: {
                return this.getCurrentPhase();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setJitDisabled((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setJitDisabled(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.metaModels != null;
            }
            case 1: {
                return this.inputModels != null;
            }
            case 2: {
                return this.inoutModels != null;
            }
            case 3: {
                return this.outputModels != null;
            }
            case 4: {
                return this.modules != null;
            }
            case 5: {
                return this.matches != null;
            }
            case 6: {
                return this.traces != null;
            }
            case 7: {
                return this.uniqueResults != null;
            }
            case 8: {
                return this.jitDisabled;
            }
            case 9: {
                return this.currentPhase != CURRENT_PHASE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (metaModels: ");
        result.append(this.metaModels);
        result.append(", inputModels: ");
        result.append(this.inputModels);
        result.append(", inoutModels: ");
        result.append(this.inoutModels);
        result.append(", outputModels: ");
        result.append(this.outputModels);
        result.append(", modules: ");
        result.append(this.modules);
        result.append(", uniqueResults: ");
        result.append(this.uniqueResults);
        result.append(", jitDisabled: ");
        result.append(this.jitDisabled);
        result.append(", currentPhase: ");
        result.append((Object)this.currentPhase);
        result.append(')');
        return result.toString();
    }

    @Override
    public synchronized CodeBlockJIT getJITCompiler() {
        if (this.cbJit == null && !this.isJitDisabled()) {
            this.cbJit = new CodeBlockJIT(this);
        }
        return this.cbJit;
    }

    protected synchronized void resetJITCompiler() {
        if (this.cbJit != null) {
            this.cbJit.cleanup();
        }
        this.cbJit = null;
    }

    protected boolean isRuleStateCompiled() {
        return this.ruleStateCompiled;
    }

    protected void setRuleStateCompiled(boolean ruleStateCompiled) {
        this.ruleStateCompiled = ruleStateCompiled;
    }

    final class DeletionEntry
    extends QueueEntry {
        protected final EObject element;

        public DeletionEntry(EObject element, StackFrame frame) {
            super(frame);
            this.element = element;
        }

        protected void perform() {
            assert (ExecEnvImpl.this.getInputModelOf(this.element) == null);
            Model m = ExecEnvImpl.this.getModelOf(this.element);
            try {
                m.deleteElement(this.element);
            }
            catch (Exception e) {
                this.frame.setPc(this.pc);
                throw new VMException(this.frame, String.format("Error while deleting element %s from %s: %s", EMFTVMUtil.toPrettyString(this.element, (ExecEnv)ExecEnvImpl.this), ExecEnvImpl.this.getModelID(m), e.getLocalizedMessage()), e);
            }
        }
    }

    abstract class QueueEntry {
        protected final StackFrame frame;
        protected final int pc;

        public QueueEntry(StackFrame frame) {
            this.frame = frame;
            this.pc = frame.getPc();
        }

        public void process() {
            try {
                this.perform();
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                this.frame.setPc(this.pc);
                throw new VMException(this.frame, (Throwable)e);
            }
        }

        protected abstract void perform();
    }

    final class RemapEntry
    extends QueueEntry {
        protected final EObject source;
        protected final EObject target;

        public RemapEntry(EObject source, EObject target, StackFrame frame) {
            super(frame);
            this.source = source;
            this.target = target;
        }

        protected void perform() {
            throw new UnsupportedOperationException();
        }

        public void process(EObject o, EReference ref) {
            try {
                assert (o.eGet((EStructuralFeature)ref) == this.source);
                EMFTVMUtil.set(ExecEnvImpl.this, o, (EStructuralFeature)ref, this.target);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                this.frame.setPc(this.pc);
                ExecEnv env = this.frame.getEnv();
                throw new VMException(this.frame, String.format("Error remapping %s.%s from %s to %s: %s", EMFTVMUtil.toPrettyString(o, env), ref.getName(), EMFTVMUtil.toPrettyString(this.source, env), EMFTVMUtil.toPrettyString(this.target, env), e.getMessage()), e);
            }
        }

        public void process(EObject o, EReference ref, int index) {
            try {
                assert (o.eGet((EStructuralFeature)ref) instanceof EList);
                assert (((EList)o.eGet((EStructuralFeature)ref)).get(index) == this.source);
                EMFTVMUtil.remove(ExecEnvImpl.this, o, (EStructuralFeature)ref, this.source);
                EMFTVMUtil.add(ExecEnvImpl.this, o, (EStructuralFeature)ref, this.target, index);
            }
            catch (VMException e) {
                throw e;
            }
            catch (Exception e) {
                this.frame.setPc(this.pc);
                ExecEnv env = this.frame.getEnv();
                throw new VMException(this.frame, String.format("Error remapping %s.%s from %s to %s: %s", EMFTVMUtil.toPrettyString(o, env), ref.getName(), EMFTVMUtil.toPrettyString(this.source, env), EMFTVMUtil.toPrettyString(this.target, env), e.getMessage()), e);
            }
        }
    }
}

