/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.impl.resource.EMFTVMResourceImpl;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassModuleResolver
implements ModuleResolver {
    private final Class<?> clazz;

    public ClassModuleResolver(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Module resolveModule(String module) throws ModuleNotFoundException {
        EMFTVMResourceImpl moduleRes = new EMFTVMResourceImpl();
        String moduleFile = String.valueOf(module.replaceAll("::", "/")) + ".emftvm";
        URL moduleUrl = this.clazz.getResource(moduleFile);
        try {
            InputStream inputStream = moduleUrl.openStream();
            if (inputStream == null) {
                throw new ModuleNotFoundException("Cannot load: [" + moduleFile + "]");
            }
            try {
                moduleRes.load(inputStream, Collections.emptyMap());
                moduleRes.setURI(URI.createURI((String)moduleUrl.toString()));
            }
            finally {
                inputStream.close();
            }
            return (Module)moduleRes.getContents().get(0);
        }
        catch (IOException e) {
            throw new ModuleNotFoundException(e);
        }
    }
}

