/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.text.AtlAnnotationHover;
import org.eclipse.m2m.atl.adt.ui.text.AtlColorManager;
import org.eclipse.m2m.atl.adt.ui.text.AtlContentAssistPreference;
import org.eclipse.m2m.atl.adt.ui.text.AtlReconcilingStrategy;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextDoubleClickStrategy;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlAutoIndentStrategy;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCodeScanner;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlStringAutoIndentStrategy;
import org.eclipse.m2m.atl.adt.ui.text.hover.AtlTextHover;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class AtlSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private IContentAssistProcessor fProcessor;
    private ITextEditor fTextEditor;
    private AtlTextTools fTextTools;

    public AtlSourceViewerConfiguration(AtlTextTools tools, ITextEditor editor) {
        this.fTextTools = tools;
        this.fTextEditor = editor;
        this.fProcessor = new AtlCompletionProcessor((IEditorPart)this.getEditor());
        this.fPreferenceStore = tools.getPreferenceStore();
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.getTextTools().getCodeScanner().affectsBehavior(event);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("string".equals(contentType)) {
            return new IAutoEditStrategy[]{new AtlStringAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer))};
        }
        return new IAutoEditStrategy[]{new AtlAutoIndentStrategy(this.getConfiguredDocumentPartitioning(sourceViewer))};
    }

    public AtlColorManager getColorManager() {
        return this.getTextTools().getColorManager();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = AtlUIPlugin.getDefault().getPreferenceStore();
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor(this.fProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor(this.fProcessor, "string");
        assistant.setContentAssistProcessor(this.fProcessor, "character");
        assistant.setContentAssistProcessor(this.fProcessor, "singleline_comment");
        assistant.setContentAssistProcessor(this.fProcessor, "documentation");
        AtlContentAssistPreference.configure(assistant, store);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setProposalPopupOrientation(10);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.setRepeatedInvocationMode(true);
        assistant.setStatusLineVisible(true);
        assistant.addCompletionListener((ICompletionListener)((AtlCompletionProcessor)this.fProcessor));
        return assistant;
    }

    public IContentAssistProcessor getCompletionProcessor() {
        return this.fProcessor;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        int tabWidth = this.getPreferenceStore().getInt("tabWidth");
        boolean useSpaces = this.getPreferenceStore().getBoolean("Atl.Typing.SpacesForTabs");
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.getTextTools().getPreferenceStore();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getTextTools().getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public AtlTextTools getTextTools() {
        return this.fTextTools;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.getTextTools().getCodeScanner().affectsBehavior(event)) {
            this.getTextTools().getCodeScanner().adaptToPreferenceChange(event);
        }
    }

    private void initializeScanners() {
        this.getTextTools().setCodeScanner(new AtlCodeScanner(this.getTextTools()));
    }

    public void setNewPreferenceStore(IPreferenceStore preferenceStore) {
        this.getTextTools().setNewPreferenceStore(preferenceStore);
        this.initializeScanners();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AtlAnnotationHover();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)new AtlReconcilingStrategy((AtlEditor)this.fTextEditor), false);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.m2m.atl.adt.editor.AtlEditorSource", this.fTextEditor);
        return targets;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"--", ""};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new AtlTextHover((AtlEditor)this.fTextEditor);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new AtlTextDoubleClickStrategy();
    }
}

