/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.adt.ui.AtlPreferenceConstants;
import org.eclipse.m2m.atl.adt.ui.AtlUIMessages;
import org.eclipse.m2m.atl.adt.ui.logging.ConsoleStreamHandler;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.m2m.atl.adt.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.framework.BundleContext;

public class AtlUIPlugin
extends AbstractUIPlugin {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static MessageConsole console = null;
    private static MessageConsoleStream consoleStream = null;
    private static IConsoleManager consoleMgr = null;
    private static final String ATL_CONSOLE = "org.atl.eclipse.adt.editor.console";
    private static final String ID = "org.atl.eclipse.adt.editor";
    private static AtlUIPlugin plugin;
    private AtlTextTools atlTextTools;
    private ProblemMarkerManager problemMarkerManager;
    private ResourceBundle resourceBundle;

    public static IWorkbenchPage getActivePage() {
        return AtlUIPlugin.getDefault().internalGetActivePage();
    }

    public static AtlUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        AtlUIPlugin plugin = AtlUIPlugin.getDefault();
        String pluginDir = plugin.getBundle().getEntry("/").toString();
        String iconPath = "icons/";
        try {
            return ImageDescriptor.createFromURL((URL)new URL(String.valueOf(pluginDir) + iconPath + name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static String getPluginId() {
        return ID;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AtlUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static void log(IStatus status) {
        AtlUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        AtlUIPlugin.log((IStatus)new Status(4, AtlUIPlugin.getPluginId(), 10001, AtlUIMessages.getString("JavaPlugin.internal_error"), e));
    }

    public AtlUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.m2m.atl.adt.ui.AtlUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        if (console == null) {
            this.initConsole();
        }
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.problemMarkerManager == null) {
            this.problemMarkerManager = new ProblemMarkerManager();
        }
        return this.problemMarkerManager;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public synchronized AtlTextTools getTextTools() {
        if (this.atlTextTools == null) {
            this.atlTextTools = new AtlTextTools(this.getPreferenceStore());
        }
        return this.atlTextTools;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        MarkerAnnotationPreferences.initializeDefaultValues((IPreferenceStore)store);
        AtlPreferenceConstants.initializeDefaultValues(store);
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.atlTextTools != null) {
                this.atlTextTools.dispose();
                this.atlTextTools = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public void println(String toPrint) {
        if (consoleStream != null) {
            consoleStream.println(toPrint);
        }
    }

    public void print(String toPrint) {
        if (consoleStream != null) {
            consoleStream.print(toPrint);
        }
    }

    private void initConsole() {
        console = this.findConsole(ATL_CONSOLE);
        Font f = null;
        try {
            FontData data = new FontData("Arial", 9, 9);
            data.setStyle(0);
            f = new Font(null, data);
            console.setFont(f);
        }
        catch (Exception exception) {}
        consoleStream = console.newMessageStream();
        this.activateConsole();
        consoleStream.println("ATL Console initiated");
        ConsoleStreamHandler handler = new ConsoleStreamHandler((OutputStream)consoleStream);
        Logger.getLogger("org.eclipse.m2m.atl").addHandler(handler);
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        consoleMgr = plugin.getConsoleManager();
        IConsole[] existing = consoleMgr.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        consoleMgr.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private void activateConsole() {
        IWorkbenchPage page = AtlUIPlugin.getActivePage();
        String id = "org.eclipse.ui.console.ConsoleView";
        try {
            if (page != null) {
                IConsoleView view = (IConsoleView)page.showView(id);
                view.display((IConsole)console);
            }
        }
        catch (PartInitException pex) {
            logger.log(Level.SEVERE, "AtlUiPlugin - " + pex.getLocalizedMessage(), pex);
        }
    }
}

