/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.InputRuleElement;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.OutputRuleElement;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleElement;
import org.eclipse.m2m.atl.emftvm.RuleMode;
import org.eclipse.m2m.atl.emftvm.impl.NamedElementImpl;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TargetElement;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLink;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;
import org.eclipse.m2m.atl.emftvm.util.FieldContainer;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleImpl
extends NamedElementImpl
implements Rule {
    protected static final RuleMode MODE_EDEFAULT = RuleMode.MANUAL;
    protected RuleMode mode = MODE_EDEFAULT;
    protected EList<InputRuleElement> inputElements;
    protected EList<OutputRuleElement> outputElements;
    protected EList<Rule> eSuperRules;
    protected EList<Rule> eSubRules;
    protected CodeBlock matcher;
    protected CodeBlock applier;
    protected CodeBlock postApply;
    protected EList<String> superRules;
    protected static final boolean ABSTRACT_EDEFAULT = false;
    protected boolean abstract_ = false;
    protected EList<Field> fields;
    protected static final boolean DEFAULT_EDEFAULT = false;
    protected boolean default_ = false;
    protected static final boolean DISTINCT_ELEMENTS_EDEFAULT = false;
    protected boolean distinctElements = false;
    protected static final boolean UNIQUE_EDEFAULT = false;
    protected boolean unique = false;
    protected static final boolean LEAF_EDEFAULT = false;
    protected boolean leaf = false;
    protected static final boolean WITH_LEAVES_EDEFAULT = false;
    protected boolean withLeaves = false;
    protected FieldContainer fieldContainer = new FieldContainer();
    protected UniqueState uniqueState;
    protected DefaultState defaultState;
    protected SuperRulesState superRulesState;
    protected RuleModeState ruleModeState;
    protected LeafState leafState;
    protected AbstractState abstractState;
    protected MatcherCbState matcherCbState;
    protected ApplierCbState applierCbState;
    protected DistinctState distinctState;
    protected LazySet<Rule> allESuperRules;
    protected final Map<TraceLink, Object[]> applyArgs = new HashMap<TraceLink, Object[]>();
    protected List<Iterable<EObject>> iterableList;
    protected Map<String, Iterable<EObject>> iterableMap;
    private boolean leafSet;
    private boolean withLeavesSet;

    protected RuleImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.RULE;
    }

    @Override
    public Module getModule() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (Module)this.eInternalContainer();
    }

    public NotificationChain basicSetModule(Module newModule, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newModule, 1, msgs);
        return msgs;
    }

    @Override
    public void setModule(Module newModule) {
        if (newModule != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newModule != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newModule)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newModule != null) {
                msgs = ((InternalEObject)newModule).eInverseAdd((InternalEObject)this, 3, Module.class, msgs);
            }
            if ((msgs = this.basicSetModule(newModule, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newModule, (Object)newModule));
        }
    }

    @Override
    public RuleMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(RuleMode newMode) {
        RuleMode oldMode = this.mode;
        RuleMode ruleMode = this.mode = newMode == null ? MODE_EDEFAULT : newMode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldMode, (Object)this.mode));
        }
    }

    @Override
    public EList<InputRuleElement> getInputElements() {
        if (this.inputElements == null) {
            this.inputElements = new EObjectContainmentWithInverseEList(InputRuleElement.class, (InternalEObject)this, 3, 7);
        }
        return this.inputElements;
    }

    @Override
    public EList<OutputRuleElement> getOutputElements() {
        if (this.outputElements == null) {
            this.outputElements = new EObjectContainmentWithInverseEList(OutputRuleElement.class, (InternalEObject)this, 4, 7);
        }
        return this.outputElements;
    }

    @Override
    public EList<Rule> getESuperRules() {
        if (this.eSuperRules == null) {
            this.eSuperRules = new EObjectWithInverseResolvingEList.ManyInverse(Rule.class, (InternalEObject)this, 5, 6);
        }
        return this.eSuperRules;
    }

    @Override
    public EList<Rule> getESubRules() {
        if (this.eSubRules == null) {
            this.eSubRules = new EObjectWithInverseResolvingEList.ManyInverse(Rule.class, (InternalEObject)this, 6, 5);
        }
        return this.eSubRules;
    }

    @Override
    public CodeBlock getMatcher() {
        return this.matcher;
    }

    public NotificationChain basicSetMatcher(CodeBlock newMatcher, NotificationChain msgs) {
        CodeBlock oldMatcher = this.matcher;
        this.matcher = newMatcher;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldMatcher, (Object)newMatcher);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setMatcher(CodeBlock newMatcher) {
        if (newMatcher != this.matcher) {
            NotificationChain msgs = null;
            if (this.matcher != null) {
                msgs = ((InternalEObject)this.matcher).eInverseRemove((InternalEObject)this, 5, CodeBlock.class, msgs);
            }
            if (newMatcher != null) {
                msgs = ((InternalEObject)newMatcher).eInverseAdd((InternalEObject)this, 5, CodeBlock.class, msgs);
            }
            if ((msgs = this.basicSetMatcher(newMatcher, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newMatcher, (Object)newMatcher));
        }
    }

    @Override
    public CodeBlock getApplier() {
        return this.applier;
    }

    public NotificationChain basicSetApplier(CodeBlock newApplier, NotificationChain msgs) {
        CodeBlock oldApplier = this.applier;
        this.applier = newApplier;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldApplier, (Object)newApplier);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setApplier(CodeBlock newApplier) {
        if (newApplier != this.applier) {
            NotificationChain msgs = null;
            if (this.applier != null) {
                msgs = ((InternalEObject)this.applier).eInverseRemove((InternalEObject)this, 6, CodeBlock.class, msgs);
            }
            if (newApplier != null) {
                msgs = ((InternalEObject)newApplier).eInverseAdd((InternalEObject)this, 6, CodeBlock.class, msgs);
            }
            if ((msgs = this.basicSetApplier(newApplier, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newApplier, (Object)newApplier));
        }
    }

    @Override
    public CodeBlock getPostApply() {
        return this.postApply;
    }

    public NotificationChain basicSetPostApply(CodeBlock newPostApply, NotificationChain msgs) {
        CodeBlock oldPostApply = this.postApply;
        this.postApply = newPostApply;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldPostApply, (Object)newPostApply);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPostApply(CodeBlock newPostApply) {
        if (newPostApply != this.postApply) {
            NotificationChain msgs = null;
            if (this.postApply != null) {
                msgs = ((InternalEObject)this.postApply).eInverseRemove((InternalEObject)this, 7, CodeBlock.class, msgs);
            }
            if (newPostApply != null) {
                msgs = ((InternalEObject)newPostApply).eInverseAdd((InternalEObject)this, 7, CodeBlock.class, msgs);
            }
            if ((msgs = this.basicSetPostApply(newPostApply, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newPostApply, (Object)newPostApply));
        }
    }

    @Override
    public EList<String> getSuperRules() {
        if (this.superRules == null) {
            this.superRules = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 10);
        }
        return this.superRules;
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    @Override
    public void setAbstract(boolean newAbstract) {
        boolean oldAbstract = this.abstract_;
        this.abstract_ = newAbstract;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldAbstract, this.abstract_));
        }
    }

    @Override
    public EList<Field> getFields() {
        if (this.fields == null) {
            this.fields = new EObjectContainmentWithInverseEList(Field.class, (InternalEObject)this, 12, 11);
        }
        return this.fields;
    }

    @Override
    public boolean isDefault() {
        return this.default_;
    }

    @Override
    public void setDefault(boolean newDefault) {
        boolean oldDefault = this.default_;
        this.default_ = newDefault;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldDefault, this.default_));
        }
    }

    @Override
    public boolean isDistinctElements() {
        return this.distinctElements;
    }

    @Override
    public void setDistinctElements(boolean newDistinctElements) {
        boolean oldDistinctElements = this.distinctElements;
        this.distinctElements = newDistinctElements;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldDistinctElements, this.distinctElements));
        }
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public void setUnique(boolean newUnique) {
        boolean oldUnique = this.unique;
        this.unique = newUnique;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldUnique, this.unique));
        }
    }

    @Override
    public boolean isLeaf() {
        if (!this.leafSet) {
            this.leaf = !this.isAbstract() && !this.isWithLeaves();
            this.leafSet = true;
        }
        return this.leaf;
    }

    @Override
    public boolean isWithLeaves() {
        if (!this.withLeavesSet) {
            this.withLeaves = false;
            for (Rule subRule : this.getESubRules()) {
                if (!subRule.isLeaf() && !subRule.isWithLeaves()) continue;
                this.withLeaves = true;
                break;
            }
            this.withLeavesSet = true;
        }
        return this.withLeaves;
    }

    @Override
    public Field findField(Object context, String name) {
        return this.fieldContainer.findField(context, name);
    }

    @Override
    public boolean hasField(String name) {
        return this.fieldContainer.hasField(name);
    }

    @Override
    public Field findStaticField(Object context, String name) {
        return this.fieldContainer.findStaticField(context, name);
    }

    @Override
    public boolean hasStaticField(String name) {
        return this.fieldContainer.hasStaticField(name);
    }

    @Override
    public void registerField(Field field) {
        this.fieldContainer.registerField(field);
    }

    @Override
    public boolean matchSingle(StackFrame frame) {
        return this.ruleModeState.matchSingle(frame);
    }

    @Override
    public boolean[] matchRecursive(StackFrame frame) {
        return this.ruleModeState.matchRecursive(frame);
    }

    @Override
    public Object matchManual(StackFrame frame, Object[] values) {
        return this.ruleModeState.matchManual(frame, values);
    }

    @Override
    public boolean matchOne(StackFrame frame, Map<String, Object> valuesMap) {
        for (Rule superRule : this.getESuperRules()) {
            if (superRule.matchOne(frame, valuesMap)) continue;
            return false;
        }
        ExecEnv env = frame.getEnv();
        Object[] values = this.createValuesArray(valuesMap);
        EList<InputRuleElement> inputs = this.getInputElements();
        int index = 0;
        while (index < inputs.size()) {
            CodeBlock binding;
            InputRuleElement re = (InputRuleElement)inputs.get(index);
            Object value = valuesMap.get(re.getName());
            if (value == null) {
                throw new VMException(frame, String.format("Cannot match rule input element %s against null value for %s", re, this));
            }
            EClassifier eType = re.getEType();
            if (eType instanceof EEnum ? !(value instanceof EnumLiteral) : !eType.isInstance(value)) {
                return false;
            }
            EList<Model> inmodels = re.getEModels();
            if (!(inmodels.isEmpty() || value instanceof EObject && inmodels.contains((Object)env.getModelOf((EObject)value)))) {
                return false;
            }
            if (this.distinctState.checkDistinct(values, index, value) && (binding = re.getBinding()) != null) {
                Object bvalue = binding.execute(frame.getSubFrame(binding, values));
                if (bvalue == null) {
                    return false;
                }
                if (bvalue instanceof Collection ? !((Collection)bvalue).contains(value) : !value.equals(bvalue)) {
                    return false;
                }
            }
            ++index;
        }
        return this.matcherCbState.matchFor(frame, values);
    }

    @Override
    public void createTraces(StackFrame frame) {
        this.abstractState.createTraces(frame);
    }

    @Override
    public boolean completeTraceFor(StackFrame frame, TraceLink trace) {
        boolean defaultMappingSet = false;
        ExecEnv env = frame.getEnv();
        int seSize = trace.getSourceElements().size();
        for (OutputRuleElement ore : this.getOutputElements()) {
            EClass type;
            String oreName = ore.getName();
            if (trace.getTargetElement(oreName) != null) continue;
            TargetElement te = TraceFactory.eINSTANCE.createTargetElement();
            te.setName(oreName);
            te.setTargetOf(trace);
            EList teMapsTo = te.getMapsTo();
            for (InputRuleElement source : ore.getMapsTo()) {
                SourceElement mapsTo = trace.getSourceElement(source.getName(), false);
                assert (mapsTo != null);
                teMapsTo.add((Object)mapsTo);
            }
            if (!teMapsTo.isEmpty()) {
                defaultMappingSet |= this.defaultState.createDefaultMapping(env.getTraces(), (EList<SourceElement>)teMapsTo, seSize);
                this.uniqueState.checkAndCreateUniqueMapping(trace.getRule(), (EList<SourceElement>)teMapsTo);
            }
            try {
                type = (EClass)env.findType(ore.getTypeModel(), ore.getType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new VMException(frame);
            }
            EList<Model> models = ore.getEModels();
            assert (models.size() == 1);
            te.setObject(((Model)models.get(0)).newElement(type));
            assert (te.getObject() != null);
            assert (te.getObject().eResource() != null);
            assert (te.getObject().eResource() == ((Model)models.get(0)).getResource());
        }
        for (Rule superRule : this.getESuperRules()) {
            defaultMappingSet |= superRule.completeTraceFor(frame, trace);
        }
        return defaultMappingSet;
    }

    @Override
    public void apply(StackFrame frame) {
        this.abstractState.apply(frame);
    }

    @Override
    public void postApply(StackFrame frame) {
        this.abstractState.postApply(frame);
    }

    @Override
    public boolean applyFirst(StackFrame frame) {
        return this.leafState.applyFirst(frame);
    }

    @Override
    public Object applyFor(StackFrame frame, TraceLink trace) {
        return this.applierCbState.applyFor(frame, trace);
    }

    @Override
    public Object postApplyFor(StackFrame frame, TraceLink trace) {
        return this.applierCbState.postApplyFor(frame, trace);
    }

    @Override
    public LazySet<Rule> getAllESuperRules() {
        if (this.allESuperRules == null) {
            EList<Rule> eSuperRules = this.getESuperRules();
            LazySet<Rule> superRules = new LazySet<Rule>();
            for (Rule rule : eSuperRules) {
                superRules = superRules.union(rule.getAllESuperRules());
            }
            superRules = superRules.union(new LazySet<Rule>((Iterable<Rule>)eSuperRules));
            this.allESuperRules = superRules;
        }
        return this.allESuperRules;
    }

    @Override
    public void createUniqueMapping(TraceLink trace) {
        this.uniqueState.createUniqueMapping(trace);
    }

    @Override
    public void compileState(ExecEnv env) {
        this.updateDefaultState();
        this.updateUniqueState();
        this.updateSuperRulesState();
        this.updateRuleModeState();
        this.updateLeafState();
        this.updateAbstractState();
        this.updateMatcherCbState();
        this.updateApplierCbState();
        this.updateDistinctState();
    }

    @Override
    public void resetState() {
        this.withLeaves = false;
        this.withLeavesSet = false;
        this.leaf = false;
        this.leafSet = false;
        this.allESuperRules = null;
        this.iterableList = null;
        this.iterableMap = null;
        assert (this.applyArgs.isEmpty());
    }

    @Override
    public void compileIterables(ExecEnv env) {
        this.superRulesState.compileIterables(env);
    }

    @Override
    public void clearFields() {
        this.fieldContainer.clear();
    }

    @Override
    public InputRuleElement findInputElement(String name) {
        InputRuleElement ire2;
        for (InputRuleElement ire2 : this.getInputElements()) {
            if (!name.equals(ire2.getName())) continue;
            return ire2;
        }
        ire2 = null;
        Iterator superRules = this.getESuperRules().iterator();
        while (ire2 == null && superRules.hasNext()) {
            ire2 = ((Rule)superRules.next()).findInputElement(name);
        }
        return ire2;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetModule((Module)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getInputElements()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getOutputElements()).basicAdd((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getESuperRules()).basicAdd((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getESubRules()).basicAdd((Object)otherEnd, msgs);
            }
            case 7: {
                if (this.matcher != null) {
                    msgs = ((InternalEObject)this.matcher).eInverseRemove((InternalEObject)this, -8, null, msgs);
                }
                return this.basicSetMatcher((CodeBlock)otherEnd, msgs);
            }
            case 8: {
                if (this.applier != null) {
                    msgs = ((InternalEObject)this.applier).eInverseRemove((InternalEObject)this, -9, null, msgs);
                }
                return this.basicSetApplier((CodeBlock)otherEnd, msgs);
            }
            case 9: {
                if (this.postApply != null) {
                    msgs = ((InternalEObject)this.postApply).eInverseRemove((InternalEObject)this, -10, null, msgs);
                }
                return this.basicSetPostApply((CodeBlock)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getFields()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetModule(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getInputElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getOutputElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getESuperRules()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getESubRules()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return this.basicSetMatcher(null, msgs);
            }
            case 8: {
                return this.basicSetApplier(null, msgs);
            }
            case 9: {
                return this.basicSetPostApply(null, msgs);
            }
            case 12: {
                return ((InternalEList)this.getFields()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 3, Module.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getModule();
            }
            case 2: {
                return this.getMode();
            }
            case 3: {
                return this.getInputElements();
            }
            case 4: {
                return this.getOutputElements();
            }
            case 5: {
                return this.getESuperRules();
            }
            case 6: {
                return this.getESubRules();
            }
            case 7: {
                return this.getMatcher();
            }
            case 8: {
                return this.getApplier();
            }
            case 9: {
                return this.getPostApply();
            }
            case 10: {
                return this.getSuperRules();
            }
            case 11: {
                return this.isAbstract();
            }
            case 12: {
                return this.getFields();
            }
            case 13: {
                return this.isDefault();
            }
            case 14: {
                return this.isDistinctElements();
            }
            case 15: {
                return this.isUnique();
            }
            case 16: {
                return this.isLeaf();
            }
            case 17: {
                return this.isWithLeaves();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setModule((Module)newValue);
                return;
            }
            case 2: {
                this.setMode((RuleMode)((Object)newValue));
                return;
            }
            case 3: {
                this.getInputElements().clear();
                this.getInputElements().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOutputElements().clear();
                this.getOutputElements().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getESuperRules().clear();
                this.getESuperRules().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getESubRules().clear();
                this.getESubRules().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setMatcher((CodeBlock)newValue);
                return;
            }
            case 8: {
                this.setApplier((CodeBlock)newValue);
                return;
            }
            case 9: {
                this.setPostApply((CodeBlock)newValue);
                return;
            }
            case 10: {
                this.getSuperRules().clear();
                this.getSuperRules().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 12: {
                this.getFields().clear();
                this.getFields().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setDefault((Boolean)newValue);
                return;
            }
            case 14: {
                this.setDistinctElements((Boolean)newValue);
                return;
            }
            case 15: {
                this.setUnique((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setModule(null);
                return;
            }
            case 2: {
                this.setMode(MODE_EDEFAULT);
                return;
            }
            case 3: {
                this.getInputElements().clear();
                return;
            }
            case 4: {
                this.getOutputElements().clear();
                return;
            }
            case 5: {
                this.getESuperRules().clear();
                return;
            }
            case 6: {
                this.getESubRules().clear();
                return;
            }
            case 7: {
                this.setMatcher(null);
                return;
            }
            case 8: {
                this.setApplier(null);
                return;
            }
            case 9: {
                this.setPostApply(null);
                return;
            }
            case 10: {
                this.getSuperRules().clear();
                return;
            }
            case 11: {
                this.setAbstract(false);
                return;
            }
            case 12: {
                this.getFields().clear();
                return;
            }
            case 13: {
                this.setDefault(false);
                return;
            }
            case 14: {
                this.setDistinctElements(false);
                return;
            }
            case 15: {
                this.setUnique(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.getModule() != null;
            }
            case 2: {
                return this.mode != MODE_EDEFAULT;
            }
            case 3: {
                return this.inputElements != null && !this.inputElements.isEmpty();
            }
            case 4: {
                return this.outputElements != null && !this.outputElements.isEmpty();
            }
            case 5: {
                return this.eSuperRules != null && !this.eSuperRules.isEmpty();
            }
            case 6: {
                return this.eSubRules != null && !this.eSubRules.isEmpty();
            }
            case 7: {
                return this.matcher != null;
            }
            case 8: {
                return this.applier != null;
            }
            case 9: {
                return this.postApply != null;
            }
            case 10: {
                return this.superRules != null && !this.superRules.isEmpty();
            }
            case 11: {
                return this.abstract_;
            }
            case 12: {
                return this.fields != null && !this.fields.isEmpty();
            }
            case 13: {
                return this.default_;
            }
            case 14: {
                return this.distinctElements;
            }
            case 15: {
                return this.unique;
            }
            case 16: {
                return this.leaf;
            }
            case 17: {
                return this.withLeaves;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer();
        if (this.abstract_) {
            result.append("abstract ");
        }
        result.append("rule ");
        result.append(super.toString());
        return result.toString();
    }

    protected void updateDefaultState() {
        if (this.isDefault()) {
            if (!(this.defaultState instanceof DefaultOnState)) {
                this.defaultState = new DefaultOnState();
            }
        } else if (!(this.defaultState instanceof DefaultOffState)) {
            this.defaultState = new DefaultOffState();
        }
    }

    protected void updateUniqueState() {
        if (this.isUnique()) {
            if (!(this.uniqueState instanceof UniqueOnState)) {
                this.uniqueState = new UniqueOnState();
            }
        } else if (!(this.uniqueState instanceof UniqueOffState)) {
            this.uniqueState = new UniqueOffState();
        }
    }

    protected void updateSuperRulesState() {
        if (this.getESuperRules().isEmpty()) {
            if (!(this.superRulesState instanceof WithoutSuperRulesState)) {
                this.superRulesState = new WithoutSuperRulesState();
            }
        } else if (!(this.superRulesState instanceof WithSuperRulesState)) {
            this.superRulesState = new WithSuperRulesState();
        }
    }

    protected void updateRuleModeState() {
        switch (this.getMode()) {
            case AUTOMATIC_SINGLE: {
                if (this.ruleModeState instanceof AutomaticSingleState) break;
                this.ruleModeState = new AutomaticSingleState();
                break;
            }
            case AUTOMATIC_RECURSIVE: {
                if (this.ruleModeState instanceof AutomaticRecursiveState) break;
                this.ruleModeState = new AutomaticRecursiveState();
                break;
            }
            case MANUAL: {
                if (this.ruleModeState instanceof ManualState) break;
                this.ruleModeState = new ManualState();
            }
        }
    }

    protected void updateLeafState() {
        if (this.isLeaf()) {
            if (!(this.leafState instanceof IsLeafState)) {
                this.leafState = new IsLeafState();
            }
        } else if (this.isWithLeaves()) {
            if (!(this.leafState instanceof IsWithLeavesState)) {
                this.leafState = new IsWithLeavesState();
            }
        } else if (!(this.leafState instanceof IsOtherLeafState)) {
            this.leafState = new IsOtherLeafState();
        }
    }

    protected void updateAbstractState() {
        if (this.isAbstract()) {
            if (!(this.abstractState instanceof IsAbstractState)) {
                this.abstractState = new IsAbstractState();
            }
        } else if (!(this.abstractState instanceof IsNotAbstractState)) {
            this.abstractState = new IsNotAbstractState();
        }
    }

    protected void updateMatcherCbState() {
        if (this.getMatcher() != null) {
            if (!(this.matcherCbState instanceof WithMatcherCbState)) {
                this.matcherCbState = new WithMatcherCbState();
            }
        } else if (!(this.matcherCbState instanceof WithoutMatcherCbState)) {
            this.matcherCbState = new WithoutMatcherCbState();
        }
    }

    protected void updateApplierCbState() {
        if (this.getApplier() != null) {
            if (this.getPostApply() != null) {
                if (!(this.applierCbState instanceof WithApplierWithPostApplyCbState)) {
                    this.applierCbState = new WithApplierWithPostApplyCbState();
                }
            } else if (!(this.applierCbState instanceof WithApplierWithoutPostApplyCbState)) {
                this.applierCbState = new WithApplierWithoutPostApplyCbState();
            }
        } else if (this.getPostApply() != null) {
            if (!(this.applierCbState instanceof WithoutApplierWithPostApplyCbState)) {
                this.applierCbState = new WithoutApplierWithPostApplyCbState();
            }
        } else if (!(this.applierCbState instanceof WithoutApplierWithoutPostApplyCbState)) {
            this.applierCbState = new WithoutApplierWithoutPostApplyCbState();
        }
    }

    protected void updateDistinctState() {
        if (this.isDistinctElements()) {
            if (!(this.distinctState instanceof IsDistinctState)) {
                this.distinctState = new IsDistinctState();
            }
        } else if (!(this.distinctState instanceof IsNotDistinctState)) {
            this.distinctState = new IsNotDistinctState();
        }
    }

    private boolean matchFor(StackFrame frame, Map<String, Object> values, int index, List<TracedRule> superMatches, Map<String, Iterable<EObject>> iterables, Map<TracedRule, TraceLink> currentMatches) {
        boolean result;
        block6: {
            block7: {
                block5: {
                    result = false;
                    int superSize = superMatches.size();
                    if (index >= superSize) break block5;
                    LinkedHashMap<String, Object> newValues = new LinkedHashMap<String, Object>(values);
                    TracedRule tr = superMatches.get(index);
                    block0: for (TraceLink match : tr.getLinks()) {
                        for (SourceElement se : match.getSourceElements()) {
                            String seName = se.getName();
                            EObject seValue = se.getObject();
                            if (values.containsKey(seName)) {
                                if (values.get(seName) == seValue) continue;
                                continue block0;
                            }
                            if (this.isDistinctElements() && values.containsValue(seValue)) continue block0;
                            newValues.put(seName, seValue);
                        }
                        for (RuleElement re : this.getInputElements()) {
                            String reName = re.getName();
                            if (newValues.containsKey(reName) && !re.getEType().isInstance(newValues.get(reName))) continue block0;
                        }
                        currentMatches.put(tr, match);
                        result |= this.matchFor(frame, newValues, index + 1, superMatches, iterables, currentMatches);
                    }
                    break block6;
                }
                if (iterables.isEmpty()) break block7;
                result = this.matchFor(frame, values, iterables, new ArrayList<String>(iterables.keySet()), 0);
                break block6;
            }
            result = this.matchFor(frame, values, this.createValuesArray(values), 0);
            if (!result) break block6;
            for (TraceLink link : currentMatches.values()) {
                link.setOverridden(true);
            }
        }
        return result;
    }

    private boolean matchFor(StackFrame frame, Map<String, Object> values, Map<String, Iterable<EObject>> iterables, List<String> keys, int keyIndex) {
        int size = iterables.size();
        if (keyIndex < size) {
            boolean result = false;
            String key = keys.get(keyIndex);
            assert (!values.containsKey(key));
            for (EObject o : iterables.get(key)) {
                assert (frame.getEnv().getModelOf(o) != null);
                if (this.isDistinctElements() && values.containsValue(o)) continue;
                values.put(key, o);
                result |= this.matchFor(frame, values, iterables, keys, keyIndex + 1);
                values.remove(key);
            }
            return result;
        }
        return this.matchFor(frame, values, this.createValuesArray(values), 0);
    }

    private boolean matchFor(StackFrame frame, Object[] values, int index, List<Iterable<EObject>> iterables) {
        assert (values.length == iterables.size());
        int newIndex = index;
        while (newIndex < values.length && iterables.get(newIndex) == null) {
            ++newIndex;
        }
        if (newIndex < values.length) {
            boolean result = false;
            for (EObject o : iterables.get(newIndex)) {
                assert (frame.getEnv().getModelOf(o) != null);
                if (!this.distinctState.checkDistinct(values, newIndex, o)) continue;
                values[newIndex] = o;
                result |= this.matchFor(frame, values, newIndex + 1, iterables);
                values[newIndex] = null;
            }
            return result;
        }
        return this.matchFor(frame, values, 0);
    }

    private boolean matchFor(StackFrame frame, Object[] values, int index) {
        EList<InputRuleElement> inputs = this.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(frame.getSubFrame(binding, values));
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        boolean result = false;
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || !this.distinctState.checkDistinct(values, values.length - 1, v)) continue;
                            values[index] = v;
                            result |= this.matchFor(frame, values, index + 1);
                            values[index] = null;
                        }
                        return result;
                    }
                    if (!ire.getEType().isInstance(value) || !this.distinctState.checkDistinct(values, values.length - 1, value)) {
                        return false;
                    }
                    values[index] = (EObject)value;
                    boolean result = this.matchFor(frame, values, index + 1);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchFor(frame, values, index + 1);
        }
        return this.uniqueState.matchFor(frame, values);
    }

    private boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values, int index) {
        EList<InputRuleElement> inputs = this.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(frame.getSubFrame(binding, values));
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        String key = ire.getName();
                        boolean result = false;
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || this.isDistinctElements() && valuesMap.containsValue(v)) continue;
                            values[index] = v;
                            valuesMap.put(key, v);
                            result |= this.matchFor(frame, valuesMap, values, index + 1);
                            valuesMap.remove(key);
                            values[index] = null;
                        }
                        return result;
                    }
                    if (!ire.getEType().isInstance(value) || this.isDistinctElements() && valuesMap.containsValue(value)) {
                        return false;
                    }
                    String key = ire.getName();
                    values[index] = (EObject)value;
                    valuesMap.put(key, (EObject)value);
                    boolean result = this.matchFor(frame, valuesMap, values, index + 1);
                    valuesMap.remove(key);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchFor(frame, valuesMap, values, index + 1);
        }
        return this.uniqueState.matchFor(frame, valuesMap, values);
    }

    private boolean matchOneFor(StackFrame frame, Map<String, Object> values, int index, List<TracedRule> superMatches, Map<String, Iterable<EObject>> iterables, Map<TracedRule, TraceLink> currentMatches) {
        int superSize = superMatches.size();
        if (index < superSize) {
            LinkedHashMap<String, Object> newValues = new LinkedHashMap<String, Object>(values);
            TracedRule tr = superMatches.get(index);
            block0: for (TraceLink match : tr.getLinks()) {
                for (SourceElement se : match.getSourceElements()) {
                    String seName = se.getName();
                    EObject seValue = se.getObject();
                    if (values.containsKey(seName)) {
                        if (values.get(seName) == seValue) continue;
                        continue block0;
                    }
                    if (this.isDistinctElements() && values.containsValue(seValue)) continue block0;
                    newValues.put(seName, seValue);
                }
                for (RuleElement re : this.getInputElements()) {
                    String reName = re.getName();
                    if (newValues.containsKey(reName) && !re.getEType().isInstance(newValues.get(reName))) continue block0;
                }
                currentMatches.put(tr, match);
                if (!this.matchOneFor(frame, newValues, index + 1, superMatches, iterables, currentMatches)) continue;
                return true;
            }
            return false;
        }
        if (!iterables.isEmpty()) {
            return this.matchOneFor(frame, values, iterables, new ArrayList<String>(iterables.keySet()), 0);
        }
        boolean result = this.matchOneFor(frame, values, this.createValuesArray(values), 0);
        if (result) {
            for (TraceLink link : currentMatches.values()) {
                link.setOverridden(true);
            }
        }
        return result;
    }

    private boolean matchOneFor(StackFrame frame, Map<String, Object> values, Map<String, Iterable<EObject>> iterables, List<String> keys, int keyIndex) {
        int size = iterables.size();
        if (keyIndex < size) {
            String key = keys.get(keyIndex);
            assert (!values.containsKey(key));
            for (EObject o : iterables.get(key)) {
                assert (frame.getEnv().getModelOf(o) != null);
                if (this.isDistinctElements() && values.containsValue(o)) continue;
                values.put(key, o);
                if (this.matchOneFor(frame, values, iterables, keys, keyIndex + 1)) {
                    values.remove(key);
                    return true;
                }
                values.remove(key);
            }
            return false;
        }
        return this.matchOneFor(frame, values, this.createValuesArray(values), 0);
    }

    private boolean matchOneFor(StackFrame frame, EObject[] values, int index, List<Iterable<EObject>> iterables) {
        assert (values.length == iterables.size());
        int newIndex = index;
        while (newIndex < values.length && iterables.get(newIndex) == null) {
            ++newIndex;
        }
        if (newIndex < values.length) {
            for (EObject o : iterables.get(newIndex)) {
                assert (frame.getEnv().getModelOf(o) != null);
                if (!this.distinctState.checkDistinct(values, newIndex, o)) continue;
                values[newIndex] = o;
                if (this.matchOneFor(frame, values, newIndex + 1, iterables)) {
                    values[newIndex] = null;
                    return true;
                }
                values[newIndex] = null;
            }
            return false;
        }
        return this.matchOneFor(frame, values, 0);
    }

    private boolean matchOneFor(StackFrame frame, EObject[] values, int index) {
        EList<InputRuleElement> inputs = this.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(frame.getSubFrame(binding, values));
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || !this.distinctState.checkDistinct(values, values.length - 1, v)) continue;
                            values[index] = v;
                            if (this.matchOneFor(frame, values, index + 1)) {
                                values[index] = null;
                                return true;
                            }
                            values[index] = null;
                        }
                        return false;
                    }
                    if (!ire.getEType().isInstance(value) || !this.distinctState.checkDistinct(values, values.length - 1, value)) {
                        return false;
                    }
                    values[index] = (EObject)value;
                    boolean result = this.matchOneFor(frame, values, index + 1);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchOneFor(frame, values, index + 1);
        }
        return this.uniqueState.matchFor(frame, values);
    }

    private boolean matchOneFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values, int index) {
        EList<InputRuleElement> inputs = this.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(frame.getSubFrame(binding, values));
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        String key = ire.getName();
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || this.isDistinctElements() && valuesMap.containsValue(v)) continue;
                            values[index] = v;
                            valuesMap.put(key, v);
                            if (this.matchOneFor(frame, valuesMap, values, index + 1)) {
                                values[index] = null;
                                return true;
                            }
                            valuesMap.remove(key);
                            values[index] = null;
                        }
                        return false;
                    }
                    if (!ire.getEType().isInstance(value) || this.isDistinctElements() && valuesMap.containsValue(value)) {
                        return false;
                    }
                    String key = ire.getName();
                    values[index] = (EObject)value;
                    valuesMap.put(key, (EObject)value);
                    boolean result = this.matchOneFor(frame, valuesMap, values, index + 1);
                    valuesMap.remove(key);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchOneFor(frame, valuesMap, values, index + 1);
        }
        return this.uniqueState.matchFor(frame, valuesMap, values);
    }

    private Object[] createValuesArray(Map<String, Object> values) {
        EList<InputRuleElement> allInput = this.getInputElements();
        Object[] valuesArray = new Object[allInput.size()];
        int i = 0;
        for (InputRuleElement re : allInput) {
            valuesArray[i++] = values.get(re.getName());
            assert (this.getMode() == RuleMode.MANUAL || re.getBinding() != null || valuesArray[i - 1] != null);
            assert (this.getMode() == RuleMode.MANUAL || valuesArray[i - 1] == null || re.getEType().isInstance(valuesArray[i - 1]));
        }
        return valuesArray;
    }

    private Map<String, Object> createValuesMap(Object[] values) {
        EList<InputRuleElement> allInput = this.getInputElements();
        HashMap<String, Object> valuesMap = new HashMap<String, Object>(allInput.size());
        assert (allInput.size() == values.length);
        int i = 0;
        for (RuleElement re : allInput) {
            valuesMap.put(re.getName(), values[i++]);
            assert (this.getMode() == RuleMode.MANUAL || values[i - 1] != null);
        }
        return valuesMap;
    }

    private TraceLink createTrace(StackFrame frame, Map<String, Object> values) {
        TraceLinkSet traces = frame.getEnv().getTraces();
        String ruleName = this.getName();
        TracedRule tr = traces.getLinksByRule(ruleName, true);
        TraceLink trace = TraceFactory.eINSTANCE.createTraceLink();
        tr.getLinks().add((Object)trace);
        EList ses = trace.getSourceElements();
        for (Map.Entry<String, Object> v : values.entrySet()) {
            SourceElement se = TraceFactory.eINSTANCE.createSourceElement();
            se.setName(v.getKey());
            se.setRuntimeObject(v.getValue());
            ses.add((Object)se);
        }
        this.createAllUniqueMappings(trace);
        boolean defaultMappingSet = this.completeTraceFor(frame, trace);
        if (!defaultMappingSet) {
            this.defaultState.createDefaultMapping(traces, (EList<SourceElement>)ses);
        }
        return trace;
    }

    private TraceLink createFirstTrace(StackFrame frame) {
        ExecEnv env = frame.getEnv();
        String ruleName = this.getName();
        TracedRule tr = env.getMatches().getLinksByRule(ruleName, false);
        if (tr == null) {
            throw new VMException(frame, String.format("Cannot create a trace for rule %s; no matches exist", this));
        }
        Iterator links = tr.getLinks().iterator();
        while (links.hasNext()) {
            TraceLink trace = (TraceLink)links.next();
            if (trace.isOverridden()) {
                links.remove();
                continue;
            }
            TraceLinkSet traces = env.getTraces();
            TracedRule ntr = traces.getLinksByRule(ruleName, true);
            ntr.getLinks().add((Object)trace);
            this.uniqueState.createUniqueMapping(trace);
            for (Rule rule : this.getAllESuperRules()) {
                rule.createUniqueMapping(trace);
            }
            boolean defaultMappingSet = this.completeTraceFor(frame, trace);
            if (!defaultMappingSet) {
                EList ses = trace.getSourceElements();
                this.defaultState.createDefaultMapping(traces, (EList<SourceElement>)ses);
            }
            return trace;
        }
        return null;
    }

    private Object applyTo(StackFrame frame, TraceLink trace) {
        Object result = null;
        for (Rule rule : this.getAllESuperRules()) {
            if (rule.getApplier() != null) {
                result = rule.applyFor(frame, trace);
            } else {
                rule.applyFor(frame, trace);
            }
            if (rule.getPostApply() != null) {
                result = rule.postApplyFor(frame, trace);
                continue;
            }
            rule.postApplyFor(frame, trace);
        }
        if (this.getApplier() != null) {
            result = this.applierCbState.applyFor(frame, trace);
        } else {
            this.applierCbState.applyFor(frame, trace);
        }
        if (this.getPostApply() != null) {
            result = this.applierCbState.postApplyFor(frame, trace);
        } else {
            this.applierCbState.postApplyFor(frame, trace);
        }
        return result;
    }

    private Object[] createArgs(TraceLink trace) {
        EList<InputRuleElement> input = this.getInputElements();
        EList<OutputRuleElement> output = this.getOutputElements();
        Object[] args = new Object[1 + input.size() + output.size()];
        args[0] = trace;
        int i = 1;
        for (InputRuleElement ire : input) {
            args[i++] = trace.getSourceElement(ire.getName(), false).getRuntimeObject();
            assert (args[i - 1] != null);
        }
        for (OutputRuleElement ore : output) {
            args[i++] = trace.getTargetElement(ore.getName()).getObject();
            assert (args[i - 1] != null);
        }
        assert (i == args.length);
        return args;
    }

    private void createAllUniqueMappings(TraceLink trace) {
        for (Rule rule : this.getAllESuperRules()) {
            rule.createUniqueMapping(trace);
        }
        this.uniqueState.createUniqueMapping(trace);
    }

    protected abstract class AbstractState {
        protected AbstractState() {
        }

        public abstract void createTraces(StackFrame var1);

        public abstract void apply(StackFrame var1);

        public abstract void postApply(StackFrame var1);
    }

    protected abstract class ApplierCbState {
        protected ApplierCbState() {
        }

        public abstract Object applyFor(StackFrame var1, TraceLink var2);

        public abstract Object postApplyFor(StackFrame var1, TraceLink var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AutomaticRecursiveState
    extends RuleModeState {
        protected AutomaticRecursiveState() {
        }

        @Override
        public boolean[] matchRecursive(StackFrame frame) {
            assert (RuleImpl.this.getMode() == RuleMode.AUTOMATIC_RECURSIVE);
            return RuleImpl.this.leafState.matchRecursive(frame);
        }

        @Override
        public boolean matchFor(StackFrame frame, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.AUTOMATIC_RECURSIVE);
            return RuleImpl.this.uniqueState.matchFor(frame, values);
        }

        @Override
        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.AUTOMATIC_RECURSIVE);
            return RuleImpl.this.uniqueState.matchFor(frame, valuesMap, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AutomaticSingleState
    extends RuleModeState {
        protected AutomaticSingleState() {
        }

        @Override
        public boolean matchSingle(StackFrame frame) {
            assert (RuleImpl.this.getMode() == RuleMode.AUTOMATIC_SINGLE);
            return RuleImpl.this.leafState.matchSingle(frame);
        }

        @Override
        public boolean matchFor(StackFrame frame, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.AUTOMATIC_SINGLE);
            return RuleImpl.this.matcherCbState.matchFor(frame, values);
        }

        @Override
        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.AUTOMATIC_SINGLE);
            return RuleImpl.this.matcherCbState.matchFor(frame, valuesMap, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultOffState
    extends DefaultState {
        protected DefaultOffState() {
        }

        @Override
        public void createDefaultMapping(TraceLinkSet traces, EList<SourceElement> ses) {
        }

        @Override
        public boolean createDefaultMapping(TraceLinkSet traces, EList<SourceElement> teMapsTo, int seSize) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultOnState
    extends DefaultState {
        protected DefaultOnState() {
        }

        @Override
        public void createDefaultMapping(TraceLinkSet traces, EList<SourceElement> ses) {
            assert (RuleImpl.this.isDefault());
            if (ses.size() == 1) {
                ((SourceElement)ses.get(0)).setDefaultFor(traces);
            } else {
                SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
                sel.getSourceElements().addAll(ses);
                sel.setDefaultFor(traces);
            }
        }

        @Override
        public boolean createDefaultMapping(TraceLinkSet traces, EList<SourceElement> ses, int seSize) {
            assert (RuleImpl.this.isDefault());
            this.createDefaultMapping(traces, ses);
            return ses.size() == seSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class DefaultState {
        protected DefaultState() {
        }

        public abstract void createDefaultMapping(TraceLinkSet var1, EList<SourceElement> var2);

        public abstract boolean createDefaultMapping(TraceLinkSet var1, EList<SourceElement> var2, int var3);
    }

    protected abstract class DistinctState {
        protected DistinctState() {
        }

        public abstract boolean checkDistinct(Object[] var1, int var2, Object var3);
    }

    protected class IsAbstractState
    extends AbstractState {
        protected IsAbstractState() {
        }

        public void createTraces(StackFrame frame) {
            assert (RuleImpl.this.isAbstract());
        }

        public void apply(StackFrame frame) {
            assert (RuleImpl.this.isAbstract());
        }

        public void postApply(StackFrame frame) {
            assert (RuleImpl.this.isAbstract());
        }
    }

    protected class IsDistinctState
    extends DistinctState {
        protected IsDistinctState() {
        }

        public boolean checkDistinct(Object[] values, int index, Object value) {
            int i = 0;
            while (i < index) {
                if (values[i] == value) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    protected class IsLeafState
    extends LeafState {
        protected IsLeafState() {
        }

        public boolean[] matchRecursive(StackFrame frame) {
            assert (RuleImpl.this.isLeaf());
            if (RuleImpl.this.superRulesState.matchOne(frame)) {
                return new boolean[]{true, true};
            }
            return new boolean[2];
        }

        public boolean applyFirst(StackFrame frame) {
            assert (RuleImpl.this.isLeaf());
            ExecEnv env = frame.getEnv();
            TraceLink trace = RuleImpl.this.createFirstTrace(frame);
            assert (trace != null);
            TraceLinkSet matches = env.getMatches();
            matches.getRules().clear();
            matches.getDefaultSourceElements().clear();
            for (Rule rule : RuleImpl.this.getAllESuperRules()) {
                rule.applyFor(frame, trace);
                rule.postApplyFor(frame, trace);
            }
            RuleImpl.this.applierCbState.applyFor(frame, trace);
            RuleImpl.this.applierCbState.postApplyFor(frame, trace);
            env.deleteQueue();
            return true;
        }
    }

    protected class IsNotAbstractState
    extends AbstractState {
        protected IsNotAbstractState() {
        }

        public void createTraces(StackFrame frame) {
            assert (!RuleImpl.this.isAbstract());
            ExecEnv env = frame.getEnv();
            TracedRule tr = env.getMatches().getLinksByRule(RuleImpl.this.getName(), false);
            if (tr == null) {
                throw new VMException(frame, String.format("Cannot create traces for %s; no matches exist", RuleImpl.this));
            }
            TraceLinkSet traces = env.getTraces();
            traces.getRules().add((Object)tr);
            Iterator links = tr.getLinks().iterator();
            while (links.hasNext()) {
                TraceLink trace = (TraceLink)links.next();
                if (trace.isOverridden()) {
                    links.remove();
                    continue;
                }
                RuleImpl.this.createAllUniqueMappings(trace);
                boolean defaultMappingSet = RuleImpl.this.completeTraceFor(frame, trace);
                if (defaultMappingSet) continue;
                EList ses = trace.getSourceElements();
                RuleImpl.this.defaultState.createDefaultMapping(traces, (EList<SourceElement>)ses);
            }
        }

        public void apply(StackFrame frame) {
            assert (!RuleImpl.this.isAbstract());
            TracedRule tr = frame.getEnv().getTraces().getLinksByRule(RuleImpl.this.getName(), false);
            if (tr == null) {
                throw new VMException(frame, String.format("Cannot apply %s; no traces exist", RuleImpl.this));
            }
            for (TraceLink trace : tr.getLinks()) {
                assert (!trace.isOverridden());
                for (Rule rule : RuleImpl.this.getAllESuperRules()) {
                    rule.applyFor(frame, trace);
                }
                RuleImpl.this.applierCbState.applyFor(frame, trace);
            }
        }

        public void postApply(StackFrame frame) {
            assert (!RuleImpl.this.isAbstract());
            TracedRule tr = frame.getEnv().getTraces().getLinksByRule(RuleImpl.this.getName(), false);
            if (tr == null) {
                throw new VMException(frame, String.format("Cannot post-apply %s; no traces exist", RuleImpl.this));
            }
            for (TraceLink trace : tr.getLinks()) {
                assert (!trace.isOverridden());
                for (Rule rule : RuleImpl.this.getAllESuperRules()) {
                    rule.postApplyFor(frame, trace);
                }
                RuleImpl.this.applierCbState.postApplyFor(frame, trace);
            }
        }
    }

    protected class IsNotDistinctState
    extends DistinctState {
        protected IsNotDistinctState() {
        }

        public boolean checkDistinct(Object[] values, int index, Object value) {
            return true;
        }
    }

    protected class IsOtherLeafState
    extends LeafState {
        protected IsOtherLeafState() {
        }

        public boolean matchSingle(StackFrame frame) {
            assert (!RuleImpl.this.isLeaf() && !RuleImpl.this.isWithLeaves());
            return false;
        }

        public boolean[] matchRecursive(StackFrame frame) {
            assert (!RuleImpl.this.isLeaf() && !RuleImpl.this.isWithLeaves());
            return new boolean[2];
        }
    }

    protected class IsWithLeavesState
    extends LeafState {
        protected IsWithLeavesState() {
        }

        public boolean[] matchRecursive(StackFrame frame) {
            assert (!RuleImpl.this.isLeaf() && RuleImpl.this.isWithLeaves());
            if (RuleImpl.this.superRulesState.match(frame)) {
                boolean[] blArray = new boolean[2];
                blArray[0] = true;
                return blArray;
            }
            return new boolean[2];
        }
    }

    protected abstract class LeafState {
        protected LeafState() {
        }

        public boolean matchSingle(StackFrame frame) {
            return RuleImpl.this.superRulesState.match(frame);
        }

        public abstract boolean[] matchRecursive(StackFrame var1);

        public boolean applyFirst(StackFrame frame) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ManualState
    extends RuleModeState {
        protected ManualState() {
        }

        @Override
        public Object matchManual(StackFrame frame, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.MANUAL);
            return RuleImpl.this.uniqueState.matchManual(frame, values);
        }

        @Override
        public boolean matchFor(StackFrame frame, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.MANUAL);
            throw new VMException(frame, "matchFor(StackFrame, EObject[]) should not be used for manual rules");
        }

        @Override
        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            assert (RuleImpl.this.getMode() == RuleMode.MANUAL);
            throw new VMException(frame, "matchFor(StackFrame, Map<String, EObject>, EObject[]) should not be used for manual rules");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class MatcherCbState {
        protected MatcherCbState() {
        }

        public boolean matchFor(StackFrame frame, Object[] values) {
            TraceLink match = TraceFactory.eINSTANCE.createTraceLink();
            EList ses = match.getSourceElements();
            int i = 0;
            for (InputRuleElement re : RuleImpl.this.getInputElements()) {
                SourceElement se = TraceFactory.eINSTANCE.createSourceElement();
                se.setName(re.getName());
                se.setRuntimeObject(values[i++]);
                se.setMapsToSelf(re.isMapsToSelf());
                ses.add((Object)se);
            }
            frame.getEnv().getMatches().getLinksByRule(RuleImpl.this.getName(), true).getLinks().add((Object)match);
            return true;
        }

        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            TraceLink match = TraceFactory.eINSTANCE.createTraceLink();
            EList ses = match.getSourceElements();
            for (Map.Entry<String, Object> v : valuesMap.entrySet()) {
                SourceElement se = TraceFactory.eINSTANCE.createSourceElement();
                se.setName(v.getKey());
                se.setRuntimeObject(v.getValue());
                InputRuleElement re = RuleImpl.this.findInputElement(v.getKey());
                se.setMapsToSelf(re == null ? false : re.isMapsToSelf());
                ses.add((Object)se);
            }
            frame.getEnv().getMatches().getLinksByRule(RuleImpl.this.getName(), true).getLinks().add((Object)match);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class RuleModeState {
        protected RuleModeState() {
        }

        public boolean matchSingle(StackFrame frame) {
            return false;
        }

        public boolean[] matchRecursive(StackFrame frame) {
            return new boolean[2];
        }

        public Object matchManual(StackFrame frame, Object[] values) {
            throw new VMException(frame, String.format("Rule %s is not a manual rule", this));
        }

        public abstract boolean matchFor(StackFrame var1, Object[] var2);

        public abstract boolean matchFor(StackFrame var1, Map<String, Object> var2, Object[] var3);
    }

    protected abstract class SuperRulesState {
        protected SuperRulesState() {
        }

        public abstract boolean match(StackFrame var1);

        public abstract boolean matchOne(StackFrame var1);

        public abstract void compileIterables(ExecEnv var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueOffState
    extends UniqueState {
        protected UniqueOffState() {
        }

        @Override
        public void createUniqueMapping(TraceLink trace) {
            assert (!RuleImpl.this.isUnique());
        }

        @Override
        public void checkAndCreateUniqueMapping(TracedRule tr, EList<SourceElement> ses) {
            assert (!RuleImpl.this.isUnique());
        }

        @Override
        public Object matchManual(StackFrame frame, Object[] values) {
            assert (!RuleImpl.this.isUnique());
            Map valuesMap = RuleImpl.this.createValuesMap(values);
            if (RuleImpl.this.matchOne(frame, valuesMap)) {
                return RuleImpl.this.applyTo(frame, RuleImpl.this.createTrace(frame, valuesMap));
            }
            return null;
        }

        @Override
        public boolean matchFor(StackFrame frame, Object[] values) {
            assert (!RuleImpl.this.isUnique());
            return RuleImpl.this.matcherCbState.matchFor(frame, values);
        }

        @Override
        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            assert (!RuleImpl.this.isUnique());
            return RuleImpl.this.matcherCbState.matchFor(frame, valuesMap, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueOnState
    extends UniqueState {
        protected UniqueOnState() {
        }

        @Override
        public void createUniqueMapping(TraceLink trace) {
            assert (RuleImpl.this.isUnique());
            TracedRule tr = trace.getRule().getLinkSet().getLinksByRule(RuleImpl.this.getName(), true);
            EList<InputRuleElement> inputElements = RuleImpl.this.getInputElements();
            if (inputElements.size() == 1) {
                trace.getSourceElement(((InputRuleElement)inputElements.get(0)).getName(), false).setUniqueFor(tr);
            } else {
                SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
                EList ses = sel.getSourceElements();
                for (InputRuleElement re : inputElements) {
                    ses.add((Object)trace.getSourceElement(re.getName(), false));
                }
                sel.setUniqueFor(tr);
            }
        }

        @Override
        public void checkAndCreateUniqueMapping(TracedRule tr, EList<SourceElement> ses) {
            assert (RuleImpl.this.isUnique());
            if (ses.size() == 1) {
                SourceElement se = (SourceElement)ses.get(0);
                if (tr.getUniqueSourceElement((Object)se.getObject()) == null) {
                    se.setUniqueFor(tr);
                }
            } else if (tr.getUniqueSourceElements(ses) == null) {
                SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
                sel.getSourceElements().addAll(ses);
                sel.setUniqueFor(tr);
            }
        }

        @Override
        public Object matchManual(StackFrame frame, Object[] values) {
            assert (RuleImpl.this.isUnique());
            Map<TraceLink, Object> uniqueResults = frame.getEnv().getUniqueResults();
            TraceLink trace = this.getUniqueTrace(frame, values);
            if (trace != null) {
                return uniqueResults.get(trace);
            }
            Map valuesMap = RuleImpl.this.createValuesMap(values);
            if (RuleImpl.this.matchOne(frame, valuesMap)) {
                trace = RuleImpl.this.createTrace(frame, valuesMap);
                Object resultValue = RuleImpl.this.applyTo(frame, trace);
                uniqueResults.put(trace, resultValue);
                return resultValue;
            }
            return null;
        }

        @Override
        public boolean matchFor(StackFrame frame, Object[] values) {
            assert (RuleImpl.this.isUnique());
            TracedRule tr = frame.getEnv().getTraces().getLinksByRule(RuleImpl.this.getName(), false);
            if (tr != null && (values.length == 1 ? tr.getUniqueSourceElement(values[0]) != null : tr.getUniqueSourceElements(Arrays.asList(values)) != null)) {
                return false;
            }
            return RuleImpl.this.matcherCbState.matchFor(frame, values);
        }

        @Override
        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            assert (RuleImpl.this.isUnique());
            TracedRule tr = frame.getEnv().getTraces().getLinksByRule(RuleImpl.this.getName(), false);
            if (tr != null && (values.length == 1 ? tr.getUniqueSourceElement(values[0]) != null : tr.getUniqueSourceElements(Arrays.asList(values)) != null)) {
                return false;
            }
            return RuleImpl.this.matcherCbState.matchFor(frame, valuesMap, values);
        }

        private TraceLink getUniqueTrace(StackFrame frame, Object[] values) {
            TracedRule tr = frame.getEnv().getTraces().getLinksByRule(RuleImpl.this.getName(), false);
            if (tr != null) {
                if (values.length == 1) {
                    SourceElement se = tr.getUniqueSourceElement(values[0]);
                    if (se != null) {
                        return se.getSourceOf();
                    }
                } else {
                    SourceElementList sel = tr.getUniqueSourceElements(Arrays.asList(values));
                    if (sel != null) {
                        return ((SourceElement)sel.getSourceElements().get(0)).getSourceOf();
                    }
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class UniqueState {
        protected UniqueState() {
        }

        public abstract void createUniqueMapping(TraceLink var1);

        public abstract void checkAndCreateUniqueMapping(TracedRule var1, EList<SourceElement> var2);

        public abstract boolean matchFor(StackFrame var1, Object[] var2);

        public abstract boolean matchFor(StackFrame var1, Map<String, Object> var2, Object[] var3);

        public abstract Object matchManual(StackFrame var1, Object[] var2);
    }

    protected class WithApplierWithPostApplyCbState
    extends ApplierCbState {
        protected WithApplierWithPostApplyCbState() {
        }

        public Object applyFor(StackFrame frame, TraceLink trace) {
            CodeBlock cb = RuleImpl.this.getApplier();
            assert (cb != null);
            Object[] args = RuleImpl.this.createArgs(trace);
            RuleImpl.this.applyArgs.put(trace, args);
            return cb.execute(frame.getSubFrame(cb, args));
        }

        public Object postApplyFor(StackFrame frame, TraceLink trace) {
            CodeBlock cb = RuleImpl.this.getPostApply();
            assert (cb != null);
            assert (RuleImpl.this.applyArgs.containsKey(trace));
            Object result = cb.execute(frame.getSubFrame(cb, RuleImpl.this.applyArgs.get(trace)));
            RuleImpl.this.applyArgs.remove(trace);
            return result;
        }
    }

    protected class WithApplierWithoutPostApplyCbState
    extends ApplierCbState {
        protected WithApplierWithoutPostApplyCbState() {
        }

        public Object applyFor(StackFrame frame, TraceLink trace) {
            CodeBlock cb = RuleImpl.this.getApplier();
            assert (cb != null);
            return cb.execute(frame.getSubFrame(cb, RuleImpl.this.createArgs(trace)));
        }

        public Object postApplyFor(StackFrame frame, TraceLink trace) {
            assert (RuleImpl.this.getPostApply() == null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WithMatcherCbState
    extends MatcherCbState {
        protected WithMatcherCbState() {
        }

        @Override
        public boolean matchFor(StackFrame frame, Object[] values) {
            CodeBlock cb = RuleImpl.this.getMatcher();
            assert (cb != null);
            if (((Boolean)cb.execute(frame.getSubFrame(cb, values))).booleanValue()) {
                return super.matchFor(frame, values);
            }
            return false;
        }

        @Override
        public boolean matchFor(StackFrame frame, Map<String, Object> valuesMap, Object[] values) {
            CodeBlock cb = RuleImpl.this.getMatcher();
            assert (cb != null);
            if (((Boolean)cb.execute(frame.getSubFrame(cb, values))).booleanValue()) {
                return super.matchFor(frame, valuesMap, values);
            }
            return false;
        }
    }

    protected class WithSuperRulesState
    extends SuperRulesState {
        protected WithSuperRulesState() {
        }

        public boolean match(StackFrame frame) {
            EList<Rule> superRules = RuleImpl.this.getESuperRules();
            assert (!superRules.isEmpty());
            ArrayList<TracedRule> superMatches = new ArrayList<TracedRule>(superRules.size());
            TraceLinkSet matches = frame.getEnv().getMatches();
            for (Rule superRule : superRules) {
                TracedRule superMatch = matches.getLinksByRule(superRule.getName(), false);
                assert (superMatch != null);
                superMatches.add(superMatch);
            }
            return RuleImpl.this.matchFor(frame, new LinkedHashMap(RuleImpl.this.getInputElements().size()), 0, superMatches, RuleImpl.this.iterableMap, new LinkedHashMap(superRules.size()));
        }

        public boolean matchOne(StackFrame frame) {
            EList<Rule> superRules = RuleImpl.this.getESuperRules();
            assert (!superRules.isEmpty());
            ArrayList<TracedRule> superMatches = new ArrayList<TracedRule>(superRules.size());
            TraceLinkSet matches = frame.getEnv().getMatches();
            for (Rule superRule : superRules) {
                TracedRule superMatch = matches.getLinksByRule(superRule.getName(), false);
                assert (superMatch != null);
                superMatches.add(superMatch);
            }
            return RuleImpl.this.matchOneFor(frame, new LinkedHashMap(RuleImpl.this.getInputElements().size()), 0, superMatches, RuleImpl.this.iterableMap, new HashMap(superRules.size()));
        }

        public void compileIterables(ExecEnv env) {
            HashSet<String> superRuleElementNames = new HashSet<String>();
            for (Rule rule : RuleImpl.this.getAllESuperRules()) {
                for (RuleElement re : rule.getInputElements()) {
                    superRuleElementNames.add(re.getName());
                }
            }
            LinkedHashMap<String, Iterable<EObject>> iterables = new LinkedHashMap<String, Iterable<EObject>>();
            for (InputRuleElement re : RuleImpl.this.getInputElements()) {
                String name = re.getName();
                if (superRuleElementNames.contains(name) || re.getBinding() != null) continue;
                iterables.put(name, re.createIterable(env));
            }
            RuleImpl.this.iterableMap = iterables;
            RuleImpl.this.iterableList = null;
        }
    }

    protected class WithoutApplierWithPostApplyCbState
    extends ApplierCbState {
        protected WithoutApplierWithPostApplyCbState() {
        }

        public Object applyFor(StackFrame frame, TraceLink trace) {
            assert (RuleImpl.this.getApplier() == null);
            return null;
        }

        public Object postApplyFor(StackFrame frame, TraceLink trace) {
            CodeBlock cb = RuleImpl.this.getPostApply();
            assert (cb != null);
            return cb.execute(frame.getSubFrame(cb, RuleImpl.this.createArgs(trace)));
        }
    }

    protected class WithoutApplierWithoutPostApplyCbState
    extends ApplierCbState {
        protected WithoutApplierWithoutPostApplyCbState() {
        }

        public StackFrame applyFor(StackFrame frame, TraceLink trace) {
            assert (RuleImpl.this.getApplier() == null);
            return null;
        }

        public StackFrame postApplyFor(StackFrame frame, TraceLink trace) {
            assert (RuleImpl.this.getPostApply() == null);
            return null;
        }
    }

    protected class WithoutMatcherCbState
    extends MatcherCbState {
        protected WithoutMatcherCbState() {
        }
    }

    protected class WithoutSuperRulesState
    extends SuperRulesState {
        protected WithoutSuperRulesState() {
        }

        public boolean match(StackFrame frame) {
            assert (RuleImpl.this.getESuperRules().isEmpty());
            return RuleImpl.this.matchFor(frame, new EObject[RuleImpl.this.iterableList.size()], 0, RuleImpl.this.iterableList);
        }

        public boolean matchOne(StackFrame frame) {
            assert (RuleImpl.this.getESuperRules().isEmpty());
            return RuleImpl.this.matchOneFor(frame, new EObject[RuleImpl.this.iterableList.size()], 0, RuleImpl.this.iterableList);
        }

        public void compileIterables(ExecEnv env) {
            assert (RuleImpl.this.getESuperRules().isEmpty());
            EList<InputRuleElement> allInputs = RuleImpl.this.getInputElements();
            ArrayList<Iterable<EObject>> iterables = new ArrayList<Iterable<EObject>>(allInputs.size());
            for (InputRuleElement re : allInputs) {
                if (re.getBinding() != null) {
                    iterables.add(null);
                    continue;
                }
                iterables.add(re.createIterable(env));
            }
            RuleImpl.this.iterableList = iterables;
            RuleImpl.this.iterableMap = null;
        }
    }
}

