/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.EditorInputUtils;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ParserScheduler
extends Job {
    private final IParseController fParseController;
    private final IEditorPart fEditorPart;
    private final IDocumentProvider fDocumentProvider;
    private final IMessageHandler fMsgHandler;
    private final List<IModelListener> fAstListeners = new ArrayList<IModelListener>();

    public ParserScheduler(IParseController parseController, IEditorPart editorPart, IDocumentProvider docProvider, IMessageHandler msgHandler) {
        super(String.valueOf(LanguageRegistry.findLanguage(EditorInputUtils.getPath(editorPart.getEditorInput()), null).getName()) + " ParserScheduler for " + editorPart.getEditorInput().getName());
        this.setSystem(true);
        this.fParseController = parseController;
        this.fEditorPart = editorPart;
        this.fDocumentProvider = docProvider;
        this.fMsgHandler = msgHandler;
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.fParseController == null || this.fDocumentProvider == null) {
            return Status.OK_STATUS;
        }
        IEditorInput editorInput = this.fEditorPart.getEditorInput();
        try {
            IDocument document = this.fDocumentProvider.getDocument((Object)editorInput);
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Parsing language " + this.fParseController.getLanguage().getName() + " for input " + editorInput.getName());
            }
            this.fMsgHandler.clearMessages();
            this.fParseController.parse(document.get(), false, monitor);
            if (!monitor.isCanceled()) {
                this.notifyModelListeners(monitor);
            }
        }
        catch (Exception e) {
            ErrorHandler.reportError("Error running parser for language " + this.fParseController.getLanguage().getName() + " and input " + editorInput.getName() + ":", e);
            this.notifyModelListeners(monitor);
        }
        return Status.OK_STATUS;
    }

    public void addModelListener(IModelListener listener) {
        this.fAstListeners.add(listener);
    }

    public void notifyModelListeners(IProgressMonitor monitor) {
        if (this.fParseController != null) {
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Notifying AST listeners of change in " + this.fParseController.getPath().toPortableString());
            }
            int n = this.fAstListeners.size() - 1;
            while (n >= 0 && !monitor.isCanceled()) {
                IModelListener listener = this.fAstListeners.get(n);
                int analysisLevel = IModelListener.AnalysisRequired.POINTER_ANALYSIS.level();
                if (this.fParseController.getCurrentAst() == null) {
                    analysisLevel = IModelListener.AnalysisRequired.LEXICAL_ANALYSIS.level();
                }
                if (listener.getAnalysisRequired().level() <= analysisLevel) {
                    listener.update(this.fParseController, monitor);
                }
                --n;
            }
        } else if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("No AST; bypassing listener notification.");
        }
    }
}

