/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.imp.preferences.IPreferencesService;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private IProject project = null;
    private String projectName = null;
    private String languageName = null;
    org.eclipse.core.runtime.preferences.IPreferencesService preferencesService = null;
    IEclipsePreferences preferencesRoot = null;
    private ProjectScope projectScope = null;
    private ConfigurationScope configurationScope = new ConfigurationScope();
    private InstanceScope instanceScope = new InstanceScope();
    private DefaultScope defaultScope = new DefaultScope();
    private static final Map<String, ConstantEvaluator> sConstantMap = new HashMap<String, ConstantEvaluator>();
    private static final Map<String, ParamEvaluator> sParamMap;
    private static final Pattern sSimpleSubstRegexp;
    private static final Pattern sParamSubstRegexp;
    public static final String[] levels;
    private List projectSelectionListeners = new ArrayList();

    static {
        sConstantMap.put("workspaceLoc", new ConstantEvaluator(){

            public String getValue() {
                return ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
            }
        });
        sConstantMap.put("os", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getOS();
            }
        });
        sConstantMap.put("arch", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getOSArch();
            }
        });
        sConstantMap.put("nl", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getNL();
            }
        });
        sConstantMap.put("ws", new ConstantEvaluator(){

            public String getValue() {
                return Platform.getWS();
            }
        });
        sParamMap = new HashMap<String, ParamEvaluator>();
        sParamMap.put("pluginLoc", new ParamEvaluator(){

            public String getValue(String pluginID) {
                Bundle bundle = Platform.getBundle((String)pluginID);
                if (bundle == null) {
                    return "<no such plugin: " + pluginID + ">";
                }
                try {
                    String bundleLoc = FileLocator.toFileURL((URL)bundle.getEntry("")).getFile();
                    return bundleLoc;
                }
                catch (IOException iOException) {
                    return "<error determining location of plugin: " + pluginID + ">";
                }
            }
        });
        sParamMap.put("pluginResource", new ParamEvaluator(){

            public String getValue(String pluginResourceLoc) {
                int idx = pluginResourceLoc.indexOf(47);
                if (idx <= 0) {
                    return "<error in pluginResource specification: no plugin ID found: " + pluginResourceLoc + ">";
                }
                String pluginID = pluginResourceLoc.substring(0, idx);
                String resourcePath = pluginResourceLoc.substring(idx + 1);
                Bundle bundle = Platform.getBundle((String)pluginID);
                if (bundle == null) {
                    return "<no such plugin: " + pluginID + ">";
                }
                try {
                    Bundle[] fragments;
                    URL resourceEntry = bundle.getEntry(resourcePath);
                    if (resourceEntry == null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
                        int i = 0;
                        while (i < fragments.length) {
                            Bundle bundleFrag = fragments[i];
                            resourceEntry = bundleFrag.getEntry(resourcePath);
                            if (resourceEntry != null) break;
                            ++i;
                        }
                    }
                    if (resourceEntry == null) {
                        return "<error: no resource '" + resourcePath + "' in plugin " + pluginID + " or its fragments>";
                    }
                    String resourceLoc = FileLocator.toFileURL((URL)resourceEntry).getFile();
                    return resourceLoc;
                }
                catch (IOException iOException) {
                    return "<error determining location of plugin: " + pluginID + ">";
                }
            }
        });
        sParamMap.put("pluginVersion", new ParamEvaluator(){

            public String getValue(String pluginID) {
                Bundle bundle = Platform.getBundle((String)pluginID);
                if (bundle == null) {
                    return "<no such plugin: " + pluginID + ">";
                }
                return (String)bundle.getHeaders().get("Bundle-Version");
            }
        });
        sParamMap.put("projectLoc", new ParamEvaluator(){

            public String getValue(String projectName) {
                IProject project = PreferencesService.getProjectFromName(projectName);
                if (project == null) {
                    return "<no such project: " + projectName + ">";
                }
                return project.getLocation().toPortableString();
            }
        });
        sSimpleSubstRegexp = Pattern.compile("\\$\\{([a-zA-Z][a-zA-Z0-9_]*)\\}");
        sParamSubstRegexp = Pattern.compile("\\$\\{([a-zA-Z][a-zA-Z0-9_]*):([^}]+)\\}");
        levels = new String[]{"project", "instance", "configuration", "default"};
    }

    public PreferencesService() {
        this.getPreferencesServiceAndRoot();
    }

    public PreferencesService(String projectName) {
        this();
        this.setProjectName(projectName);
    }

    public PreferencesService(IProject project) {
        this();
        this.setProject(project);
    }

    public PreferencesService(IProject project, String languageName) {
        this(project);
        this.setLanguageName(languageName);
    }

    private void getPreferencesServiceAndRoot() {
        this.preferencesService = Platform.getPreferencesService();
        this.preferencesRoot = this.preferencesService.getRootNode();
    }

    private static IProject getProjectFromName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(name);
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setProjectName(String projectName) {
        if (projectName == null || projectName.equals("")) {
            System.out.println("PreferencesService.setProjectName:  name is null or empty; clearing project, project name, and project scope");
        }
        if (projectName.equals("")) {
            projectName = null;
        }
        this.projectName = projectName;
        this.project = PreferencesService.getProjectFromName(projectName);
        if (this.project != null) {
            ProjectScope oldProjectScope = this.projectScope;
            this.projectScope = new ProjectScope(this.project);
            this.toggleProject(oldProjectScope, this.projectScope, projectName);
        } else {
            this.projectScope = null;
        }
    }

    private void toggleProject(ProjectScope oldProjectScope, ProjectScope newProjectScope, String projectName) {
        IPreferencesService.ProjectSelectionEvent event = null;
        if (projectName == null) {
            event = new IPreferencesService.ProjectSelectionEvent(null, null);
        } else if (oldProjectScope == null && newProjectScope == null) {
            event = new IPreferencesService.ProjectSelectionEvent(null, null);
        } else if (oldProjectScope == null && newProjectScope != null) {
            event = new IPreferencesService.ProjectSelectionEvent(null, (Preferences)newProjectScope.getNode(projectName));
        } else if (oldProjectScope != null && newProjectScope == null) {
            event = new IPreferencesService.ProjectSelectionEvent((Preferences)oldProjectScope.getNode(projectName), null);
        } else if (oldProjectScope != null && newProjectScope != null) {
            event = new IPreferencesService.ProjectSelectionEvent((Preferences)oldProjectScope.getNode(projectName), (Preferences)newProjectScope.getNode(projectName));
        }
        this.fireProjectSelectionEvent(event);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProject(IProject project) {
        ProjectScope oldProjectScope = this.projectScope;
        this.project = project;
        if (project != null) {
            this.projectName = project.getName();
            this.projectScope = new ProjectScope(project);
        } else {
            this.projectName = null;
            this.projectScope = null;
        }
        this.toggleProject(oldProjectScope, this.projectScope, this.projectName);
    }

    public IProject getProject() {
        return this.project;
    }

    public IEclipsePreferences getPreferences(String level) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is not valid (level = " + level);
        }
        IEclipsePreferences preferences = null;
        if (level.equals("project")) {
            if (this.projectScope != null && this.languageName != null) {
                preferences = this.projectScope.getNode(this.languageName);
            }
        } else if (level.equals("instance")) {
            preferences = this.instanceScope.getNode(this.languageName);
        } else if (level.equals("configuration")) {
            preferences = this.configurationScope.getNode(this.languageName);
        } else if (level.equals("default")) {
            preferences = this.defaultScope.getNode(this.languageName);
        }
        return preferences;
    }

    public void setPreferences(String level, IEclipsePreferences newPreferences) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getPreferences:  given level is not valid (level = " + level);
        }
        IEclipsePreferences node = this.clearPreferencesAtLevel(level);
        if (newPreferences == null) {
            return;
        }
        String[] keys = null;
        try {
            keys = newPreferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setPreferences():  BackingStoreException getting keys; returning (note:  preferences for this node may have been cleared)");
            return;
        }
        int i = 0;
        while (i < keys.length) {
            String val = newPreferences.get(keys[i], null);
            node.put(keys[i], val);
            ++i;
        }
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setPreferences():  BackingStoreException flushing new preferences; returning (note:  preferences for this node may have been cleared and not set)");
            return;
        }
    }

    private IScopeContext[] specificProjectScope() {
        if (this.projectScope == null) {
            return new IScopeContext[0];
        }
        return new IScopeContext[]{this.getScopeForLevel("project")};
    }

    public boolean getBooleanPreference(String key) {
        return this.preferencesService.getBoolean(this.languageName, key, false, this.specificProjectScope());
    }

    public byte[] getByteArrayPreference(String key) {
        byte[] result = null;
        String[] lookupOrder = this.preferencesService.getLookupOrder(this.languageName, key);
        String[] levels = IPreferencesService.levels;
        int i = 0;
        block0: while (i < lookupOrder.length) {
            int j = 0;
            while (j < levels.length) {
                IScopeContext context;
                IEclipsePreferences node;
                String level = null;
                if (levels[j].startsWith(lookupOrder[i].toUpperCase()) && (result = (node = (context = this.getScopeForLevel(level = levels[j])).getNode(this.languageName)).getByteArray(key, new byte[0])).length != 0) break block0;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public double getDoublePreference(String key) {
        return this.preferencesService.getDouble(this.languageName, key, 0.0, this.specificProjectScope());
    }

    public float getFloatPreference(String key) {
        return this.preferencesService.getFloat(this.languageName, key, 0.0f, this.specificProjectScope());
    }

    public int getIntPreference(String key) {
        return this.preferencesService.getInt(this.languageName, key, 0, this.specificProjectScope());
    }

    public long getLongPreference(String key) {
        return this.preferencesService.getLong(this.languageName, key, 0L, this.specificProjectScope());
    }

    public String getStringPreference(String key) {
        String result = this.preferencesService.getString(this.languageName, key, null, this.specificProjectScope());
        return this.performSubstitutions(result);
    }

    public String getRawStringPreference(String key) {
        String result = this.preferencesService.getString(this.languageName, key, null, this.specificProjectScope());
        return result;
    }

    public boolean getBooleanPreference(IProject project, String key) {
        return this.preferencesService.getBoolean(this.languageName, key, false, new IScopeContext[]{new ProjectScope(project)});
    }

    public byte[] getByteArrayPreference(IProject project, String key) {
        byte[] result = null;
        String[] lookupOrder = this.preferencesService.getLookupOrder(this.languageName, key);
        String[] levels = IPreferencesService.levels;
        int i = 0;
        block0: while (i < lookupOrder.length) {
            int j = 0;
            while (j < levels.length) {
                String level = null;
                if (levels[j].startsWith(lookupOrder[i].toUpperCase())) {
                    level = levels[j];
                    IScopeContext context = null;
                    context = level.equals("project") ? this.getScopeForProject(project) : this.getScopeForLevel(level);
                    IEclipsePreferences node = context.getNode(this.languageName);
                    result = node.getByteArray(key, new byte[0]);
                    if (result.length != 0) break block0;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public double getDoublePreference(IProject project, String key) {
        return this.preferencesService.getDouble(this.languageName, key, 0.0, new IScopeContext[]{new ProjectScope(project)});
    }

    public float getFloatPreference(IProject project, String key) {
        return this.preferencesService.getFloat(this.languageName, key, 0.0f, new IScopeContext[]{new ProjectScope(project)});
    }

    public int getIntPreference(IProject project, String key) {
        return this.preferencesService.getInt(this.languageName, key, 0, new IScopeContext[]{new ProjectScope(project)});
    }

    public long getLongPreference(IProject project, String key) {
        return this.preferencesService.getLong(this.languageName, key, 0L, new IScopeContext[]{new ProjectScope(project)});
    }

    public String getRawStringPreference(IProject project, String key) {
        return this.preferencesService.getString(this.languageName, key, null, new IScopeContext[]{new ProjectScope(project)});
    }

    public String getStringPreference(IProject project, String key) {
        String value = this.getRawStringPreference(project, key);
        String result = this.performSubstitutions(value, project);
        return result;
    }

    public String performSubstitutions(String value) {
        return this.performSubstitutions(value, null);
    }

    public String performSubstitutions(String value, IProject project) {
        if (value == null) {
            return value;
        }
        while (true) {
            Matcher pm;
            if ((pm = sParamSubstRegexp.matcher(value)).find(0)) {
                String id = pm.group(1);
                String param = pm.group(2);
                ParamEvaluator e = sParamMap.get(id);
                String prefValue = e != null ? e.getValue(param) : "<no such preference: " + id + ">";
                value = String.valueOf(value.substring(0, pm.start())) + prefValue + value.substring(pm.end());
                continue;
            }
            Matcher sm = sSimpleSubstRegexp.matcher(value);
            if (!sm.find(0)) break;
            String id = sm.group(1);
            String prefValue = sConstantMap.containsKey(id) ? sConstantMap.get(id).getValue() : (project != null ? this.getStringPreference(project, id) : this.getStringPreference(id));
            value = String.valueOf(value.substring(0, sm.start())) + prefValue + value.substring(sm.end());
        }
        return value;
    }

    public boolean getBooleanPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        boolean result = node.getBoolean(key, false);
        return result;
    }

    public byte[] getByteArrayPreference(String level, String key) {
        IScopeContext context = this.getScopeForLevel(level);
        IEclipsePreferences node = context.getNode(this.languageName);
        byte[] result = node.getByteArray(key, new byte[0]);
        return result;
    }

    public double getDoublePreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        double result = node.getDouble(key, 0.0);
        return result;
    }

    public float getFloatPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        float result = node.getFloat(key, 0.0f);
        return result;
    }

    public int getIntPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        int result = node.getInt(key, 0);
        return result;
    }

    public long getLongPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        long result = node.getLong(key, 0L);
        return result;
    }

    public String getStringPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return this.performSubstitutions(result);
    }

    public String getRawStringPreference(String level, String key) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return result;
    }

    public boolean getBooleanPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        boolean result = node.getBoolean(key, false);
        return result;
    }

    public byte[] getByteArrayPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        byte[] result = node.getByteArray(key, new byte[0]);
        return result;
    }

    public double getDoublePreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        double result = node.getDouble(key, 0.0);
        return result;
    }

    public float getFloatPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        float result = node.getFloat(key, 0.0f);
        return result;
    }

    public int getIntPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        int result = node.getInt(key, 0);
        return result;
    }

    public long getLongPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        long result = node.getLong(key, 0L);
        return result;
    }

    public String getStringPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return this.performSubstitutions(result, project);
    }

    public String getRawStringPreferenceForProject(IProject project, String key) {
        IScopeContext scope = this.getScopeForProject(project);
        IEclipsePreferences node = scope.getNode(this.languageName);
        String result = node.get(key, null);
        return result;
    }

    public void setBooleanPreference(String level, String key, boolean value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putBoolean(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setByteArrayPreference(String, String, boolean):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setByteArrayPreference(String level, String key, byte[] value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putByteArray(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setByteArrayPreference(String, String, byte[]):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setDoublePreference(String level, String key, double value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putDouble(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setDoublePreference(String, String, double):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setFloatPreference(String level, String key, float value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putFloat(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setFloatPreference(String, String, float):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setIntPreference(String level, String key, int value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putInt(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setIntPreference(String, String, int):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setLongPreference(String level, String key, long value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.putLong(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.set\tLongPreference(String, String, long):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setStringPreference(String level, String key, String value) {
        IScopeContext scope = this.getScopeForLevel(level);
        IEclipsePreferences node = scope.getNode(this.languageName);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setStringPreference(String, String, String):  BackingStoreException");
            System.out.println("\tlevel = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public boolean getBooleanPreference(String languageName, String projectName, String level, String key, boolean def) {
        IEclipsePreferences node = this.getNodeForParameters("getBooleanPreference", languageName, level, projectName, key);
        return node.getBoolean(key, def);
    }

    public byte[] getByteArrayPreference(String languageName, String projectName, String level, String key, byte[] def) {
        IEclipsePreferences node = this.getNodeForParameters("getByteArrayPreference", languageName, level, projectName, key);
        return node.getByteArray(key, def);
    }

    public double getDoublePreference(String languageName, String projectName, String level, String key, double def) {
        IEclipsePreferences node = this.getNodeForParameters("getDoublePreference", languageName, level, projectName, key);
        return node.getDouble(key, def);
    }

    public float getFloatPreference(String languageName, String projectName, String level, String key, float def) {
        IEclipsePreferences node = this.getNodeForParameters("getFloatPreference", languageName, level, projectName, key);
        return node.getFloat(key, def);
    }

    public int getIntPreference(String languageName, String projectName, String level, String key, int def) {
        IEclipsePreferences node = this.getNodeForParameters("getIntPreference", languageName, level, projectName, key);
        return node.getInt(key, def);
    }

    public long getLongPreference(String languageName, String projectName, String level, String key, long def) {
        IEclipsePreferences node = this.getNodeForParameters("getLongPreference", languageName, level, projectName, key);
        return node.getLong(key, def);
    }

    public String getStringPreference(String languageName, String projectName, String level, String key, String def) {
        IEclipsePreferences node = this.getNodeForParameters("getStringPreference", languageName, level, projectName, key);
        return this.performSubstitutions(node.get(key, def), PreferencesService.getProjectFromName(projectName));
    }

    public String getRawStringPreference(String languageName, String projectName, String level, String key, String def) {
        IEclipsePreferences node = this.getNodeForParameters("getRawStringPreference", languageName, level, projectName, key);
        return node.get(key, def);
    }

    public void setBooleanPreference(String languageName, String projectName, String level, String key, boolean value) {
        IEclipsePreferences node = this.getNodeForParameters("setBooleanPreference", languageName, level, projectName, key);
        node.putBoolean(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setBooleanPreference(String, String, String, String, boolean):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setByteArrayPreference(String languageName, String projectName, String level, String key, byte[] value) {
        IEclipsePreferences node = this.getNodeForParameters("setByteArrayPreference", languageName, level, projectName, key);
        node.putByteArray(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setByteArrayPreference(String, String, String, String, byte[]):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setDoublePreference(String languageName, String projectName, String level, String key, double value) {
        IEclipsePreferences node = this.getNodeForParameters("setDoublePreference", languageName, level, projectName, key);
        node.putDouble(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setDoublePreference(String, String, String, String, double):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setFloatPreference(String languageName, String projectName, String level, String key, float value) {
        IEclipsePreferences node = this.getNodeForParameters("setFloatPreference", languageName, level, projectName, key);
        node.putFloat(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setFloatPreference(String, String, String, String, float):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setIntPreference(String languageName, String projectName, String level, String key, int value) {
        IEclipsePreferences node = this.getNodeForParameters("setIntPreference", languageName, level, projectName, key);
        node.putInt(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setIntPreference(String, String, String, String, int):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setLongPreference(String languageName, String projectName, String level, String key, long value) {
        IEclipsePreferences node = this.getNodeForParameters("setLongPreference", languageName, level, projectName, key);
        node.putLong(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setLongPreference(String, String, String, String, long):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public void setStringPreference(String languageName, String projectName, String level, String key, String value) {
        IEclipsePreferences node = this.getNodeForParameters("setStringPreference", languageName, level, projectName, key);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setStringPreference(String, String, String, String, String):  BackingStoreException");
            System.out.println("\tlanguage = " + languageName + "; project = " + projectName + "; level = " + level + "; key = " + key + "; value = " + value);
        }
    }

    public IScopeContext getPreferencesScope(String level, IProject proj) {
        if (level.equals("configuration")) {
            return this.configurationScope;
        }
        if (level.equals("instance")) {
            return this.instanceScope;
        }
        if (level.equals("default")) {
            return this.defaultScope;
        }
        if (level.equals("project")) {
            return new ProjectScope(proj);
        }
        return null;
    }

    public void validateParameters(String methodName, String languageName, String level, String projectName, String key) {
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService." + methodName + ":  given level is not a valid preferences level:  " + level);
        }
        if (languageName == null || languageName.equals("")) {
            throw new IllegalArgumentException("PreferencesService." + methodName + ":  given language name is null or empty");
        }
        if (level.equals("project")) {
            if (projectName == null || projectName.equals("")) {
                throw new IllegalArgumentException("PreferencesService." + methodName + ":  level is 'project' but project name is null or empty");
            }
            IProject proj = PreferencesService.getProjectFromName(projectName);
            if (proj == null) {
                throw new IllegalArgumentException("PreferencesService." + methodName + ":  level is 'project' but project name '" + projectName + "' does not denote an existing project");
            }
        }
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("PreferencesService.setStringPreference:  key is null or empty");
        }
    }

    public IEclipsePreferences getNodeForParameters(String methodName, String languageName, String level, String projectName, String key) {
        this.validateParameters(methodName, languageName, level, projectName, key);
        IProject proj = PreferencesService.getProjectFromName(projectName);
        IScopeContext scope = this.getPreferencesScope(level, proj);
        if (scope == null) {
            throw new IllegalStateException("PreferencesService." + methodName + ":  unable to obtain valid preferences scope");
        }
        IEclipsePreferences node = scope.getNode(languageName);
        if (node == null) {
            throw new IllegalStateException("PreferencesService." + methodName + ":  unable to obtain valid preferences node");
        }
        return node;
    }

    public IEclipsePreferences clearPreferencesAtLevel(String level) {
        return this.clearPreferencesAtLevel(this.project, level);
    }

    public IEclipsePreferences clearPreferencesAtLevel(IProject project, String level) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.clearPreferencesAtLevel (with project):  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.clearPreferencesAtLevel (with project):  given level '" + level + "' is not a valid level");
        }
        if (project == null && level.equals("project")) {
            return null;
        }
        IEclipsePreferences node = null;
        try {
            if (level.equals("project") && this.projectScope != null) {
                node = this.projectScope.getNode(this.languageName);
            } else if (level.equals("instance")) {
                node = this.instanceScope.getNode(this.languageName);
            } else if (level.equals("configuration")) {
                node = this.configurationScope.getNode(this.languageName);
            } else if (level.equals("default")) {
                node = this.defaultScope.getNode(this.languageName);
            }
            if (node != null) {
                String[] keys = node.keys();
                int i = 0;
                while (i < keys.length) {
                    node.remove(keys[i]);
                    ++i;
                }
                node.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("PreferencesService.setPreferences():  BackingStoreException clearing existing preferences; attempting to add new preferences anyway");
        }
        return node;
    }

    public String clearPreferenceAtLevel(String level, String key) {
        return this.clearPreferenceAtLevel(this.project, level, key);
    }

    public String clearPreferenceAtLevel(IProject project, String level, String key) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.clearPreferenceAtLevel (with project):  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.clearPreferenceAtLevel (with project):  given level '" + level + "' is not a valid level");
        }
        if (project == null && level.equals("project")) {
            throw new IllegalStateException("PreferencesService.clearPreferenceAtLevel (with project): given project is null when given level is 'project'");
        }
        IScopeContext context = null;
        context = level.equals("project") ? this.getScopeForProject(project) : this.getScopeForLevel(level);
        IEclipsePreferences node = context.getNode(this.languageName);
        if (node == null) {
            return null;
        }
        String preference = node.get(key, null);
        node.remove(key);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println("PreferencesService.clearPreferenceAtLevel(..):  BackingStoreException trying to flush node with cleared preference;\n\tproject = " + project + "; level = " + level + "; key = " + key + "\n" + "\tclearing may not have a persistent effect");
        }
        return preference;
    }

    public int indexForLevel(String levelName) {
        int i = 0;
        while (i < levels.length) {
            if (levels[i].equals(levelName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getApplicableLevel(String key, String level) {
        return this.getApplicableLevel(this.project, key, level);
    }

    public String getApplicableLevel(IProject project, String key, String level) {
        int startIndex;
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getApplicableLevel (with project):  given level '" + level + "' is not a real level");
        }
        if (key == null) {
            throw new IllegalArgumentException("PreferencesService.getApplicableLevel (with project):  given key is null");
        }
        if (level.equals("project") && this.projectScope == null) {
            throw new IllegalStateException("PreferencesService.getApplicableLevel (with project):  node for project requested when project scope is null");
        }
        int n = startIndex = level == null ? 0 : this.getIndexForLevel(level);
        if (startIndex == 0) {
            String[] keys;
            IScopeContext context = this.getScopeForProject(project);
            IEclipsePreferences node = context.getNode(this.languageName);
            try {
                keys = node.keys();
            }
            catch (BackingStoreException backingStoreException) {
                keys = new String[]{};
            }
            int i = 0;
            while (i < keys.length) {
                if (keys[i].equals(key)) {
                    return "project";
                }
                ++i;
            }
            ++startIndex;
        }
        int i = startIndex;
        while (i < levels.length) {
            String pref = this.getStringPreference(levels[i], key);
            if (pref != null) {
                return levels[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isDefault(String key, String level) {
        return this.isDefault(this.project, key, level);
    }

    public boolean isDefault(IProject project, String key, String level) {
        return "default".equals(this.getApplicableLevel(project, key, level));
    }

    public boolean isDefined(String key) {
        return this.isDefined(this.project, key);
    }

    public boolean isDefined(IProject project, String key) {
        return this.getApplicableLevel(project, key, null) == null;
    }

    public boolean isaPreferencesLevel(String possibleLevel) {
        int i = 0;
        while (i < levels.length) {
            if (levels[i].equals(possibleLevel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IEclipsePreferences getRootNode() {
        return this.preferencesService.getRootNode();
    }

    public IEclipsePreferences getNodeForLevel(String level) {
        if (level == null) {
            throw new IllegalArgumentException("PreferencesService.getNodeForLevel:  given level is null");
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getNodeForLevel:  given level '" + level + "' is not a real level");
        }
        if (level.equals("project") && this.projectScope == null) {
            throw new IllegalStateException("PreferencesService.getNodeForLevel:  node for project requested when project scope is null");
        }
        IEclipsePreferences node = null;
        if (level.equals("project")) {
            node = this.projectScope.getNode(this.languageName);
        } else if (level.equals("instance")) {
            node = this.instanceScope.getNode(this.languageName);
        } else if (level.equals("configuration")) {
            node = this.configurationScope.getNode(this.languageName);
        } else if (level.equals("default")) {
            node = this.defaultScope.getNode(this.languageName);
        }
        return node;
    }

    public IEclipsePreferences[] getNodesForLevels() {
        if (this.languageName == null || this.languageName.equals("")) {
            throw new IllegalStateException("PreferencesService.getNodesForLevels:  language name is invalid (null or empty); no associated preferences nodes");
        }
        IEclipsePreferences[] nodes = new IEclipsePreferences[]{this.projectScope != null ? this.projectScope.getNode(this.languageName) : null, this.instanceScope.getNode(this.languageName), this.configurationScope.getNode(this.languageName), this.defaultScope.getNode(this.languageName)};
        return nodes;
    }

    public IScopeContext getScopeForLevel(String level) {
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getScopeForLevel:  level = '" + level + "' is not a valid level");
        }
        IScopeContext result = null;
        if (level.equals("project")) {
            if (this.projectScope == null) {
                return null;
            }
            return this.projectScope;
        }
        if (level.equals("instance")) {
            return this.instanceScope;
        }
        if (level.equals("configuration")) {
            return this.configurationScope;
        }
        if (level.equals("default")) {
            return this.defaultScope;
        }
        return result;
    }

    public IScopeContext getScopeForProject(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("PreferencesService.getScopeForProject:  given project is null");
        }
        return new ProjectScope(project);
    }

    public IEclipsePreferences[] getNodesForLevels(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("PreferencesService.getNodesForLevels:  given project is null");
        }
        IEclipsePreferences[] nodes = new IEclipsePreferences[]{new ProjectScope(project).getNode(this.languageName), this.instanceScope.getNode(this.languageName), this.configurationScope.getNode(this.languageName), this.defaultScope.getNode(this.languageName)};
        return nodes;
    }

    public IEclipsePreferences getNodeForProject(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("PreferencesService.getNodeForProject:  given project is null");
        }
        return new ProjectScope(project).getNode(this.languageName);
    }

    public int getIndexForLevel(String level) {
        if (level == null) {
            return 0;
        }
        if (!this.isaPreferencesLevel(level)) {
            throw new IllegalArgumentException("PreferencesService.getIndexForLevel:  level = '" + level + "' is not a valid level");
        }
        if (level.equals("project")) {
            return 0;
        }
        if (level.equals("instance")) {
            return 1;
        }
        if (level.equals("configuration")) {
            return 2;
        }
        if (level.equals("default")) {
            return 3;
        }
        throw new IllegalStateException("PreferencesService.getIndexForLevel:  found no index to return for level = " + level);
    }

    public void addProjectSelectionListener(IPreferencesService.IProjectSelectionListener listener) {
        this.projectSelectionListeners.add(listener);
    }

    public void removeProjectSelectionListener(IPreferencesService.IProjectSelectionListener listener) {
        this.projectSelectionListeners.remove(listener);
    }

    protected void fireProjectSelectionEvent(final IPreferencesService.ProjectSelectionEvent event) {
        if (this.projectSelectionListeners == null || this.projectSelectionListeners.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.projectSelectionListeners.size()) {
            final IPreferencesService.IProjectSelectionListener listener = (IPreferencesService.IProjectSelectionListener)this.projectSelectionListeners.get(i);
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.selection(event);
                }
            };
            Platform.run((ISafeRunnable)job);
            ++i;
        }
    }

    private static interface ConstantEvaluator {
        public String getValue();
    }

    private static interface ParamEvaluator {
        public String getValue(String var1);
    }
}

