/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractExecutor;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.AbstractInterpretedInvocation;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.SimpleConnection;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationConstructor;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationManagerInternal;
import org.junit.Test;

public class RuntimeConnectionTests
extends TestCase {
    public @NonNull String getName() {
        return TestUtil.getName((String)this.getTestName());
    }

    public @NonNull String getTestName() {
        return (String)ClassUtil.nonNullState((Object)super.getName());
    }

    @Test
    public void testRuntime_DoubleSimpleConnection() {
        Tester tester = new Tester();
        TestConnection connection0 = tester.createConsumedConnection();
        TestConnection connection1 = tester.createConsumedConnection();
        tester.check("");
        tester.check("");
        connection0.append();
        tester.check("");
        connection1.append();
        tester.check("900");
        tester.check("900");
        connection1.append();
        tester.check("900,901");
        connection1.append();
        tester.check("900,901,902");
        connection0.append();
        tester.check("900,901,902,910,911,912");
        connection1.append();
        tester.check("900,901,902,903,910,911,912,913");
        connection0.append();
        connection0.append();
        connection0.append();
        tester.check();
        connection1.append();
        connection1.append();
        tester.check();
        tester.check();
        tester.dispose();
    }

    @Test
    public void testRuntime_RedundantDoubleSimpleConnection() {
        Tester tester = new Tester();
        TestConnection connection0 = tester.createConsumedConnection();
        tester.addConsumedConnection(connection0);
        tester.check("");
        tester.check("");
        connection0.append();
        tester.check("900");
        tester.check("900");
        connection0.append();
        tester.check("900,901,910,911");
        connection0.append();
        tester.check("900,901,902,910,911,912,920,921,922");
        connection0.append();
        tester.check();
        connection0.append();
        tester.check();
        connection0.append();
        connection0.append();
        connection0.append();
        tester.check();
        connection0.append();
        connection0.append();
        tester.check();
        tester.check();
        tester.dispose();
    }

    @Test
    public void testRuntime_SingleSimpleConnection() {
        Tester tester = new Tester();
        TestConnection connection0 = tester.createConsumedConnection();
        tester.check("");
        tester.check("");
        connection0.append();
        tester.check("90");
        tester.check("90");
        connection0.append();
        connection0.append();
        tester.check("90,91,92");
        connection0.append();
        tester.check("90,91,92,93");
        connection0.append();
        connection0.append();
        connection0.append();
        tester.check("90,91,92,93,94,95,96");
        tester.check();
        tester.dispose();
    }

    @Test
    public void testRuntime_TripleSimpleConnection() {
        Tester tester = new Tester();
        TestConnection connection0 = tester.createConsumedConnection();
        TestConnection connection1 = tester.createConsumedConnection();
        TestConnection connection2 = tester.createConsumedConnection();
        tester.check("");
        tester.check("");
        connection0.append();
        tester.check("");
        connection1.append();
        tester.check("");
        connection2.append();
        tester.check("9000");
        tester.check("9000");
        connection1.append();
        tester.check("9000,9010");
        connection1.append();
        tester.check("9000,9010,9020");
        connection0.append();
        tester.check("9000,9010,9020,9100,9110,9120");
        connection2.append();
        tester.check("9000,9001,9010,9011,9020,9021,9100,9101,9110,9111,9120,9121");
        connection0.append();
        connection1.append();
        connection0.append();
        tester.check();
        connection1.append();
        connection1.append();
        tester.check();
        connection2.append();
        connection2.append();
        tester.check();
        connection0.append();
        tester.check();
        tester.check();
        tester.dispose();
    }

    public static final class TestConnection
    extends SimpleConnection {
        private Integer counter = 0;

        public TestConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId) {
            super(interval, name, typeId);
        }

        public void append() {
            Integer n = this.counter;
            this.counter = n + 1;
            this.appendElement(n);
        }
    }

    public static final class TestExecutor
    extends AbstractExecutor {
        public TestExecutor(@NonNull EnvironmentFactory environmentFactory) {
            super((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory);
        }

        public @NonNull ModelManager getModelManager() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class TestInvocation
    extends AbstractInterpretedInvocation {
        protected final @NonNull TestInvocationConstructor invocationConstructor;

        public TestInvocation(@NonNull TestInvocationConstructor invocationConstructor, @NonNull Object @NonNull [] values) {
            super((InvocationConstructor)invocationConstructor, values);
            this.invocationConstructor = invocationConstructor;
        }

        public boolean execute() throws InvocationFailedException {
            this.invocationConstructor.executed(this.values);
            return false;
        }
    }

    public static final class TestInvocationConstructor
    extends AbstractInvocationConstructor {
        protected final @NonNull Set<@NonNull Integer> allValues = new HashSet<Integer>();

        public TestInvocationConstructor(@NonNull InvocationManager invocationManager, @NonNull String name, boolean isStrict) {
            super(invocationManager, name, isStrict);
        }

        public void executed(@NonNull Object @NonNull [] values) {
            int intValue = this.compositeValue(values);
            boolean wasAdded = this.allValues.add(intValue);
            TestCase.assertTrue((boolean)wasAdded);
        }

        public void check(int consumerIndex, @NonNull Object @NonNull [] values, @NonNull List<@NonNull TestConnection> testConnections) {
            if (consumerIndex >= testConnections.size()) {
                int intValue = this.compositeValue(values);
                TestCase.assertTrue((boolean)this.allValues.contains(intValue));
            } else {
                int i = 0;
                while (i < testConnections.get(consumerIndex).counter) {
                    values[consumerIndex] = i;
                    this.check(consumerIndex + 1, values, testConnections);
                    ++i;
                }
            }
        }

        private int compositeValue(@NonNull Object @NonNull [] values) {
            int intValue = 9;
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull Object value = objectArray[n2];
                intValue = 10 * intValue + (Integer)value;
                ++n2;
            }
            return intValue;
        }

        public @NonNull Invocation newInstance(@NonNull Object @NonNull [] values) {
            return new TestInvocation(this, values);
        }

        public @NonNull String stringValue() {
            ArrayList<@NonNull Integer> intValues = new ArrayList<Integer>(this.allValues);
            Collections.sort(intValues);
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i < intValues.size()) {
                if (i != 0) {
                    s.append(",");
                }
                s.append(intValues.get(i));
                ++i;
            }
            return s.toString();
        }
    }

    public static final class TestInvocationManager
    extends AbstractInvocationManagerInternal {
        public TestInvocationManager(@NonNull Executor executor) {
            super(executor);
        }
    }

    public static final class Tester {
        protected final @NonNull OCL ocl;
        protected final @NonNull TestExecutor executor;
        protected final @NonNull TestInvocationManager invocationManager;
        protected final @NonNull TestInvocationConstructor invocationConstructor;
        protected final @NonNull List<@NonNull TestConnection> testConnections = new ArrayList<TestConnection>();

        public Tester() {
            this.ocl = OCL.newInstance();
            this.executor = new TestExecutor(this.ocl.getEnvironmentFactory());
            this.invocationManager = new TestInvocationManager((Executor)this.executor);
            this.invocationConstructor = new TestInvocationConstructor((InvocationManager)this.invocationManager, "name", false);
        }

        public void addConsumedConnection(@NonNull TestConnection testConnection) {
            this.invocationConstructor.addConsumedConnection((Connection)testConnection);
            this.testConnections.add(testConnection);
        }

        public void check() {
            StringBuilder s = new StringBuilder();
            this.check(0, "9", s);
            this.check(s.toString());
        }

        private void check(int connectionIndex, @NonNull String partialString, @NonNull StringBuilder s) {
            if (connectionIndex < this.testConnections.size()) {
                int i = 0;
                while (i < this.testConnections.get(connectionIndex).counter) {
                    this.check(connectionIndex + 1, String.valueOf(partialString) + i, s);
                    ++i;
                }
            } else {
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(partialString);
            }
        }

        public void check(@Nullable String stringValue) {
            this.invocationManager.flush();
            if (stringValue != null) {
                RuntimeConnectionTests.assertEquals((String)stringValue, (String)this.invocationConstructor.stringValue());
            }
            int product = 1;
            for (TestConnection testConnection : this.testConnections) {
                product *= testConnection.counter.intValue();
            }
            TestCase.assertEquals((int)product, (int)this.invocationConstructor.allValues.size());
            @NonNull Object[] values = new Object[this.testConnections.size()];
            this.invocationConstructor.check(0, values, this.testConnections);
        }

        public @NonNull TestConnection createConsumedConnection() {
            String name = "connection" + this.testConnections.size();
            TestConnection testConnection = new TestConnection(this.invocationManager.getRootInterval(), name, (TypeId)TypeId.INTEGER);
            this.addConsumedConnection(testConnection);
            return testConnection;
        }

        public void dispose() {
            this.ocl.dispose();
        }

        public @NonNull TestInvocationConstructor getInvocationConstructor() {
            return this.invocationConstructor;
        }
    }
}

