/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.runtime.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtCompilerFacade;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.WorkspaceQvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.UriMappingAwareResourceSet;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtoTransformationHelper {
    private final URI myTransfUri;

    public QvtoTransformationHelper(URI transfUri) {
        this.myTransfUri = transfUri;
    }

    public QvtoTransformationHelper(IFile qvtoFile) {
        this(URI.createPlatformResourceURI((String)qvtoFile.getFullPath().toString(), (boolean)false));
    }

    public TransfExecutionResult executeTransformation(final List<? extends EObject> inObjects, final Map<String, Object> inConfigProperties, ResourceSet metamodelResourceSet) throws CoreException {
        try {
            if (metamodelResourceSet == null) {
                metamodelResourceSet = new ResourceSetImpl();
            }
            ResourceSet wrappedMetamodelResourceSet = metamodelResourceSet;
            QvtModule qvtModule = TransformationUtil.getQvtModule(this.myTransfUri);
            if (qvtModule instanceof WorkspaceQvtModule) {
                WorkspaceQvtModule workspaceQvtModule = (WorkspaceQvtModule)qvtModule;
                IFile transformationFile = workspaceQvtModule.getTransformationFile();
                wrappedMetamodelResourceSet = new UriMappingAwareResourceSet(metamodelResourceSet, transformationFile);
            }
            final ArrayList outExtents = new ArrayList();
            final ArrayList outMainParams = new ArrayList();
            final ArrayList outTraces = new ArrayList(1);
            final ArrayList outConsole = new ArrayList(1);
            final QvtInterpretedTransformation transf = new QvtInterpretedTransformation(qvtModule);
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setGenerateCompletionData(false);
            options.setMetamodelResourceSet(wrappedMetamodelResourceSet);
            transf.setQvtCompilerOptions(options);
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    ArrayList<ModelContent> inModels = new ArrayList<ModelContent>(inObjects.size());
                    for (EObject inObj : inObjects) {
                        inModels.add(new ModelContent(Collections.singletonList(inObj)));
                    }
                    QvtLaunchConfigurationDelegateBase.doLaunch(transf, inModels, inConfigProperties, outExtents, outMainParams, outTraces, outConsole);
                    transf.cleanup();
                }
            };
            r = QvtLaunchConfigurationDelegateBase.getSafeRunnable(transf, r);
            r.run();
            final ArrayList<2> extents = new ArrayList<2>();
            Iterator iterator = outExtents.iterator();
            while (iterator.hasNext()) {
                ModelExtentContents nextExtent;
                final ModelExtentContents internExtent = nextExtent = (ModelExtentContents)iterator.next();
                ModelExtent modelExtent = new ModelExtent(){

                    @Override
                    public List<EObject> getAllRootElements() {
                        return internExtent.getAllRootElements();
                    }

                    @Override
                    public List<EObject> getInitialElements() {
                        return internExtent.getInitialElements();
                    }
                };
                extents.add(modelExtent);
            }
            return new TransfExecutionResult(){

                @Override
                public List<ModelExtent> getOutModelExtents() {
                    return extents;
                }

                @Override
                public List<EObject> getOutParameters() {
                    return outMainParams;
                }

                @Override
                public String getConsoleOutput() {
                    return outConsole.isEmpty() ? "" : (String)outConsole.get(0);
                }
            };
        }
        catch (MdaException e) {
            throw new CoreException((IStatus)(e.getStatus() != null ? e.getStatus() : new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage())));
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage()));
        }
    }

    public List<URI> getImportedTransformations() throws CoreException {
        try {
            ArrayList<URI> importUris = new ArrayList<URI>();
            QvtCompilerOptions compilerOptions = new QvtCompilerOptions();
            compilerOptions.setGenerateCompletionData(true);
            CompiledUnit compiledUnit = QvtCompilerFacade.getCompiledModule(this.myTransfUri, compilerOptions, null).getCompiledModule();
            IFile file = URIUtils.getFile((URI)compiledUnit.getURI());
            if (file == null) {
                throw new MdaException(NLS.bind((String)Messages.ImportedTransformation_NoWsFileForLocation, (Object)compiledUnit.getURI().toPlatformString(true)));
            }
            importUris.add(compiledUnit.getURI());
            LinkedHashSet imports = new LinkedHashSet();
            QvtOperationalParserUtil.collectAllImports((CompiledUnit)compiledUnit, imports);
            for (CompiledUnit importedUnit : imports) {
                URI unitURI = importedUnit.getURI();
                IFile ifile = URIUtils.getFile((URI)unitURI);
                if (ifile == null) continue;
                importUris.add(URI.createPlatformResourceURI((String)ifile.getFullPath().toString(), (boolean)false));
            }
            return importUris;
        }
        catch (MdaException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage()));
        }
    }

    public List<String> getInputModelExtensions() throws CoreException {
        try {
            QvtModule qvtModule = TransformationUtil.getQvtModule(this.myTransfUri);
            ArrayList<String> extensions = new ArrayList<String>();
            for (QvtTransformation.TransformationParameter param : qvtModule.getParameters()) {
                if (param.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.OUT || param.getMetamodels().isEmpty()) continue;
                extensions.add(param.getMetamodels().get(0).getName());
            }
            return extensions;
        }
        catch (MdaException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.runtime", e.getMessage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ModelExtent {
        public List<EObject> getInitialElements();

        public List<EObject> getAllRootElements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TransfExecutionResult {
        public List<ModelExtent> getOutModelExtents();

        public List<EObject> getOutParameters();

        public String getConsoleOutput();
    }
}

