/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.ui.common.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class DiscoveryUiUtil {
    private DiscoveryUiUtil() {
    }

    public static Shell getShell() {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        Shell modal = DiscoveryUiUtil.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return DiscoveryUiUtil.getNonModalShell();
    }

    public static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Shell shell2 = shellArray[n2];
            if (shell2.equals(shell)) break;
            if (shell2.isVisible() && ((style = shell2.getStyle()) & modal) != 0) {
                return shell2;
            }
            ++n2;
        }
        return null;
    }

    public static void displayStatus(Shell shell, String title, IStatus status, boolean showLinkToErrorLog) {
        String message = status.getMessage();
        if (showLinkToErrorLog) {
            message = String.valueOf(message) + "  \n see error log";
        }
        switch (status.getSeverity()) {
            case 1: 
            case 8: {
                DiscoveryUiUtil.createDialog(shell, title, message, 2).open();
                break;
            }
            case 2: {
                DiscoveryUiUtil.createDialog(shell, title, message, 4).open();
                break;
            }
            default: {
                DiscoveryUiUtil.createDialog(shell, title, message, 1).open();
            }
        }
    }

    public static MessageDialog createDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }
}

