/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.server.protocol;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.net4j.buddies.common.IAccount;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.buddies.internal.server.bundle.OM;
import org.eclipse.net4j.buddies.internal.server.messages.Messages;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddiesServerProtocol;
import org.eclipse.net4j.buddies.internal.server.protocol.BuddyAddedNotification;
import org.eclipse.net4j.buddies.server.IBuddyAdmin;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class OpenSessionIndication
extends IndicationWithResponse {
    private IAccount account;
    private IBuddy[] buddies;

    public OpenSessionIndication(BuddiesServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)1);
    }

    protected boolean closeChannelAfterException() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indicating(ExtendedDataInputStream in) throws Exception {
        String userID = in.readString();
        String password = in.readString();
        int size = in.readInt();
        String[] facilityTypes = new String[size];
        int i = 0;
        while (i < size) {
            facilityTypes[i] = in.readString();
            ++i;
        }
        IBuddyAdmin iBuddyAdmin = IBuddyAdmin.INSTANCE;
        synchronized (iBuddyAdmin) {
            this.buddies = IBuddyAdmin.INSTANCE.getBuddies();
            ISession session = IBuddyAdmin.INSTANCE.openSession(this.getProtocol().getChannel(), userID, password, facilityTypes);
            if (session != null) {
                this.account = session.getSelf().getAccount();
            } else {
                OM.LOG.info(MessageFormat.format(Messages.getString("OpenSessionIndication.0"), userID));
            }
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        ProtocolUtil.writeAccount((ExtendedDataOutputStream)out, (IAccount)this.account);
        if (this.account != null) {
            ArrayList<BuddiesServerProtocol> protocols = new ArrayList<BuddiesServerProtocol>();
            out.writeInt(this.buddies.length);
            IBuddy[] iBuddyArray = this.buddies;
            int n = this.buddies.length;
            int n2 = 0;
            while (n2 < n) {
                IBuddy buddy = iBuddyArray[n2];
                out.writeString(buddy.getUserID());
                ISession buddySession = IBuddyAdmin.INSTANCE.getSession(buddy);
                if (buddySession != null) {
                    protocols.add((BuddiesServerProtocol)buddySession.getProtocol());
                }
                ++n2;
            }
            for (BuddiesServerProtocol protocol : protocols) {
                try {
                    new BuddyAddedNotification(protocol, this.account.getUserID()).sendAsync();
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }
}

