/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class MonitorTest
extends AbstractOMTest {
    public void testBeginNotCalledOnMonitor() throws Exception {
        Monitor monitor2;
        try {
            monitor2 = new Monitor();
            monitor2.worked();
            MonitorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException monitor2) {
            // empty catch block
        }
        try {
            monitor2 = new Monitor();
            monitor2.fork();
            MonitorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException monitor3) {
            // empty catch block
        }
        OMMonitor.Async async = null;
        try {
            try {
                Monitor monitor4 = new Monitor();
                async = monitor4.forkAsync();
                MonitorTest.fail((String)"IllegalStateException expected");
            }
            catch (IllegalStateException illegalStateException) {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            if (async != null) {
                async.stop();
            }
        }
    }

    public void testBeginNotCalledOnNestedMonitor() throws Exception {
        OMMonitor monitor2;
        try {
            monitor2 = new Monitor().begin().fork();
            monitor2.worked();
            MonitorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException monitor2) {
            // empty catch block
        }
        try {
            monitor2 = new Monitor().begin().fork();
            monitor2.fork();
            MonitorTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException monitor3) {
            // empty catch block
        }
        OMMonitor.Async async = null;
        try {
            try {
                OMMonitor monitor4 = new Monitor().begin().fork();
                async = monitor4.forkAsync();
                MonitorTest.fail((String)"IllegalStateException expected");
            }
            catch (IllegalStateException illegalStateException) {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            if (async != null) {
                async.stop();
            }
        }
    }

    public void testBeginCalledOnMonitor() throws Exception {
        OMMonitor monitor = new Monitor().begin();
        monitor.worked();
        monitor = new Monitor().begin();
        monitor.fork();
        OMMonitor.Async async = null;
        try {
            OMMonitor monitor2 = new Monitor().begin();
            async = monitor2.forkAsync();
        }
        finally {
            if (async != null) {
                async.stop();
            }
        }
    }

    public void testBeginCalledOnNestedMonitor() throws Exception {
        OMMonitor monitor = new Monitor().begin().fork().begin();
        monitor.worked();
        monitor = new Monitor().begin().fork().begin();
        monitor.fork();
        OMMonitor.Async async = null;
        try {
            OMMonitor monitor2 = new Monitor().begin().fork().begin();
            async = monitor2.forkAsync();
        }
        finally {
            if (async != null) {
                async.stop();
            }
        }
    }

    public void testProgress() throws Exception {
        Monitor monitor = new Monitor();
        MonitorTest.assertNotSame((Object)0.0, (Object)monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        monitor.begin(10.0);
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        int i = 0;
        while (i < 10) {
            monitor.worked();
            MonitorTest.assertEquals(10.0, monitor.getTotalWork());
            MonitorTest.assertEquals((double)i + 1.0, monitor.getWork());
            ++i;
        }
        monitor.done();
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(monitor.getTotalWork(), monitor.getWork());
        monitor = new Monitor();
        MonitorTest.assertNotSame((Object)0.0, (Object)monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        monitor.begin(10.0);
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        i = 0;
        while (i < 5) {
            monitor.worked();
            MonitorTest.assertEquals(10.0, monitor.getTotalWork());
            MonitorTest.assertEquals((double)i + 1.0, monitor.getWork());
            ++i;
        }
        monitor.done();
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(monitor.getTotalWork(), monitor.getWork());
    }

    public void testNestedProgress() throws Exception {
        OMMonitor main = new Monitor().begin();
        MonitorTest.assertEquals(1.0, main.getTotalWork());
        OMMonitor monitor = main.fork();
        MonitorTest.assertNotSame((Object)0.0, (Object)monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        monitor.begin(10.0);
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        int i = 0;
        while (i < 10) {
            monitor.worked();
            MonitorTest.assertEquals(10.0, monitor.getTotalWork());
            MonitorTest.assertEquals((double)i + 1.0, monitor.getWork());
            MonitorTest.assertSimilar(0.1 * (double)(i + 1), main.getWork(), 1000);
            ++i;
        }
        monitor.done();
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(monitor.getTotalWork(), monitor.getWork());
        MonitorTest.assertSimilar(1.0, main.getWork(), 1000);
        main = new Monitor().begin();
        MonitorTest.assertEquals(1.0, main.getTotalWork());
        monitor = main.fork();
        MonitorTest.assertNotSame((Object)0.0, (Object)monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        monitor.begin(10.0);
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(0.0, monitor.getWork());
        i = 0;
        while (i < 5) {
            monitor.worked();
            MonitorTest.assertEquals(10.0, monitor.getTotalWork());
            MonitorTest.assertEquals((double)i + 1.0, monitor.getWork());
            MonitorTest.assertSimilar(0.1 * (double)(i + 1), main.getWork(), 1000);
            ++i;
        }
        monitor.done();
        MonitorTest.assertEquals(10.0, monitor.getTotalWork());
        MonitorTest.assertEquals(monitor.getTotalWork(), monitor.getWork());
        MonitorTest.assertSimilar(1.0, main.getWork(), 1000);
    }

    public void testAsyncProgress() throws Exception {
        long PERIOD = 50L;
        OMMonitor main = new Monitor(){

            protected long getAsyncSchedulePeriod() {
                return 50L;
            }
        }.begin(3.0);
        main.worked();
        double work = main.getWork();
        MonitorTest.assertEquals(1.0, work);
        OMMonitor.Async async = main.forkAsync();
        int i = 0;
        while (i < 20) {
            MonitorTest.sleep(100L);
            double newWork = main.getWork();
            System.out.println(newWork);
            work = newWork;
            ++i;
        }
        async.stop();
        MonitorTest.assertSimilar(2.0, main.getWork(), 1000);
        main.worked();
        MonitorTest.assertSimilar(3.0, main.getWork(), 1000);
    }
}

