/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.channel;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

public class ChannelInputStream
extends BufferInputStream {
    private IChannel channel;
    private long millisBeforeTimeout = -1L;
    private long millisInterruptCheck = 100L;

    public ChannelInputStream(IChannel channel) {
        this(channel, -1L);
    }

    public ChannelInputStream(IChannel channel, long millisBeforeTimeout) {
        this.channel = channel;
        this.millisBeforeTimeout = millisBeforeTimeout;
        channel.setReceiveHandler(this);
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public long getMillisBeforeTimeout() {
        return this.millisBeforeTimeout;
    }

    public void setMillisBeforeTimeout(long millisBeforeTimeout) {
        this.millisBeforeTimeout = millisBeforeTimeout;
    }

    public long getMillisInterruptCheck() {
        return this.millisInterruptCheck;
    }

    public void setMillisInterruptCheck(long millisInterruptCheck) {
        this.millisInterruptCheck = millisInterruptCheck;
    }

    public int read() throws IOException {
        if (this.isCCAM()) {
            ExecutorService executorService = ConcurrencyUtil.getExecutorService((Object)this.channel);
            executorService.submit(new Runnable(){

                public void run() {
                    ConcurrencyUtil.sleep((long)500L);
                    ChannelInputStream.this.channel.close();
                }
            });
        }
        return super.read();
    }

    public String toString() {
        return "ChannelInputStream[" + this.channel + "]";
    }
}

